/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Title_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biblio.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIBLIO_TITLE_BASE_HPP
#define OBJECTS_BIBLIO_TITLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Title Group
/// Valid for = A = Analytic (Cit-art)
///             J = Journals (Cit-jour)
///             B = Book (Cit-book)
/// Valid for:
class NCBI_BIBLIO_EXPORT CTitle_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTitle_Base(void);
    // destructor
    virtual ~CTitle_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_BIBLIO_EXPORT C_E : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_E(void);
        // destructor
        ~C_E(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Name,         ///< Title, Anal,Coll,Mono    AJB
            e_Tsub,         ///< Title, Subordinate       A B
            e_Trans,        ///< Title, Translated        AJB
            e_Jta,          ///< Title, Abbreviated        J
            e_Iso_jta,      ///< specifically ISO jta      J
            e_Ml_jta,       ///< specifically MEDLINE jta  J
            e_Coden,        ///< a coden                   J
            e_Issn,         ///< ISSN                      J
            e_Abr,          ///< Title, Abbreviated         B
            e_Isbn          ///< ISBN                       B
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 11 ///< == e_Isbn+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef string TName;
        typedef string TTsub;
        typedef string TTrans;
        typedef string TJta;
        typedef string TIso_jta;
        typedef string TMl_jta;
        typedef string TCoden;
        typedef string TIssn;
        typedef string TAbr;
        typedef string TIsbn;
    
        // getters
        // setters
    
        // typedef string TName
        bool IsName(void) const;
        const TName& GetName(void) const;
        TName& SetName(void);
        void SetName(const TName& value);
    
        // typedef string TTsub
        bool IsTsub(void) const;
        const TTsub& GetTsub(void) const;
        TTsub& SetTsub(void);
        void SetTsub(const TTsub& value);
    
        // typedef string TTrans
        bool IsTrans(void) const;
        const TTrans& GetTrans(void) const;
        TTrans& SetTrans(void);
        void SetTrans(const TTrans& value);
    
        // typedef string TJta
        bool IsJta(void) const;
        const TJta& GetJta(void) const;
        TJta& SetJta(void);
        void SetJta(const TJta& value);
    
        // typedef string TIso_jta
        bool IsIso_jta(void) const;
        const TIso_jta& GetIso_jta(void) const;
        TIso_jta& SetIso_jta(void);
        void SetIso_jta(const TIso_jta& value);
    
        // typedef string TMl_jta
        bool IsMl_jta(void) const;
        const TMl_jta& GetMl_jta(void) const;
        TMl_jta& SetMl_jta(void);
        void SetMl_jta(const TMl_jta& value);
    
        // typedef string TCoden
        bool IsCoden(void) const;
        const TCoden& GetCoden(void) const;
        TCoden& SetCoden(void);
        void SetCoden(const TCoden& value);
    
        // typedef string TIssn
        bool IsIssn(void) const;
        const TIssn& GetIssn(void) const;
        TIssn& SetIssn(void);
        void SetIssn(const TIssn& value);
    
        // typedef string TAbr
        bool IsAbr(void) const;
        const TAbr& GetAbr(void) const;
        TAbr& SetAbr(void);
        void SetAbr(const TAbr& value);
    
        // typedef string TIsbn
        bool IsIsbn(void) const;
        const TIsbn& GetIsbn(void) const;
        TIsbn& SetIsbn(void);
        void SetIsbn(const TIsbn& value);
    
    
    private:
        // copy constructor and assignment operator
        C_E(const C_E& );
        C_E& operator=(const C_E& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            void* m_dummy_pointer_for_alignment;
        };
    };
    // types
    typedef list< CRef< C_E > > Tdata;

    // getters
    // setters

    /// mandatory
    /// typedef list< CRef< C_E > > Tdata
    ///  Check whether the  data member has been assigned a value.
    bool IsSet(void) const;
    /// Check whether it is safe or not to call Get method.
    bool CanGet(void) const;
    void Reset(void);
    const Tdata& Get(void) const;
    Tdata& Set(void);

    /// Conversion operator to 'const Tdata' type.
    operator const Tdata& (void) const;
    /// Conversion operator to 'Tdata' type.
    operator Tdata& (void);



private:
    // Prohibit copy constructor and assignment operator
    CTitle_Base(const CTitle_Base&);
    CTitle_Base& operator=(const CTitle_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< C_E > > m_data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CTitle_Base::C_E::E_Choice CTitle_Base::C_E::Which(void) const
{
    return m_choice;
}

inline
void CTitle_Base::C_E::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CTitle_Base::C_E::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CTitle_Base::C_E::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CTitle_Base::C_E::IsName(void) const
{
    return m_choice == e_Name;
}

inline
const CTitle_Base::C_E::TName& CTitle_Base::C_E::GetName(void) const
{
    CheckSelected(e_Name);
    return *m_string;
}

inline
CTitle_Base::C_E::TName& CTitle_Base::C_E::SetName(void)
{
    Select(e_Name, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CTitle_Base::C_E::IsTsub(void) const
{
    return m_choice == e_Tsub;
}

inline
const CTitle_Base::C_E::TTsub& CTitle_Base::C_E::GetTsub(void) const
{
    CheckSelected(e_Tsub);
    return *m_string;
}

inline
CTitle_Base::C_E::TTsub& CTitle_Base::C_E::SetTsub(void)
{
    Select(e_Tsub, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CTitle_Base::C_E::IsTrans(void) const
{
    return m_choice == e_Trans;
}

inline
const CTitle_Base::C_E::TTrans& CTitle_Base::C_E::GetTrans(void) const
{
    CheckSelected(e_Trans);
    return *m_string;
}

inline
CTitle_Base::C_E::TTrans& CTitle_Base::C_E::SetTrans(void)
{
    Select(e_Trans, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CTitle_Base::C_E::IsJta(void) const
{
    return m_choice == e_Jta;
}

inline
const CTitle_Base::C_E::TJta& CTitle_Base::C_E::GetJta(void) const
{
    CheckSelected(e_Jta);
    return *m_string;
}

inline
CTitle_Base::C_E::TJta& CTitle_Base::C_E::SetJta(void)
{
    Select(e_Jta, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CTitle_Base::C_E::IsIso_jta(void) const
{
    return m_choice == e_Iso_jta;
}

inline
const CTitle_Base::C_E::TIso_jta& CTitle_Base::C_E::GetIso_jta(void) const
{
    CheckSelected(e_Iso_jta);
    return *m_string;
}

inline
CTitle_Base::C_E::TIso_jta& CTitle_Base::C_E::SetIso_jta(void)
{
    Select(e_Iso_jta, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CTitle_Base::C_E::IsMl_jta(void) const
{
    return m_choice == e_Ml_jta;
}

inline
const CTitle_Base::C_E::TMl_jta& CTitle_Base::C_E::GetMl_jta(void) const
{
    CheckSelected(e_Ml_jta);
    return *m_string;
}

inline
CTitle_Base::C_E::TMl_jta& CTitle_Base::C_E::SetMl_jta(void)
{
    Select(e_Ml_jta, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CTitle_Base::C_E::IsCoden(void) const
{
    return m_choice == e_Coden;
}

inline
const CTitle_Base::C_E::TCoden& CTitle_Base::C_E::GetCoden(void) const
{
    CheckSelected(e_Coden);
    return *m_string;
}

inline
CTitle_Base::C_E::TCoden& CTitle_Base::C_E::SetCoden(void)
{
    Select(e_Coden, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CTitle_Base::C_E::IsIssn(void) const
{
    return m_choice == e_Issn;
}

inline
const CTitle_Base::C_E::TIssn& CTitle_Base::C_E::GetIssn(void) const
{
    CheckSelected(e_Issn);
    return *m_string;
}

inline
CTitle_Base::C_E::TIssn& CTitle_Base::C_E::SetIssn(void)
{
    Select(e_Issn, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CTitle_Base::C_E::IsAbr(void) const
{
    return m_choice == e_Abr;
}

inline
const CTitle_Base::C_E::TAbr& CTitle_Base::C_E::GetAbr(void) const
{
    CheckSelected(e_Abr);
    return *m_string;
}

inline
CTitle_Base::C_E::TAbr& CTitle_Base::C_E::SetAbr(void)
{
    Select(e_Abr, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CTitle_Base::C_E::IsIsbn(void) const
{
    return m_choice == e_Isbn;
}

inline
const CTitle_Base::C_E::TIsbn& CTitle_Base::C_E::GetIsbn(void) const
{
    CheckSelected(e_Isbn);
    return *m_string;
}

inline
CTitle_Base::C_E::TIsbn& CTitle_Base::C_E::SetIsbn(void)
{
    Select(e_Isbn, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CTitle_Base::IsSet(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTitle_Base::CanGet(void) const
{
    return true;
}

inline
const CTitle_Base::Tdata& CTitle_Base::Get(void) const
{
    return m_data;
}

inline
CTitle_Base::Tdata& CTitle_Base::Set(void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

inline
CTitle_Base::operator const CTitle_Base::Tdata& (void) const
{
    return m_data;
}

inline
CTitle_Base::operator CTitle_Base::Tdata& (void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIBLIO_TITLE_BASE_HPP
