/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PubStatusDate_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biblio.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIBLIO_PUBSTATUSDATE_BASE_HPP
#define OBJECTS_BIBLIO_PUBSTATUSDATE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/biblio/PubStatus.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDate;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// done as a structure so fields can be added
class NCBI_BIBLIO_EXPORT CPubStatusDate_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPubStatusDate_Base(void);
    // destructor
    virtual ~CPubStatusDate_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TPubstatus;
    typedef CDate TDate;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_pubstatus,
        e_date
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TPubstatus
    ///  Check whether the Pubstatus data member has been assigned a value.
    bool IsSetPubstatus(void) const;
    /// Check whether it is safe or not to call GetPubstatus method.
    bool CanGetPubstatus(void) const;
    void ResetPubstatus(void);
    TPubstatus GetPubstatus(void) const;
    void SetPubstatus(TPubstatus value);
    TPubstatus& SetPubstatus(void);

    /// time may be added later
    /// mandatory
    /// typedef CDate TDate
    ///  Check whether the Date data member has been assigned a value.
    bool IsSetDate(void) const;
    /// Check whether it is safe or not to call GetDate method.
    bool CanGetDate(void) const;
    void ResetDate(void);
    const TDate& GetDate(void) const;
    void SetDate(TDate& value);
    TDate& SetDate(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPubStatusDate_Base(const CPubStatusDate_Base&);
    CPubStatusDate_Base& operator=(const CPubStatusDate_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Pubstatus;
    CRef< TDate > m_Date;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPubStatusDate_Base::IsSetPubstatus(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPubStatusDate_Base::CanGetPubstatus(void) const
{
    return IsSetPubstatus();
}

inline
void CPubStatusDate_Base::ResetPubstatus(void)
{
    m_Pubstatus = (int)(0);
    m_set_State[0] &= ~0x3;
}

inline
CPubStatusDate_Base::TPubstatus CPubStatusDate_Base::GetPubstatus(void) const
{
    if (!CanGetPubstatus()) {
        ThrowUnassigned(0);
    }
    return m_Pubstatus;
}

inline
void CPubStatusDate_Base::SetPubstatus(CPubStatusDate_Base::TPubstatus value)
{
    m_Pubstatus = value;
    m_set_State[0] |= 0x3;
}

inline
CPubStatusDate_Base::TPubstatus& CPubStatusDate_Base::SetPubstatus(void)
{
#ifdef _DEBUG
    if (!IsSetPubstatus()) {
        memset(&m_Pubstatus,UnassignedByte(),sizeof(m_Pubstatus));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Pubstatus;
}

inline
bool CPubStatusDate_Base::IsSetDate(void) const
{
    return m_Date.NotEmpty();
}

inline
bool CPubStatusDate_Base::CanGetDate(void) const
{
    return true;
}

inline
const CPubStatusDate_Base::TDate& CPubStatusDate_Base::GetDate(void) const
{
    if ( !m_Date ) {
        const_cast<CPubStatusDate_Base*>(this)->ResetDate();
    }
    return (*m_Date);
}

inline
CPubStatusDate_Base::TDate& CPubStatusDate_Base::SetDate(void)
{
    if ( !m_Date ) {
        ResetDate();
    }
    return (*m_Date);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIBLIO_PUBSTATUSDATE_BASE_HPP
