/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cit_pat_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biblio.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIBLIO_CIT_PAT_BASE_HPP
#define OBJECTS_BIBLIO_CIT_PAT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAuth_list;
class CDate;
class CPatent_priority;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Patent number and date-issue were made optional in 1997 to
///   support patent applications being issued from the USPTO
///   Semantically a Cit-pat must have either a patent number or
///   an application number (or both) to be valid
/// patent citation
class NCBI_BIBLIO_EXPORT CCit_pat_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCit_pat_Base(void);
    // destructor
    virtual ~CCit_pat_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TTitle;
    typedef CAuth_list TAuthors;
    typedef string TCountry;
    typedef string TDoc_type;
    typedef string TNumber;
    typedef CDate TDate_issue;
    typedef list< string > TClass;
    typedef string TApp_number;
    typedef CDate TApp_date;
    typedef CAuth_list TApplicants;
    typedef CAuth_list TAssignees;
    typedef list< CRef< CPatent_priority > > TPriority;
    typedef string TAbstract;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_title,
        e_authors,
        e_country,
        e_doc_type,
        e_number,
        e_date_issue,
        e_class,
        e_app_number,
        e_app_date,
        e_applicants,
        e_assignees,
        e_priority,
        e_abstract
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 14> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// author/inventor
    /// mandatory
    /// typedef CAuth_list TAuthors
    ///  Check whether the Authors data member has been assigned a value.
    bool IsSetAuthors(void) const;
    /// Check whether it is safe or not to call GetAuthors method.
    bool CanGetAuthors(void) const;
    void ResetAuthors(void);
    const TAuthors& GetAuthors(void) const;
    void SetAuthors(TAuthors& value);
    TAuthors& SetAuthors(void);

    /// Patent Document Country
    /// mandatory
    /// typedef string TCountry
    ///  Check whether the Country data member has been assigned a value.
    bool IsSetCountry(void) const;
    /// Check whether it is safe or not to call GetCountry method.
    bool CanGetCountry(void) const;
    void ResetCountry(void);
    const TCountry& GetCountry(void) const;
    void SetCountry(const TCountry& value);
    void SetCountry(TCountry&& value);
    TCountry& SetCountry(void);

    /// Patent Document Type
    /// mandatory
    /// typedef string TDoc_type
    ///  Check whether the Doc_type data member has been assigned a value.
    bool IsSetDoc_type(void) const;
    /// Check whether it is safe or not to call GetDoc_type method.
    bool CanGetDoc_type(void) const;
    void ResetDoc_type(void);
    const TDoc_type& GetDoc_type(void) const;
    void SetDoc_type(const TDoc_type& value);
    void SetDoc_type(TDoc_type&& value);
    TDoc_type& SetDoc_type(void);

    /// Patent Document Number
    /// optional
    /// typedef string TNumber
    ///  Check whether the Number data member has been assigned a value.
    bool IsSetNumber(void) const;
    /// Check whether it is safe or not to call GetNumber method.
    bool CanGetNumber(void) const;
    void ResetNumber(void);
    const TNumber& GetNumber(void) const;
    void SetNumber(const TNumber& value);
    void SetNumber(TNumber&& value);
    TNumber& SetNumber(void);

    /// Patent Issue/Pub Date
    /// optional
    /// typedef CDate TDate_issue
    ///  Check whether the Date_issue data member has been assigned a value.
    bool IsSetDate_issue(void) const;
    /// Check whether it is safe or not to call GetDate_issue method.
    bool CanGetDate_issue(void) const;
    void ResetDate_issue(void);
    const TDate_issue& GetDate_issue(void) const;
    void SetDate_issue(TDate_issue& value);
    TDate_issue& SetDate_issue(void);

    /// Patent Doc Class Code 
    /// optional
    /// typedef list< string > TClass
    ///  Check whether the Class data member has been assigned a value.
    bool IsSetClass(void) const;
    /// Check whether it is safe or not to call GetClass method.
    bool CanGetClass(void) const;
    void ResetClass(void);
    const TClass& GetClass(void) const;
    TClass& SetClass(void);

    /// Patent Doc Appl Number
    /// optional
    /// typedef string TApp_number
    ///  Check whether the App_number data member has been assigned a value.
    bool IsSetApp_number(void) const;
    /// Check whether it is safe or not to call GetApp_number method.
    bool CanGetApp_number(void) const;
    void ResetApp_number(void);
    const TApp_number& GetApp_number(void) const;
    void SetApp_number(const TApp_number& value);
    void SetApp_number(TApp_number&& value);
    TApp_number& SetApp_number(void);

    /// Patent Appl File Date
    /// optional
    /// typedef CDate TApp_date
    ///  Check whether the App_date data member has been assigned a value.
    bool IsSetApp_date(void) const;
    /// Check whether it is safe or not to call GetApp_date method.
    bool CanGetApp_date(void) const;
    void ResetApp_date(void);
    const TApp_date& GetApp_date(void) const;
    void SetApp_date(TApp_date& value);
    TApp_date& SetApp_date(void);

    /// Applicants
    /// optional
    /// typedef CAuth_list TApplicants
    ///  Check whether the Applicants data member has been assigned a value.
    bool IsSetApplicants(void) const;
    /// Check whether it is safe or not to call GetApplicants method.
    bool CanGetApplicants(void) const;
    void ResetApplicants(void);
    const TApplicants& GetApplicants(void) const;
    void SetApplicants(TApplicants& value);
    TApplicants& SetApplicants(void);

    /// Assignees
    /// optional
    /// typedef CAuth_list TAssignees
    ///  Check whether the Assignees data member has been assigned a value.
    bool IsSetAssignees(void) const;
    /// Check whether it is safe or not to call GetAssignees method.
    bool CanGetAssignees(void) const;
    void ResetAssignees(void);
    const TAssignees& GetAssignees(void) const;
    void SetAssignees(TAssignees& value);
    TAssignees& SetAssignees(void);

    /// Priorities
    /// optional
    /// typedef list< CRef< CPatent_priority > > TPriority
    ///  Check whether the Priority data member has been assigned a value.
    bool IsSetPriority(void) const;
    /// Check whether it is safe or not to call GetPriority method.
    bool CanGetPriority(void) const;
    void ResetPriority(void);
    const TPriority& GetPriority(void) const;
    TPriority& SetPriority(void);

    /// abstract of patent
    /// optional
    /// typedef string TAbstract
    ///  Check whether the Abstract data member has been assigned a value.
    bool IsSetAbstract(void) const;
    /// Check whether it is safe or not to call GetAbstract method.
    bool CanGetAbstract(void) const;
    void ResetAbstract(void);
    const TAbstract& GetAbstract(void) const;
    void SetAbstract(const TAbstract& value);
    void SetAbstract(TAbstract&& value);
    TAbstract& SetAbstract(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCit_pat_Base(const CCit_pat_Base&);
    CCit_pat_Base& operator=(const CCit_pat_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Title;
    CRef< TAuthors > m_Authors;
    string m_Country;
    string m_Doc_type;
    string m_Number;
    CRef< TDate_issue > m_Date_issue;
    list< string > m_Class;
    string m_App_number;
    CRef< TApp_date > m_App_date;
    CRef< TApplicants > m_Applicants;
    CRef< TAssignees > m_Assignees;
    list< CRef< CPatent_priority > > m_Priority;
    string m_Abstract;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCit_pat_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCit_pat_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CCit_pat_Base::TTitle& CCit_pat_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(0);
    }
    return m_Title;
}

inline
void CCit_pat_Base::SetTitle(const CCit_pat_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0x3;
}

inline
void CCit_pat_Base::SetTitle(CCit_pat_Base::TTitle&& value)
{
    m_Title = std::forward<CCit_pat_Base::TTitle>(value);
    m_set_State[0] |= 0x3;
}

inline
CCit_pat_Base::TTitle& CCit_pat_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Title;
}

inline
bool CCit_pat_Base::IsSetAuthors(void) const
{
    return m_Authors.NotEmpty();
}

inline
bool CCit_pat_Base::CanGetAuthors(void) const
{
    return true;
}

inline
const CCit_pat_Base::TAuthors& CCit_pat_Base::GetAuthors(void) const
{
    if ( !m_Authors ) {
        const_cast<CCit_pat_Base*>(this)->ResetAuthors();
    }
    return (*m_Authors);
}

inline
CCit_pat_Base::TAuthors& CCit_pat_Base::SetAuthors(void)
{
    if ( !m_Authors ) {
        ResetAuthors();
    }
    return (*m_Authors);
}

inline
bool CCit_pat_Base::IsSetCountry(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCit_pat_Base::CanGetCountry(void) const
{
    return IsSetCountry();
}

inline
const CCit_pat_Base::TCountry& CCit_pat_Base::GetCountry(void) const
{
    if (!CanGetCountry()) {
        ThrowUnassigned(2);
    }
    return m_Country;
}

inline
void CCit_pat_Base::SetCountry(const CCit_pat_Base::TCountry& value)
{
    m_Country = value;
    m_set_State[0] |= 0x30;
}

inline
void CCit_pat_Base::SetCountry(CCit_pat_Base::TCountry&& value)
{
    m_Country = std::forward<CCit_pat_Base::TCountry>(value);
    m_set_State[0] |= 0x30;
}

inline
CCit_pat_Base::TCountry& CCit_pat_Base::SetCountry(void)
{
#ifdef _DEBUG
    if (!IsSetCountry()) {
        m_Country = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Country;
}

inline
bool CCit_pat_Base::IsSetDoc_type(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CCit_pat_Base::CanGetDoc_type(void) const
{
    return IsSetDoc_type();
}

inline
const CCit_pat_Base::TDoc_type& CCit_pat_Base::GetDoc_type(void) const
{
    if (!CanGetDoc_type()) {
        ThrowUnassigned(3);
    }
    return m_Doc_type;
}

inline
void CCit_pat_Base::SetDoc_type(const CCit_pat_Base::TDoc_type& value)
{
    m_Doc_type = value;
    m_set_State[0] |= 0xc0;
}

inline
void CCit_pat_Base::SetDoc_type(CCit_pat_Base::TDoc_type&& value)
{
    m_Doc_type = std::forward<CCit_pat_Base::TDoc_type>(value);
    m_set_State[0] |= 0xc0;
}

inline
CCit_pat_Base::TDoc_type& CCit_pat_Base::SetDoc_type(void)
{
#ifdef _DEBUG
    if (!IsSetDoc_type()) {
        m_Doc_type = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Doc_type;
}

inline
bool CCit_pat_Base::IsSetNumber(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CCit_pat_Base::CanGetNumber(void) const
{
    return IsSetNumber();
}

inline
const CCit_pat_Base::TNumber& CCit_pat_Base::GetNumber(void) const
{
    if (!CanGetNumber()) {
        ThrowUnassigned(4);
    }
    return m_Number;
}

inline
void CCit_pat_Base::SetNumber(const CCit_pat_Base::TNumber& value)
{
    m_Number = value;
    m_set_State[0] |= 0x300;
}

inline
void CCit_pat_Base::SetNumber(CCit_pat_Base::TNumber&& value)
{
    m_Number = std::forward<CCit_pat_Base::TNumber>(value);
    m_set_State[0] |= 0x300;
}

inline
CCit_pat_Base::TNumber& CCit_pat_Base::SetNumber(void)
{
#ifdef _DEBUG
    if (!IsSetNumber()) {
        m_Number = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Number;
}

inline
bool CCit_pat_Base::IsSetDate_issue(void) const
{
    return m_Date_issue.NotEmpty();
}

inline
bool CCit_pat_Base::CanGetDate_issue(void) const
{
    return IsSetDate_issue();
}

inline
const CCit_pat_Base::TDate_issue& CCit_pat_Base::GetDate_issue(void) const
{
    if (!CanGetDate_issue()) {
        ThrowUnassigned(5);
    }
    return (*m_Date_issue);
}

inline
bool CCit_pat_Base::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CCit_pat_Base::CanGetClass(void) const
{
    return true;
}

inline
const CCit_pat_Base::TClass& CCit_pat_Base::GetClass(void) const
{
    return m_Class;
}

inline
CCit_pat_Base::TClass& CCit_pat_Base::SetClass(void)
{
    m_set_State[0] |= 0x1000;
    return m_Class;
}

inline
bool CCit_pat_Base::IsSetApp_number(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CCit_pat_Base::CanGetApp_number(void) const
{
    return IsSetApp_number();
}

inline
const CCit_pat_Base::TApp_number& CCit_pat_Base::GetApp_number(void) const
{
    if (!CanGetApp_number()) {
        ThrowUnassigned(7);
    }
    return m_App_number;
}

inline
void CCit_pat_Base::SetApp_number(const CCit_pat_Base::TApp_number& value)
{
    m_App_number = value;
    m_set_State[0] |= 0xc000;
}

inline
void CCit_pat_Base::SetApp_number(CCit_pat_Base::TApp_number&& value)
{
    m_App_number = std::forward<CCit_pat_Base::TApp_number>(value);
    m_set_State[0] |= 0xc000;
}

inline
CCit_pat_Base::TApp_number& CCit_pat_Base::SetApp_number(void)
{
#ifdef _DEBUG
    if (!IsSetApp_number()) {
        m_App_number = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_App_number;
}

inline
bool CCit_pat_Base::IsSetApp_date(void) const
{
    return m_App_date.NotEmpty();
}

inline
bool CCit_pat_Base::CanGetApp_date(void) const
{
    return IsSetApp_date();
}

inline
const CCit_pat_Base::TApp_date& CCit_pat_Base::GetApp_date(void) const
{
    if (!CanGetApp_date()) {
        ThrowUnassigned(8);
    }
    return (*m_App_date);
}

inline
bool CCit_pat_Base::IsSetApplicants(void) const
{
    return m_Applicants.NotEmpty();
}

inline
bool CCit_pat_Base::CanGetApplicants(void) const
{
    return IsSetApplicants();
}

inline
const CCit_pat_Base::TApplicants& CCit_pat_Base::GetApplicants(void) const
{
    if (!CanGetApplicants()) {
        ThrowUnassigned(9);
    }
    return (*m_Applicants);
}

inline
bool CCit_pat_Base::IsSetAssignees(void) const
{
    return m_Assignees.NotEmpty();
}

inline
bool CCit_pat_Base::CanGetAssignees(void) const
{
    return IsSetAssignees();
}

inline
const CCit_pat_Base::TAssignees& CCit_pat_Base::GetAssignees(void) const
{
    if (!CanGetAssignees()) {
        ThrowUnassigned(10);
    }
    return (*m_Assignees);
}

inline
bool CCit_pat_Base::IsSetPriority(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CCit_pat_Base::CanGetPriority(void) const
{
    return true;
}

inline
const CCit_pat_Base::TPriority& CCit_pat_Base::GetPriority(void) const
{
    return m_Priority;
}

inline
CCit_pat_Base::TPriority& CCit_pat_Base::SetPriority(void)
{
    m_set_State[0] |= 0x400000;
    return m_Priority;
}

inline
bool CCit_pat_Base::IsSetAbstract(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CCit_pat_Base::CanGetAbstract(void) const
{
    return IsSetAbstract();
}

inline
const CCit_pat_Base::TAbstract& CCit_pat_Base::GetAbstract(void) const
{
    if (!CanGetAbstract()) {
        ThrowUnassigned(12);
    }
    return m_Abstract;
}

inline
void CCit_pat_Base::SetAbstract(const CCit_pat_Base::TAbstract& value)
{
    m_Abstract = value;
    m_set_State[0] |= 0x3000000;
}

inline
void CCit_pat_Base::SetAbstract(CCit_pat_Base::TAbstract&& value)
{
    m_Abstract = std::forward<CCit_pat_Base::TAbstract>(value);
    m_set_State[0] |= 0x3000000;
}

inline
CCit_pat_Base::TAbstract& CCit_pat_Base::SetAbstract(void)
{
#ifdef _DEBUG
    if (!IsSetAbstract()) {
        m_Abstract = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Abstract;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIBLIO_CIT_PAT_BASE_HPP
