/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.Classpath;
import org.eclipse.jetty.start.CommandLineBuilder;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileArg;
import org.eclipse.jetty.start.JarVersion;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.ModuleGraphWriter;
import org.eclipse.jetty.start.Modules;
import org.eclipse.jetty.start.StartArgs;
import org.eclipse.jetty.start.StartIni;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.UsageException;
import org.eclipse.jetty.start.config.CommandLineConfigSource;

public class Main {
    private static final String EXITING_LICENSE_NOT_ACKNOWLEDGED = "Exiting: license not acknowledged!";
    private static final int EXIT_USAGE = 1;
    private BaseHome baseHome;
    private StartArgs startupArgs;

    public static String join(Collection<?> objs, String delim) {
        if (objs == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        boolean needDelim = false;
        for (Object obj : objs) {
            if (needDelim) {
                str.append(delim);
            }
            str.append(obj);
            needDelim = true;
        }
        return str.toString();
    }

    public static void main(String[] args) {
        try {
            Main main = new Main();
            StartArgs startArgs = main.processCommandLine(args);
            main.start(startArgs);
        }
        catch (UsageException e) {
            System.err.println(e.getMessage());
            Main.usageExit(e.getCause(), e.getExitCode());
        }
        catch (Throwable e) {
            Main.usageExit(e, -5);
        }
    }

    static void usageExit(int exit) {
        Main.usageExit(null, exit);
    }

    static void usageExit(Throwable t, int exit) {
        if (t != null) {
            t.printStackTrace(System.err);
        }
        System.err.println();
        System.err.println("Usage: java -jar start.jar [options] [properties] [configs]");
        System.err.println("       java -jar start.jar --help  # for more information");
        System.exit(exit);
    }

    private void copyInThread(final InputStream in, final OutputStream out) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buf = new byte[1024];
                    int len = in.read(buf);
                    while (len > 0) {
                        out.write(buf, 0, len);
                        len = in.read(buf);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }).start();
    }

    private void initFile(StartArgs args, FileArg farg) {
        block33: {
            try {
                Path file = this.baseHome.getBasePath(farg.location);
                StartLog.debug("[init-file] %s module specified file %s", file.toAbsolutePath(), FS.exists(file) ? "[Exists!]" : "");
                if (FS.exists(file)) {
                    return;
                }
                if (farg.uri != null) {
                    URL url = new URL(farg.uri);
                    StartLog.log("DOWNLOAD", "%s to %s", url, farg.location);
                    FS.ensureDirectoryExists(file.getParent());
                    if (args.isTestingModeEnabled()) {
                        StartLog.log("TESTING MODE", "Skipping download of " + url);
                        return;
                    }
                    byte[] buf = new byte[8192];
                    try (InputStream in = url.openStream();
                         OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                        int len;
                        do {
                            if ((len = in.read(buf)) <= 0) continue;
                            out.write(buf, 0, len);
                        } while (len >= 0);
                        break block33;
                    }
                }
                if (farg.location.endsWith("/")) {
                    StartLog.log("MKDIR", this.baseHome.toShortForm(file));
                    FS.ensureDirectoryExists(file);
                } else {
                    String shortRef = this.baseHome.toShortForm(file);
                    if (args.isTestingModeEnabled()) {
                        StartLog.log("TESTING MODE", "Skipping required file check on: %s", shortRef);
                        return;
                    }
                    StartLog.warn("MISSING: Required file %s", shortRef);
                }
            }
            catch (Exception e) {
                StartLog.warn("ERROR: processing %s%n%s", farg, e);
                StartLog.warn(e);
                Main.usageExit(1);
            }
        }
    }

    private void dumpClasspathWithVersions(Classpath classpath) {
        StartLog.endStartLog();
        System.out.println();
        System.out.println("Jetty Server Classpath:");
        System.out.println("-----------------------");
        if (classpath.count() == 0) {
            System.out.println("No classpath entries and/or version information available show.");
            return;
        }
        System.out.println("Version Information on " + classpath.count() + " entr" + (classpath.count() > 1 ? "ies" : "y") + " in the classpath.");
        System.out.println("Note: order presented here is how they would appear on the classpath.");
        System.out.println("      changes to the --module=name command line options will be reflected here.");
        int i = 0;
        for (File element : classpath.getElements()) {
            System.out.printf("%2d: %24s | %s\n", i++, this.getVersion(element), this.baseHome.toShortForm(element));
        }
    }

    public BaseHome getBaseHome() {
        return this.baseHome;
    }

    private String getVersion(File element) {
        String name;
        if (element.isDirectory()) {
            return "(dir)";
        }
        if (element.isFile() && (name = element.getName().toLowerCase(Locale.ENGLISH)).endsWith(".jar")) {
            return JarVersion.getVersion(element);
        }
        return "";
    }

    public void invokeMain(ClassLoader classloader, StartArgs args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, IOException {
        Class<?> invoked_class = null;
        String mainclass = args.getMainClassname();
        try {
            invoked_class = classloader.loadClass(mainclass);
        }
        catch (ClassNotFoundException e) {
            System.out.println("WARNING: Nothing to start, exiting ...");
            StartLog.debug(e);
            Main.usageExit(-2);
            return;
        }
        StartLog.debug("%s - %s", invoked_class, invoked_class.getPackage().getImplementationVersion());
        CommandLineBuilder cmd = args.getMainArgs(this.baseHome, false);
        String[] argArray = cmd.getArgs().toArray(new String[0]);
        StartLog.debug("Command Line Args: %s", cmd.toString());
        Class[] method_param_types = new Class[]{argArray.getClass()};
        Method main = invoked_class.getDeclaredMethod("main", method_param_types);
        Object[] method_params = new Object[]{argArray};
        StartLog.endStartLog();
        main.invoke(null, method_params);
    }

    public void listConfig(StartArgs args) {
        StartLog.endStartLog();
        args.dumpEnvironment(this.baseHome);
        args.dumpJvmArgs();
        args.dumpSystemProperties();
        args.dumpProperties();
        this.dumpClasspathWithVersions(args.getClasspath());
        args.dumpActiveXmls(this.baseHome);
    }

    private void listModules(StartArgs args) {
        StartLog.endStartLog();
        System.out.println();
        System.out.println("Jetty All Available Modules:");
        System.out.println("----------------------------");
        args.getAllModules().dump();
        System.out.println();
        System.out.println("Jetty Active Module Tree:");
        System.out.println("-------------------------");
        Modules modules = args.getAllModules();
        modules.dumpEnabledTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildIni(StartArgs args, String name, boolean topLevel, boolean appendStartIni) throws IOException {
        Path start_d = this.baseHome.getBasePath("start.d");
        Modules modules = args.getAllModules();
        Module module = modules.get(name);
        if (module == null) {
            StartLog.warn("ERROR: No known module for %s", name);
            return;
        }
        boolean transitive = module.isEnabled() && module.getSources().size() == 0;
        Path start_ini = this.baseHome.getBasePath("start.ini");
        String short_start_ini = this.baseHome.toShortForm(start_ini);
        Path startd_ini = start_d.resolve(name + ".ini");
        String short_startd_ini = this.baseHome.toShortForm(startd_ini);
        StartIni module_ini = null;
        if (FS.exists(startd_ini) && (module_ini = new StartIni(startd_ini)).getLineMatches(Pattern.compile("--module=(.*, *)*" + name)).size() == 0) {
            StartLog.warn("ERROR: %s is not enabled in %s!", name, short_startd_ini);
            return;
        }
        if (!(args.isApproveAllLicenses() || module.hasFiles(this.baseHome) || module.acknowledgeLicense())) {
            StartLog.warn(EXITING_LICENSE_NOT_ACKNOWLEDGED, new Object[0]);
            System.exit(1);
        }
        boolean buildIni = false;
        if (module.isEnabled()) {
            if (topLevel && !FS.exists(startd_ini) && !appendStartIni) {
                buildIni = true;
            } else if (transitive) {
                if (module.hasDefaultConfig()) {
                    buildIni = true;
                    StartLog.info("%-15s initialised transitively", name);
                }
            } else {
                for (String source : module.getSources()) {
                    StartLog.info("%-15s initialised in %s", name, this.baseHome.toShortForm(source));
                }
            }
        } else {
            buildIni = true;
        }
        String source = "<transitive>";
        if (buildIni) {
            BufferedWriter writer = null;
            try (PrintWriter out = null;){
                if (appendStartIni) {
                    source = short_start_ini;
                    StartLog.info("%-15s initialised in %s (appended)", name, source);
                    writer = Files.newBufferedWriter(start_ini, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                    out = new PrintWriter(writer);
                } else {
                    FS.ensureDirectoryExists(start_d);
                    FS.ensureDirectoryWritable(start_d);
                    source = short_startd_ini;
                    StartLog.info("%-15s initialised in %s (created)", name, source);
                    writer = Files.newBufferedWriter(startd_ini, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                    out = new PrintWriter(writer);
                }
                if (appendStartIni) {
                    out.println();
                }
                out.println("# --------------------------------------- ");
                out.println("# Module: " + name);
                out.println("--module=" + name);
                args.parse("--module=" + name, source);
                args.parseModule(module);
                for (String line : module.getDefaultConfig()) {
                    out.println(line);
                }
            }
        }
        modules.enable(name, Collections.singletonList(source));
        for (String src : module.getSources()) {
            StartLog.debug("also enabled in: %s", src);
            if (short_start_ini.equals(src)) continue;
            StartLog.info("%-15s enabled in     %s", name, this.baseHome.toShortForm(src));
        }
        for (String file : module.getFiles()) {
            this.initFile(args, new FileArg(module, file));
        }
        module.expandProperties(args.getProperties());
        modules.registerParentsIfMissing(module);
        modules.buildGraph();
        if (topLevel) {
            ArrayList<Module> depends = new ArrayList<Module>();
            for (String depend : modules.resolveParentModulesOf(name)) {
                if (name.equals(depend)) continue;
                Module m = modules.get(depend);
                m.setEnabled(true);
                depends.add(m);
            }
            Collections.sort(depends, Collections.reverseOrder(new Module.DepthComparator()));
            HashSet<String> done = new HashSet<String>(0);
            while (true) {
                boolean complete = true;
                for (Module m : depends) {
                    if (done.contains(m.getName())) continue;
                    complete = false;
                    this.buildIni(args, m.getName(), false, appendStartIni);
                    done.add(m.getName());
                }
                if (complete) break;
                depends.clear();
                for (String depend : modules.resolveParentModulesOf(name)) {
                    if (name.equals(depend)) continue;
                    Module m = modules.get(depend);
                    m.setEnabled(true);
                    depends.add(m);
                }
                Collections.sort(depends, Collections.reverseOrder(new Module.DepthComparator()));
            }
        }
    }

    public StartArgs processCommandLine(List<String> cmdLine) throws Exception {
        return this.processCommandLine(cmdLine.toArray(new String[cmdLine.size()]));
    }

    public StartArgs processCommandLine(String[] cmdLine) throws Exception {
        CommandLineConfigSource cmdLineSource = new CommandLineConfigSource(cmdLine);
        this.baseHome = new BaseHome(cmdLineSource);
        StartLog.debug("jetty.home=%s", this.baseHome.getHome());
        StartLog.debug("jetty.base=%s", this.baseHome.getBase());
        StartLog.debug("Parsing collected arguments", new Object[0]);
        StartArgs args = new StartArgs();
        args.parse(this.baseHome.getConfigSources());
        Modules modules = new Modules(this.baseHome, args);
        StartLog.debug("Registering all modules", new Object[0]);
        modules.registerAll();
        for (String enabledModule : args.getEnabledModules()) {
            List<String> msources = args.getSources(enabledModule);
            modules.enable(enabledModule, msources);
        }
        StartLog.debug("Building Module Graph", new Object[0]);
        modules.buildGraph();
        args.setAllModules(modules);
        List<Module> activeModules = modules.resolveEnabled();
        args.expandLibs(this.baseHome);
        args.expandModules(this.baseHome, activeModules);
        args.resolveExtraXmls(this.baseHome);
        args.resolvePropertyFiles(this.baseHome);
        return args;
    }

    public void start(StartArgs args) throws IOException, InterruptedException {
        StartLog.debug("StartArgs: %s", args);
        Classpath classpath = args.getClasspath();
        System.setProperty("java.class.path", classpath.toString());
        if (args.isHelp()) {
            this.usage(true);
        }
        if (args.isListClasspath()) {
            this.dumpClasspathWithVersions(classpath);
        }
        if (args.isListConfig()) {
            this.listConfig(args);
        }
        if (args.isListModules()) {
            this.listModules(args);
        }
        if (args.getModuleGraphFilename() != null) {
            Path outputFile = this.baseHome.getBasePath(args.getModuleGraphFilename());
            System.out.printf("Generating GraphViz Graph of Jetty Modules at %s%n", this.baseHome.toShortForm(outputFile));
            ModuleGraphWriter writer = new ModuleGraphWriter();
            writer.config(args.getProperties());
            writer.write(args.getAllModules(), outputFile);
        }
        if (args.isDryRun()) {
            CommandLineBuilder cmd = args.getMainArgs(this.baseHome, true);
            System.out.println(cmd.toString(File.separatorChar == '/' ? " \\\n" : " "));
        }
        if (args.isStopCommand()) {
            this.doStop(args);
        }
        boolean rebuildGraph = false;
        for (String string : args.getAddToStartIni()) {
            this.buildIni(args, string, true, true);
            rebuildGraph = true;
        }
        for (String string : args.getAddToStartdIni()) {
            this.buildIni(args, string, true, false);
            rebuildGraph = true;
        }
        if (rebuildGraph) {
            args.getAllModules().clearMissing();
            args.getAllModules().buildGraph();
        }
        if (args.isDownload() && !args.isApproveAllLicenses()) {
            for (Module module : args.getAllModules().resolveEnabled()) {
                if (module.hasFiles(this.baseHome) || module.acknowledgeLicense()) continue;
                StartLog.warn(EXITING_LICENSE_NOT_ACKNOWLEDGED, new Object[0]);
                System.exit(1);
            }
        }
        for (FileArg fileArg : args.getFiles()) {
            Path file = this.baseHome.getBasePath(fileArg.location);
            if (!FS.exists(file) && args.isDownload()) {
                this.initFile(args, fileArg);
            }
            if (FS.exists(file)) continue;
            boolean isDir = fileArg.location.endsWith("/");
            if (isDir) {
                StartLog.log("MKDIR", this.baseHome.toShortForm(file));
                FS.ensureDirectoryExists(file);
                continue;
            }
            String shortRef = this.baseHome.toShortForm(file);
            if (args.isTestingModeEnabled()) {
                StartLog.log("TESTING MODE", "Skipping required file check on: %s", shortRef);
                return;
            }
            StartLog.warn("Missing Required File: %s", this.baseHome.toShortForm(file));
            args.setRun(false);
            if (fileArg.uri == null) continue;
            StartLog.warn("  Can be downloaded From: %s", fileArg.uri);
            StartLog.warn("  Run start.jar --create-files to download", new Object[0]);
        }
        if (!args.isRun()) {
            return;
        }
        if (args.isExec()) {
            CommandLineBuilder cmd = args.getMainArgs(this.baseHome, true);
            cmd.debug();
            ProcessBuilder processBuilder = new ProcessBuilder(cmd.getArgs());
            StartLog.endStartLog();
            final Process process = processBuilder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    StartLog.debug("Destroying " + process, new Object[0]);
                    process.destroy();
                }
            });
            this.copyInThread(process.getErrorStream(), System.err);
            this.copyInThread(process.getInputStream(), System.out);
            this.copyInThread(System.in, process.getOutputStream());
            process.waitFor();
            System.exit(0);
            return;
        }
        if (args.hasJvmArgs() || args.hasSystemProperties()) {
            System.err.println("WARNING: System properties and/or JVM args set.  Consider using --dry-run or --exec");
        }
        ClassLoader cl = classpath.getClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            this.invokeMain(cl, args);
        }
        catch (Exception exception) {
            Main.usageExit(exception, -2);
        }
    }

    private void doStop(StartArgs args) {
        String stopHost = args.getProperties().getString("STOP.HOST");
        int stopPort = Integer.parseInt(args.getProperties().getString("STOP.PORT"));
        String stopKey = args.getProperties().getString("STOP.KEY");
        if (args.getProperties().getString("STOP.WAIT") != null) {
            int stopWait = Integer.parseInt(args.getProperties().getString("STOP.WAIT"));
            this.stop(stopHost, stopPort, stopKey, stopWait);
        } else {
            this.stop(stopHost, stopPort, stopKey);
        }
    }

    public void stop(String host, int port, String key) {
        this.stop(host, port, key, 0);
    }

    public void stop(String host, int port, String key, int timeout) {
        if (host == null || host.length() == 0) {
            host = "127.0.0.1";
        }
        try {
            if (port <= 0) {
                System.err.println("STOP.PORT system property must be specified");
            }
            if (key == null) {
                key = "";
                System.err.println("STOP.KEY system property must be specified");
                System.err.println("Using empty key");
            }
            try (Socket s = new Socket(InetAddress.getByName(host), port);){
                if (timeout > 0) {
                    s.setSoTimeout(timeout * 1000);
                }
                try (OutputStream out = s.getOutputStream();){
                    out.write((key + "\r\nstop\r\n").getBytes());
                    out.flush();
                    if (timeout > 0) {
                        String response;
                        System.err.printf("Waiting %,d seconds for jetty to stop%n", timeout);
                        LineNumberReader lin = new LineNumberReader(new InputStreamReader(s.getInputStream()));
                        while ((response = lin.readLine()) != null) {
                            StartLog.debug("Received \"%s\"", response);
                            if (!"Stopped".equals(response)) continue;
                            StartLog.warn("Server reports itself as Stopped", new Object[0]);
                        }
                    }
                }
            }
        }
        catch (SocketTimeoutException e) {
            System.err.println("Timed out waiting for stop confirmation");
            System.exit(-5);
        }
        catch (ConnectException e) {
            Main.usageExit(e, -4);
        }
        catch (Exception e) {
            Main.usageExit(e, -5);
        }
    }

    public void usage(boolean exit) {
        StartLog.endStartLog();
        if (!Main.printTextResource("org/eclipse/jetty/start/usage.txt")) {
            System.err.println("ERROR: detailed usage resource unavailable");
        }
        if (exit) {
            System.exit(1);
        }
    }

    public static boolean printTextResource(String resourceName) {
        boolean resourcePrinted;
        block40: {
            resourcePrinted = false;
            try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);){
                if (stream != null) {
                    try (InputStreamReader reader = new InputStreamReader(stream);
                         BufferedReader buf = new BufferedReader(reader);){
                        String line;
                        resourcePrinted = true;
                        while ((line = buf.readLine()) != null) {
                            System.out.println(line);
                        }
                        break block40;
                    }
                }
                System.out.println("Unable to find resource: " + resourceName);
            }
            catch (IOException e) {
                StartLog.warn(e);
            }
        }
        return resourcePrinted;
    }

    public void init(String[] args) throws Exception {
        try {
            this.startupArgs = this.processCommandLine(args);
        }
        catch (UsageException e) {
            System.err.println(e.getMessage());
            Main.usageExit(e.getCause(), e.getExitCode());
        }
        catch (Throwable e) {
            Main.usageExit(e, -5);
        }
    }

    public void start() throws Exception {
        this.start(this.startupArgs);
    }

    public void stop() throws Exception {
        this.doStop(this.startupArgs);
    }

    public void destroy() {
    }
}

