//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _PRODUCTDATATYPE_H
#define _PRODUCTDATATYPE_H


#include "endianmess.h"
#include "datatypes.h"
#include "packet.h"
#include "datatypes.h"

#include <string> 

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;


/// class to handle garmin product data type packets
class ProductDataType : Endianmess
{
   public:

      ProductDataType(void);

      /// sets internal data by given garmin packet 
      void process(Packet);

      /// returns the garmin product ID
      int product_ID(void);

      /// returns the garmin software version
      int softwareVersion(void);

      /// returns the garmin product description
      string productDescription(void);      

   private:
      void clear(void);
      g_int   p_ID;
      g_int   sVersion;
      string  pDescription;
};


}
#endif
