/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.time.ZonedDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerProcess;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerResult;
import org.elasticsearch.xpack.ml.job.process.normalizer.output.NormalizerResultHandler;

public class MultiplyingNormalizerProcess
implements NormalizerProcess {
    private static final Logger LOGGER = LogManager.getLogger(MultiplyingNormalizerProcess.class);
    private final double factor;
    private final PipedInputStream processOutStream;
    private XContentBuilder builder;
    private boolean shouldIgnoreHeader;

    public MultiplyingNormalizerProcess(double factor) {
        this.factor = factor;
        this.processOutStream = new PipedInputStream();
        try {
            XContent xContent = XContentFactory.xContent((XContentType)XContentType.JSON);
            PipedOutputStream processInStream = new PipedOutputStream(this.processOutStream);
            this.builder = new XContentBuilder(xContent, (OutputStream)processInStream);
        }
        catch (IOException e) {
            LOGGER.error("Could not set up no-op pipe", (Throwable)e);
        }
        this.shouldIgnoreHeader = true;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void writeRecord(String[] record) throws IOException {
        if (this.shouldIgnoreHeader) {
            this.shouldIgnoreHeader = false;
            return;
        }
        NormalizerResult result = new NormalizerResult();
        try {
            result.setLevel(record[0]);
            result.setPartitionFieldName(record[1]);
            result.setPartitionFieldValue(record[2]);
            result.setPersonFieldName(record[3]);
            result.setPersonFieldValue(record[4]);
            result.setFunctionName(record[5]);
            result.setValueFieldName(record[6]);
            result.setProbability(Double.parseDouble(record[7]));
            result.setNormalizedScore(this.factor * Double.parseDouble(record[8]));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new IOException("Unable to write to no-op normalizer", e);
        }
        this.builder.lfAtEnd();
        result.toXContent(this.builder, null);
    }

    @Override
    public void persistState() {
    }

    @Override
    public void flushStream() {
    }

    @Override
    public void kill() {
    }

    @Override
    public ZonedDateTime getProcessStartTime() {
        return null;
    }

    @Override
    public void close() {
        this.builder.close();
    }

    @Override
    public NormalizerResultHandler createNormalizedResultsHandler() {
        return new NormalizerResultHandler(this.processOutStream);
    }

    @Override
    public boolean isProcessAlive() {
        return true;
    }

    @Override
    public boolean isProcessAliveAfterWaiting() {
        return true;
    }

    @Override
    public String readError() {
        return "";
    }
}

