/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client;

import com.amazon.aes.webservices.client.InstanceBlockDeviceMappingResponseDescription;
import com.amazon.aes.webservices.client.InstanceLicense;
import com.amazon.aes.webservices.client.InstancePlacement;
import com.amazon.aes.webservices.client.MonitorInstance;
import com.amazon.aes.webservices.client.ResourceTagDescription;
import com.amazonaws.ec2.doc._2010_11_15.InstanceStateType;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservationDescription {
    public String owner;
    public String resId;
    public List<Instance> instances = new ArrayList<Instance>();
    public List<String> groups = new ArrayList<String>();
    public String requesterId = null;

    public ReservationDescription(String owner, String resId, String requesterId) {
        this.owner = owner;
        this.resId = resId;
        this.requesterId = requesterId;
    }

    public Instance addInstance(Instance instance) {
        this.instances.add(instance);
        return instance;
    }

    public Instance addInstance(String imageId, String instanceId, String dnsName, String privateDnsName, InstanceStateType state, String reason, String keyName, String amiLaunchIndex, List<String> productCodes, String instanceType, Calendar launchTime, InstancePlacement placement, String kernelId, String ramdiskId, String platform, String monitoring, String vpcId, String subnetId, String publicIpAddress, String privateIpAddress, String rootDeviceType, String virtualizationType, String hypervisor, List<InstanceBlockDeviceMappingResponseDescription> blockDevices, String instanceClass, String spotInstanceRequestId, InstanceLicense license, String clientToken, List<ResourceTagDescription> tags) {
        Instance instance = new Instance(imageId, instanceId, dnsName, privateDnsName, state.getName(), state.getCode(), reason, keyName, amiLaunchIndex, productCodes, instanceType, launchTime, placement, kernelId, ramdiskId, platform, MonitorInstance.MonitoringState.valueOf(monitoring), vpcId, subnetId, publicIpAddress, privateIpAddress, rootDeviceType, virtualizationType, hypervisor, blockDevices, instanceClass, spotInstanceRequestId, license, clientToken, tags);
        this.instances.add(instance);
        return instance;
    }

    public String addGroup(String groupId) {
        this.groups.add(groupId);
        return groupId;
    }

    public String toString() {
        return "Reservation[id=" + this.resId + ", Loc=" + ", instances=" + this.instances + ", groups=" + this.groups + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Instance {
        public String imageId;
        public String instanceId;
        public String dnsName;
        public String privateDnsName;
        public String reason;
        public String keyName;
        public String amiLaunchIndex;
        public List<String> productCodes;
        public String instanceType;
        public Calendar launchTime;
        public String state;
        public int stateCode;
        public InstancePlacement placement;
        public String ramdiskId;
        public String kernelId;
        public String platform;
        public MonitorInstance.MonitoringState monitoring;
        public String vpcId;
        public String subnetId;
        public String publicIpAddress;
        public String privateIpAddress;
        public String rootDeviceType;
        public String virtualizationType;
        public String hypervisor;
        public List<InstanceBlockDeviceMappingResponseDescription> blockDevices;
        public String instanceLifecycle;
        public String spotInstanceRequestId;
        public InstanceLicense license;
        public String clientToken;
        public List<ResourceTagDescription> tags;

        public Instance(String imageId, String instanceId, String dnsName, String privateDnsName, String stateName, int stateCode, String reason, String keyName, String amiLaunchIndex, List<String> productCodes, String instanceType, Calendar launchTime, InstancePlacement placement, String kernelId, String ramdiskId, String platform, MonitorInstance.MonitoringState monitoring, String vpcId, String subnetId, String publicIpAddress, String privateIpAddress, String rootDeviceType, String virtualizationType, String hypervisor, List<InstanceBlockDeviceMappingResponseDescription> blockDevices, String instanceLifecycle, String spotInstanceRequestId, InstanceLicense license, String clientToken, List<ResourceTagDescription> tags) {
            this.imageId = imageId;
            this.instanceId = instanceId;
            this.dnsName = dnsName;
            this.privateDnsName = privateDnsName;
            this.state = stateName;
            this.stateCode = stateCode;
            this.reason = reason;
            this.keyName = keyName;
            this.amiLaunchIndex = amiLaunchIndex;
            this.productCodes = productCodes;
            this.instanceType = instanceType;
            this.launchTime = launchTime;
            this.placement = placement;
            this.ramdiskId = ramdiskId;
            this.kernelId = kernelId;
            this.platform = platform;
            this.monitoring = monitoring;
            this.vpcId = vpcId;
            this.subnetId = subnetId;
            this.publicIpAddress = publicIpAddress;
            this.privateIpAddress = privateIpAddress;
            this.rootDeviceType = rootDeviceType;
            this.virtualizationType = virtualizationType;
            this.hypervisor = hypervisor;
            this.blockDevices = blockDevices;
            this.instanceLifecycle = instanceLifecycle;
            this.spotInstanceRequestId = spotInstanceRequestId;
            this.license = license;
            this.clientToken = clientToken;
            this.tags = tags;
        }

        public boolean isRunning() {
            return this.state.equalsIgnoreCase("running");
        }

        public boolean isPending() {
            return this.state.equalsIgnoreCase("pending");
        }

        public boolean isShuttingDown() {
            return this.state.equalsIgnoreCase("shutting-down");
        }

        public boolean isTerminated() {
            return this.state.equalsIgnoreCase("terminated");
        }

        public String toString() {
            return "[img=" + this.imageId + ", instance=" + this.instanceId + ", dns=" + this.dnsName + ", privateDns=" + this.privateDnsName + ", loc=" + ", state=" + this.state + "(" + this.stateCode + ") reason=" + this.reason + ", amiLaunchIndex=" + this.amiLaunchIndex + ", productCodes=" + this.productCodes + "]" + ", instanceType=" + this.instanceType + ", launchTime=" + this.launchTime + ", placement=" + this.placement + ", ramdiskId = " + this.ramdiskId + ", kernelId = " + this.kernelId + ", platform = " + this.platform + ", monitoring = monitoring-" + this.monitoring.state + ", instanceLifecycle = " + this.instanceLifecycle + ", spotInstanceRequestId = " + this.spotInstanceRequestId + ", license = " + this.license + ", clientToken = " + this.clientToken + "]";
        }
    }
}

