/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.remoteLogger;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.LinkedList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.igoweb.igoweb.Config;
import org.igoweb.util.LockOrder;
import org.igoweb.util.ThreadPool;

public class TransmitHandler
extends Handler {
    public static final LockOrder LOCK_ORDER = new LockOrder(TransmitHandler.class);
    public static final long OPEN_ATTEMPT_PERIOD = 300000L;
    private ThreadPool threadPool;
    private final String name;
    private final String host;
    private final int port;
    private Socket sock;
    private ObjectOutputStream out;
    private ThreadPool.DelayedTask openerTask;
    private LinkedList<LogRecord> bufferedRecords = new LinkedList();

    public TransmitHandler(String newName, ThreadPool newThreadPool) {
        this(newName, Config.get("rmiWebHost"), 13840, newThreadPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransmitHandler(String newName, String remoteHost, int remotePort, ThreadPool newThreadPool) {
        this.name = newName;
        this.host = remoteHost;
        this.port = remotePort;
        this.threadPool = newThreadPool;
        TransmitHandler transmitHandler = this;
        synchronized (transmitHandler) {
            this.openerTask = newThreadPool.scheduleWithFixedDelay(this::openSocket, 0L, 300000L);
        }
        this.setLevel(Level.WARNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        assert (LockOrder.testAcquire(this));
        TransmitHandler transmitHandler = this;
        synchronized (transmitHandler) {
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.sock = null;
            }
            this.out = null;
            if (this.openerTask != null) {
                this.openerTask.cancel();
                this.openerTask = null;
            }
            this.bufferedRecords = null;
        }
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (record.getLevel().intValue() < Level.WARNING.intValue()) {
            return;
        }
        assert (LockOrder.testAcquire(this));
        TransmitHandler transmitHandler = this;
        synchronized (transmitHandler) {
            if (this.out == null) {
                if (this.bufferedRecords != null) {
                    this.bufferedRecords.add(record);
                }
            } else {
                try {
                    this.out.writeObject(record);
                    this.out.flush();
                }
                catch (IOException excep) {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.out = null;
                    this.bufferedRecords.add(record);
                    this.openerTask = this.threadPool.scheduleWithFixedDelay(this::openSocket, 300000L, 300000L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSocket() {
        assert (LockOrder.testAcquire(this));
        TransmitHandler transmitHandler = this;
        synchronized (transmitHandler) {
            if (this.bufferedRecords == null || this.out != null) {
                return;
            }
            try {
                this.sock = new Socket(this.host, this.port);
                this.out = new ObjectOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
                this.out.writeObject(this.name);
                this.out.flush();
                this.openerTask.cancel();
                this.openerTask = null;
                LinkedList<LogRecord> blockedLogs = this.bufferedRecords;
                this.bufferedRecords = new LinkedList();
                for (LogRecord record : blockedLogs) {
                    this.publish(record);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        assert (LOCK_ORDER.addInnerOrder(ThreadPool.LOCK_ORDER));
    }
}

