/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.Message;
import org.igoweb.igoweb.client.swing.ChatPane;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.TBlock;

public class MessagesWindow
extends DFrame
implements ActionListener {
    private Client client;
    private JButton deleteBut;
    private static final Object SAVED_MESSAGES_KEY = new Object();
    public static final Object MESSAGE_MENU_ITEM_KEY = new Object();

    public MessagesWindow(Component parent, ArrayList<?> messages, Client client) {
        super(Defs.getString(-903340524), parent);
        this.client = client;
        GuiClientUtil.addToWindowList(client, this);
        if (messages == null) {
            messages = (ArrayList)client.objects.get(SAVED_MESSAGES_KEY);
        } else {
            client.objects.put(SAVED_MESSAGES_KEY, messages);
        }
        JComponent mi = (JComponent)client.objects.get(MESSAGE_MENU_ITEM_KEY);
        if (mi != null) {
            mi.setEnabled(false);
        }
        JComponent panel = this.getMainPanel();
        panel.add("yGrow=f,xGrow=t", new TBlock(Defs.getString(-903340523), 40));
        ChatPane msgOut = new ChatPane(client, null, 0);
        panel.add("x=0,yGrow=t", msgOut);
        Object[] formatArgs = new Object[3];
        for (Message msg : messages) {
            formatArgs[0] = msg.sender.name;
            formatArgs[1] = new Date(msg.sendDate);
            msgOut.append(Defs.getString(-903340515, formatArgs), 1, true);
            msgOut.append(msg.text, 0, false);
        }
        this.addButton(Defs.getString(-903340522), this);
        this.deleteBut = this.addButton(Defs.getString(-903340521), this);
        this.pack(parent);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.deleteBut) {
            this.client.deleteMessages();
            this.client.objects.remove(SAVED_MESSAGES_KEY);
        }
        this.dispose();
    }

    @Override
    public void dispose() {
        JComponent mi = (JComponent)this.client.objects.get(MESSAGE_MENU_ITEM_KEY);
        if (mi != null) {
            mi.setEnabled(MessagesWindow.hasMessages(this.client));
        }
        super.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        int h = dim.height;
        if (h * 1414 < dim.width * 1000) {
            h = (dim.width * 1000 + 707) / 1414;
        }
        return new Dimension(dim.width, h);
    }

    public static boolean hasMessages(Client client) {
        return client.objects.containsKey(SAVED_MESSAGES_KEY);
    }
}

