/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant.jmx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.catalina.ant.jmx.Arg;
import org.apache.catalina.ant.jmx.JMXAccessorTask;
import org.apache.tools.ant.BuildException;

public class JMXAccessorSetTask
extends JMXAccessorTask {
    private String attribute;
    private String value;
    private String type;
    private boolean convert = false;
    private List args = new ArrayList();
    private static final String info = "org.apache.catalina.ant.JMXAccessorSetTask/1.1";

    public String getInfo() {
        return info;
    }

    public void addArg(Arg attribute) {
        this.args.add(attribute);
    }

    public List getArgs() {
        return this.args;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String valueType) {
        this.type = valueType;
    }

    public boolean isConvert() {
        return this.convert;
    }

    public void setConvert(boolean convert) {
        this.convert = convert;
    }

    public String jmxExecute(MBeanServerConnection jmxServerConnection) throws Exception {
        if (this.getName() == null) {
            throw new BuildException("Must specify a 'name'");
        }
        if ((this.attribute == null || this.value == null) && this.args.isEmpty()) {
            throw new BuildException("Must specify a 'attribute' and 'value' or 'attribute' elements for set with args");
        }
        if (this.args.isEmpty()) {
            return this.jmxSet(jmxServerConnection, this.getName());
        }
        if (this.attribute != null && this.value != null) {
            Arg a = new Arg();
            a.setName(this.attribute);
            a.setValue(this.value);
            a.setType(this.type);
            this.args.add(a);
        }
        return this.jmxSetWithAttributList(jmxServerConnection, this.getName());
    }

    protected String jmxSet(MBeanServerConnection jmxServerConnection, String name) throws Exception {
        Object realValue;
        if (this.type != null) {
            realValue = this.convertStringToType(this.value, this.type);
        } else if (this.isConvert()) {
            String mType = this.getMBeanAttributeType(jmxServerConnection, name, this.attribute);
            realValue = this.convertStringToType(this.value, mType);
        } else {
            realValue = this.value;
        }
        jmxServerConnection.setAttribute(new ObjectName(name), new Attribute(this.attribute, realValue));
        return null;
    }

    protected String jmxSetWithAttributList(MBeanServerConnection jmxServerConnection, String name) throws Exception {
        AttributeList attributeList = new AttributeList();
        MBeanInfo minfo = null;
        Iterator iter = this.args.iterator();
        while (iter.hasNext()) {
            Object realValue;
            Arg element = (Arg)iter.next();
            if (element.getType() != null) {
                realValue = this.convertStringToType(element.getValue(), element.getType());
            } else if (this.isConvert()) {
                if (minfo == null) {
                    minfo = this.getMBeanInfo(jmxServerConnection, name);
                }
                String mType = this.getMBeanAttributeType(minfo, element.getName());
                realValue = this.convertStringToType(element.getValue(), mType);
            } else {
                realValue = element.getValue();
            }
            Attribute a = new Attribute(element.getName(), realValue);
            attributeList.add(a);
        }
        AttributeList settedAttributes = jmxServerConnection.setAttributes(new ObjectName(name), attributeList);
        if (this.isEcho()) {
            if (settedAttributes.isEmpty()) {
                this.getProject().log("No setted attributes!");
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append("Attributes");
                Iterator iter2 = settedAttributes.iterator();
                while (iter2.hasNext()) {
                    Attribute element = (Attribute)iter2.next();
                    sb.append(' ').append(element.getName());
                }
                sb.append(" were setted");
                this.getProject().log(sb.toString());
            }
        }
        return null;
    }

    protected String getMBeanAttributeType(MBeanInfo minfo, String attribute) throws Exception {
        String mattrType = null;
        MBeanAttributeInfo[] attrs = minfo.getAttributes();
        if (attrs != null) {
            for (int i = 0; mattrType == null && i < attrs.length; ++i) {
                if (!attribute.equals(attrs[i].getName())) continue;
                mattrType = attrs[i].getType();
            }
        }
        return mattrType;
    }

    protected MBeanInfo getMBeanInfo(MBeanServerConnection jmxServerConnection, String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        MBeanInfo minfo = jmxServerConnection.getMBeanInfo(oname);
        return minfo;
    }

    protected String getMBeanAttributeType(MBeanServerConnection jmxServerConnection, String name, String attribute) throws Exception {
        ObjectName oname = new ObjectName(name);
        String mattrType = null;
        MBeanInfo minfo = jmxServerConnection.getMBeanInfo(oname);
        MBeanAttributeInfo[] attrs = minfo.getAttributes();
        if (attrs != null) {
            for (int i = 0; mattrType == null && i < attrs.length; ++i) {
                if (!attribute.equals(attrs[i].getName())) continue;
                mattrType = attrs[i].getType();
            }
        }
        return mattrType;
    }
}

