/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlNonNullableAccessors;

public class SqlTimestampAddFunction
extends SqlFunction {
    private static final int MILLISECOND_PRECISION = 3;
    private static final int MICROSECOND_PRECISION = 6;
    private static final SqlReturnTypeInference RETURN_TYPE_INFERENCE = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        return SqlTimestampAddFunction.deduceType(typeFactory, SqlNonNullableAccessors.getOperandLiteralValueOrThrow(opBinding, 0, TimeUnit.class), opBinding.getOperandType(1), opBinding.getOperandType(2));
    };

    public static RelDataType deduceType(RelDataTypeFactory typeFactory, TimeUnit timeUnit, RelDataType operandType1, RelDataType operandType2) {
        RelDataType type;
        block0 : switch (timeUnit) {
            case MILLISECOND: 
            case MICROSECOND: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                switch (timeUnit) {
                    case MILLISECOND: {
                        type = typeFactory.createSqlType(SqlTypeName.TIMESTAMP, 3);
                        break block0;
                    }
                    case MICROSECOND: {
                        type = typeFactory.createSqlType(SqlTypeName.TIMESTAMP, 6);
                        break block0;
                    }
                }
                if (operandType2.getSqlTypeName() == SqlTypeName.TIME) {
                    type = typeFactory.createSqlType(SqlTypeName.TIME);
                    break;
                }
                type = typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
                break;
            }
            default: {
                type = operandType2;
            }
        }
        return typeFactory.createTypeWithNullability(type, operandType1.isNullable() || operandType2.isNullable());
    }

    SqlTimestampAddFunction() {
        super("TIMESTAMPADD", SqlKind.TIMESTAMP_ADD, RETURN_TYPE_INFERENCE, null, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER, SqlTypeFamily.DATETIME), SqlFunctionCategory.TIMEDATE);
    }
}

