/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.facet;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.solr.analytics.facet.SortableFacet;
import org.apache.solr.analytics.function.ExpressionCalculator;
import org.apache.solr.analytics.function.ReductionCollectionManager;
import org.apache.solr.analytics.value.StringValueStream;

public abstract class PivotNode<T>
extends SortableFacet
implements Consumer<String> {
    private StringValueStream expression;
    protected Map<String, T> currentPivot;

    public PivotNode(String name, StringValueStream expression) {
        super(name);
        this.expression = expression;
    }

    public void addFacetValueCollectionTargets(Map<String, T> pivot) {
        this.currentPivot = pivot;
        this.expression.streamStrings(this);
    }

    public void importPivot(DataInput input, Map<String, T> pivot) throws IOException {
        int size = input.readInt();
        this.currentPivot = pivot;
        for (int i = 0; i < size; ++i) {
            this.importPivotValue(input, input.readUTF());
        }
    }

    protected abstract void importPivotValue(DataInput var1, String var2) throws IOException;

    public void exportPivot(DataOutput output, Map<String, T> pivot) throws IOException {
        output.writeInt(pivot.size());
        for (Map.Entry<String, T> entry : pivot.entrySet()) {
            output.writeUTF(entry.getKey());
            this.exportPivotValue(output, entry.getValue());
        }
    }

    protected abstract void exportPivotValue(DataOutput var1, T var2) throws IOException;

    public abstract Iterable<Map<String, Object>> getPivotedResponse(Map<String, T> var1);

    public static class PivotBranch<T>
    extends PivotNode<PivotDataPair<T>> {
        private final PivotNode<T> childPivot;

        public PivotBranch(String name, StringValueStream expression, PivotNode<T> childPivot) {
            super(name, expression);
            this.childPivot = childPivot;
        }

        @Override
        public void setReductionCollectionManager(ReductionCollectionManager collectionManager) {
            super.setReductionCollectionManager(collectionManager);
            this.childPivot.setReductionCollectionManager(collectionManager);
        }

        @Override
        public void setExpressionCalculator(ExpressionCalculator expressionCalculator) {
            super.setExpressionCalculator(expressionCalculator);
            this.childPivot.setExpressionCalculator(expressionCalculator);
        }

        @Override
        public void accept(String pivotValue) {
            PivotDataPair pivotData = (PivotDataPair)this.currentPivot.get(pivotValue);
            if (pivotData == null) {
                pivotData = new PivotDataPair();
                pivotData.childPivots = new HashMap();
                pivotData.pivotReduction = this.collectionManager.newDataCollectionTarget();
                this.currentPivot.put(pivotValue, pivotData);
            } else {
                this.collectionManager.addCollectTarget(pivotData.pivotReduction);
            }
            this.childPivot.addFacetValueCollectionTargets(pivotData.childPivots);
        }

        @Override
        protected void importPivotValue(DataInput input, String pivotValue) throws IOException {
            PivotDataPair pivotData = (PivotDataPair)this.currentPivot.get(pivotValue);
            if (pivotData == null) {
                pivotData = new PivotDataPair();
                pivotData.childPivots = new HashMap();
                pivotData.pivotReduction = this.collectionManager.newDataCollectionIO();
                this.currentPivot.put(pivotValue, pivotData);
            } else {
                this.collectionManager.prepareReductionDataIO(pivotData.pivotReduction);
            }
            this.collectionManager.mergeData();
            this.childPivot.importPivot(input, pivotData.childPivots);
        }

        @Override
        protected void exportPivotValue(DataOutput output, PivotDataPair<T> pivotData) throws IOException {
            this.collectionManager.prepareReductionDataIO(pivotData.pivotReduction);
            this.collectionManager.exportData();
            this.childPivot.exportPivot(output, pivotData.childPivots);
        }

        @Override
        public Iterable<Map<String, Object>> getPivotedResponse(Map<String, PivotDataPair<T>> pivot) {
            ArrayList<SortableFacet.FacetBucket> facetResults = new ArrayList<SortableFacet.FacetBucket>();
            pivot.forEach((facetVal, dataPair) -> {
                this.collectionManager.setData(dataPair.pivotReduction);
                facetResults.add(new SortableFacet.FacetBucket((String)facetVal, this.expressionCalculator.getResults()));
            });
            Iterable<SortableFacet.FacetBucket> facetResultsIter = this.applyOptions(facetResults);
            LinkedList<Map<String, Object>> results = new LinkedList<Map<String, Object>>();
            for (SortableFacet.FacetBucket bucket : facetResultsIter) {
                HashMap<String, Object> bucketMap = new HashMap<String, Object>();
                bucketMap.put("pivot", this.name);
                bucketMap.put("value", bucket.getFacetValue());
                bucketMap.put("results", bucket.getResults());
                bucketMap.put("children", this.childPivot.getPivotedResponse(pivot.get((Object)bucket.getFacetValue()).childPivots));
                results.add(bucketMap);
            }
            return results;
        }

        protected static class PivotDataPair<T> {
            ReductionCollectionManager.ReductionDataCollection pivotReduction;
            Map<String, T> childPivots;

            protected PivotDataPair() {
            }
        }
    }

    public static class PivotLeaf
    extends PivotNode<ReductionCollectionManager.ReductionDataCollection> {
        public PivotLeaf(String name, StringValueStream expression) {
            super(name, expression);
        }

        @Override
        public void accept(String pivotValue) {
            ReductionCollectionManager.ReductionDataCollection collection = (ReductionCollectionManager.ReductionDataCollection)this.currentPivot.get(pivotValue);
            if (collection == null) {
                collection = this.collectionManager.newDataCollectionTarget();
                this.currentPivot.put(pivotValue, collection);
            } else {
                this.collectionManager.addCollectTarget(collection);
            }
        }

        @Override
        protected void importPivotValue(DataInput input, String pivotValue) throws IOException {
            ReductionCollectionManager.ReductionDataCollection dataCollection = (ReductionCollectionManager.ReductionDataCollection)this.currentPivot.get(pivotValue);
            if (dataCollection == null) {
                this.currentPivot.put(pivotValue, this.collectionManager.newDataCollectionIO());
            } else {
                this.collectionManager.prepareReductionDataIO(dataCollection);
            }
            this.collectionManager.mergeData();
        }

        @Override
        protected void exportPivotValue(DataOutput output, ReductionCollectionManager.ReductionDataCollection pivotData) throws IOException {
            this.collectionManager.prepareReductionDataIO(pivotData);
            this.collectionManager.exportData();
        }

        @Override
        public Iterable<Map<String, Object>> getPivotedResponse(Map<String, ReductionCollectionManager.ReductionDataCollection> pivot) {
            ArrayList<SortableFacet.FacetBucket> facetResults = new ArrayList<SortableFacet.FacetBucket>();
            pivot.forEach((facetVal, dataCol) -> {
                this.collectionManager.setData((ReductionCollectionManager.ReductionDataCollection)dataCol);
                facetResults.add(new SortableFacet.FacetBucket((String)facetVal, this.expressionCalculator.getResults()));
            });
            Iterable<SortableFacet.FacetBucket> facetResultsIter = this.applyOptions(facetResults);
            LinkedList<Map<String, Object>> results = new LinkedList<Map<String, Object>>();
            for (SortableFacet.FacetBucket bucket : facetResultsIter) {
                HashMap<String, Object> bucketMap = new HashMap<String, Object>();
                bucketMap.put("pivot", this.name);
                bucketMap.put("value", bucket.getFacetValue());
                bucketMap.put("results", bucket.getResults());
                results.add(bucketMap);
            }
            return results;
        }
    }
}

