/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.thrift.util.mem;

import java.nio.ByteBuffer;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public final class TMemoryInputTransport
extends TTransport {
    private ByteBuffer buffer;
    private int position;
    private int limit;

    public TMemoryInputTransport(ByteBuffer buf) {
        this.buffer = buf;
        this.position = 0;
        this.limit = this.buffer.capacity();
    }

    public void close() {
    }

    public boolean isOpen() {
        return true;
    }

    public void open() throws TTransportException {
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        int amtToRead;
        int bytesRemaining = this.getBytesRemainingInBuffer();
        int n = amtToRead = len > bytesRemaining ? bytesRemaining : len;
        if (amtToRead > 0) {
            for (int i = 0; i < amtToRead; ++i) {
                buf[off] = this.buffer.get(this.position + i);
                ++off;
            }
            this.consumeBuffer(amtToRead);
        }
        return amtToRead;
    }

    public void write(byte[] buf, int off, int len) throws TTransportException {
        throw new UnsupportedOperationException("No writing allowed!");
    }

    public byte[] getBuffer() {
        throw new UnsupportedOperationException();
    }

    public int getBufferPosition() {
        return this.position;
    }

    public int getBytesRemainingInBuffer() {
        return this.limit - this.position;
    }

    public void consumeBuffer(int len) {
        this.position += len;
    }

    public int read() {
        int temp = this.buffer.get(this.position) & 0xFF;
        this.consumeBuffer(1);
        return temp;
    }

    public boolean readBoolean() {
        int temp = this.read();
        if (temp < 0) {
            throw new IllegalStateException();
        }
        return temp != 0;
    }

    public byte readByte() {
        int temp = this.read();
        if (temp < 0) {
            throw new IllegalStateException();
        }
        return (byte)temp;
    }

    public short readShort() {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new IllegalStateException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readInt() {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new IllegalStateException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public ByteBuffer readBytes(int size) throws TException {
        if (size > this.getBytesRemainingInBuffer()) {
            throw new TException("Requested " + size + ", available only " + this.buffer.remaining());
        }
        ByteBuffer dup = this.buffer.duplicate();
        dup.position(this.position).limit(this.position + size);
        this.consumeBuffer(size);
        return dup.slice();
    }

    public void readFully(byte[] buffer) throws TException {
        this.readFully(buffer, 0, buffer.length);
    }

    public void readFully(byte[] buf, int offset, int count) throws TException {
        if (this.buffer == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > buf.length || count < 0 || count > buf.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        while (count > 0) {
            int result = this.read(buf, offset, count);
            if (result < 0) {
                throw new IllegalStateException();
            }
            offset += result;
            count -= result;
        }
    }
}

