/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.method.dispatch;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.server.impl.inject.InjectableValuesProvider;
import com.sun.jersey.server.impl.model.method.dispatch.AbstractResourceMethodDispatchProvider;
import com.sun.jersey.spi.inject.Injectable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityParamDispatchProvider
extends AbstractResourceMethodDispatchProvider {
    @Override
    protected InjectableValuesProvider getInjectableValuesProvider(AbstractResourceMethod abstractResourceMethod) {
        boolean requireNoEntityParameter = "GET".equals(abstractResourceMethod.getHttpMethod());
        List<Injectable> is = this.processParameters(abstractResourceMethod, requireNoEntityParameter);
        if (is == null) {
            return null;
        }
        return new InjectableValuesProvider(is);
    }

    private List<Injectable> processParameters(AbstractResourceMethod method, boolean requireNoEntityParameter) {
        if (null == method.getParameters() || 0 == method.getParameters().size()) {
            return Collections.emptyList();
        }
        boolean hasEntity = false;
        ArrayList<Injectable> is = new ArrayList<Injectable>(method.getParameters().size());
        for (int i = 0; i < method.getParameters().size(); ++i) {
            Parameter parameter = method.getParameters().get(i);
            if (Parameter.Source.ENTITY == parameter.getSource()) {
                hasEntity = true;
                is.add(this.processEntityParameter(parameter, method.getMethod().getParameterAnnotations()[i], requireNoEntityParameter));
                continue;
            }
            is.add(this.getInjectableProviderContext().getInjectable(parameter, ComponentScope.PerRequest));
        }
        if (is.contains(null)) {
            int n = 0;
            for (Injectable i : is) {
                if (i != null) continue;
                ++n;
            }
            if (n > 1 || hasEntity) {
                return null;
            }
            for (int i = 0; i < is.size(); ++i) {
                if (is.get(i) != null) continue;
                Injectable ij = this.processEntityParameter(method.getParameters().get(i), method.getMethod().getParameterAnnotations()[i], requireNoEntityParameter);
                is.set(i, ij);
                break;
            }
            if (is.contains(null)) {
                return null;
            }
        }
        return is;
    }

    private Injectable processEntityParameter(Parameter parameter, Annotation[] annotations, boolean requireNoEntityParameter) {
        if (requireNoEntityParameter) {
            return null;
        }
        return new EntityInjectable(parameter.getParameterClass(), parameter.getParameterType(), annotations);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EntityInjectable
    extends AbstractHttpContextInjectable<Object> {
        final Class<?> c;
        final Type t;
        final Annotation[] as;

        EntityInjectable(Class c, Type t, Annotation[] as) {
            this.c = c;
            this.t = t;
            this.as = as;
        }

        @Override
        public Object getValue(HttpContext context) {
            return context.getRequest().getEntity(this.c, this.t, this.as);
        }
    }
}

