/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.components.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.table.TableCellRendererPersistent;

public abstract class EnhancedTableCellRenderer
extends JPanel
implements TableCellRendererPersistent {
    protected boolean supportsFocusBorder;
    private Border originalBorder;
    private Color darkerUnselectedBackground;
    private Color unselectedBackground;
    private Color unselectedForeground;
    private Insets originalBorderInsets;
    private int horizontalAlignment;

    public EnhancedTableCellRenderer() {
        this.setOpaque(true);
        this.supportsFocusBorder = false;
        this.horizontalAlignment = 10;
        this.unselectedBackground = UIUtils.getProfilerResultsBackground();
        this.darkerUnselectedBackground = UIUtils.getDarker(this.unselectedBackground);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.originalBorder = border;
        if (this.originalBorder != null) {
            this.originalBorderInsets = this.originalBorder.getBorderInsets(this);
        }
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setSupportsFocusBorder(boolean supportsFocusBorder) {
        this.supportsFocusBorder = supportsFocusBorder;
        if (supportsFocusBorder && this.originalBorder == null) {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public boolean getSupportsFocusBorder() {
        return this.supportsFocusBorder;
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.supportsFocusBorder) {
            if (hasFocus && isSelected && this.originalBorder != null) {
                CompoundBorder focusBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIUtils.getDarkerLine(table.getSelectionBackground(), 0.65f)), BorderFactory.createEmptyBorder(this.originalBorderInsets.top, this.originalBorderInsets.left - 1, this.originalBorderInsets.bottom, this.originalBorderInsets.right));
                super.setBorder(focusBorder);
            } else {
                super.setBorder(this.originalBorder);
            }
        }
        if (isSelected && table.isEnabled()) {
            this.setRowForeground(table.isFocusOwner() ? table.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
            this.setRowBackground(table.isFocusOwner() ? table.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
        } else if (!table.isEnabled()) {
            this.setRowForeground(UIManager.getColor("TextField.inactiveForeground"));
            this.setRowBackground(UIManager.getColor("TextField.inactiveBackground"));
        } else if ((row & 1) == 0) {
            this.setRowForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            this.setRowBackground(this.darkerUnselectedBackground != null ? this.darkerUnselectedBackground : UIUtils.getDarker(table.getBackground()));
        } else {
            this.setRowForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            this.setRowBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.setState(table, value, isSelected, hasFocus, row, column);
        this.setValue(table, value, row, column);
        return this;
    }

    @Override
    public abstract Component getTableCellRendererComponentPersistent(JTable var1, Object var2, boolean var3, boolean var4, int var5, int var6);

    public static Color getDarker(Color c) {
        return UIUtils.getSafeColor(c.getRed() - 30, c.getGreen() - 30, c.getBlue() - 30);
    }

    protected void setRowBackground(Color c) {
        this.setBackground(c);
    }

    protected void setRowForeground(Color c) {
        this.setForeground(c);
    }

    protected abstract void setValue(JTable var1, Object var2, int var3, int var4);

    protected void setState(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
    }
}

