/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.io.Serializable;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;

public class ExtendedColumnInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _columnName;
    private String _columnType;
    private int _columnSize;
    private int _decimalDigits;
    private boolean _nullable;
    private String _cat;
    private String _schem;
    private String _simpleTableName;
    private String _qualifiedName;
    private String _remarks;
    private int _columnTypeID;

    public ExtendedColumnInfo(TableColumnInfo info, String simpleTableName) {
        this._columnName = info.getColumnName();
        this._columnType = info.getTypeName();
        this._columnTypeID = info.getDataType();
        this._columnSize = info.getColumnSize();
        this._decimalDigits = info.getDecimalDigits();
        this._remarks = info.getRemarks();
        this._nullable = "YES".equals(info.isNullable());
        this._cat = info.getCatalogName();
        this._schem = info.getSchemaName();
        this._simpleTableName = simpleTableName;
        this._qualifiedName = this._cat + "." + this._schem + "." + this._simpleTableName + "." + this._columnName;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public String getColumnType() {
        return this._columnType;
    }

    public int getColumnSize() {
        return this._columnSize;
    }

    public int getDecimalDigits() {
        return this._decimalDigits;
    }

    public boolean isNullable() {
        return this._nullable;
    }

    public String getCatalog() {
        return this._cat;
    }

    public String getSchema() {
        return this._schem;
    }

    public String getRemarks() {
        return this._remarks;
    }

    public String getSimpleTableName() {
        return this._simpleTableName;
    }

    public int getColumnTypeID() {
        return this._columnTypeID;
    }

    public boolean isCharacterType() {
        return 12 == this._columnTypeID || -1 == this._columnTypeID || 1 == this._columnTypeID || -9 == this._columnTypeID;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._qualifiedName == null ? 0 : this._qualifiedName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtendedColumnInfo other = (ExtendedColumnInfo)obj;
        return !(this._qualifiedName == null ? other._qualifiedName != null : !this._qualifiedName.equals(other._qualifiedName));
    }
}

