/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.preferences.PreferenceType;
import net.sourceforge.squirrel_sql.fw.gui.DefaultFileListBoxModel;
import net.sourceforge.squirrel_sql.fw.gui.FileListBox;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.IFileListBoxModel;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverClassLoader;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DriverInternalFrame
extends DialogWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DriverInternalFrame.class);
    private static final ILogger s_log = LoggerController.createLogger(DriverInternalFrame.class);
    private static final int COLUMN_COUNT = 25;
    private static final int LIST_WIDTH = 400;
    private final IApplication _app;
    private final ISQLDriver _sqlDriver;
    private final int _maintType;
    private final JLabel _titleLbl = new JLabel();
    private final JTextField _driverName = new JTextField();
    private final JComboBox _driverClassCmb = new JComboBox();
    private final JTextField _url = new JTextField();
    private final JTextField _weburl = new JTextField();
    private final FileListBox _javaClassPathList = new FileListBox();
    private final FileListBox _extraClassPathList = new FileListBox(new DefaultFileListBoxModel());
    private ListDriversButton _javaClasspathListDriversBtn;
    private ListDriversButton _extraClasspathListDriversBtn;
    private JButton _extraClasspathDeleteBtn;
    private JButton _extraClasspathUpBtn;
    private JButton _extraClasspathDownBtn;
    private File lastExtraClassPathFileSelected = null;

    DriverInternalFrame(IApplication app, ISQLDriver sqlDriver, int maintType) {
        super("", true, app);
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (sqlDriver == null) {
            throw new IllegalArgumentException("Null ISQLDriver passed");
        }
        if (maintType < 1 || maintType > 3) {
            throw new IllegalArgumentException(s_stringMgr.getString("DriverInternalFrame.error.illegalvalue", maintType));
        }
        this._app = app;
        this._sqlDriver = sqlDriver;
        this._maintType = maintType;
        this.createGUI();
        this.loadData();
        this.pack();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this._titleLbl.setText(title);
    }

    ISQLDriver getSQLDriver() {
        return this._sqlDriver;
    }

    private void loadData() {
        this._driverName.setText(this._sqlDriver.getName());
        this._driverClassCmb.setSelectedItem(this._sqlDriver.getDriverClassName());
        this._url.setText(this._sqlDriver.getUrl());
        this._weburl.setText(this._sqlDriver.getWebSiteUrl());
        this._extraClassPathList.removeAll();
        String[] fileNames = this._sqlDriver.getJarFileNames();
        IFileListBoxModel model = this._extraClassPathList.getTypedModel();
        for (int i = 0; i < fileNames.length; ++i) {
            model.addFile(new File(fileNames[i]));
        }
        if (model.getSize() > 0) {
            this._extraClassPathList.setSelectedIndex(0);
        }
    }

    private void performClose() {
        this.dispose();
    }

    private void performOk() {
        try {
            this.applyFromDialog();
            if (this._maintType == 1 || this._maintType == 3) {
                this._app.getDataCache().addDriver(this._sqlDriver, this._app.getMessageHandler());
            } else {
                this._app.getDataCache().refreshDriver(this._sqlDriver, this._app.getMessageHandler());
            }
            this._app.savePreferences(PreferenceType.DRIVER_DEFINITIONS);
            this.dispose();
        }
        catch (Throwable th) {
            this.displayErrorMessage(th);
        }
    }

    private void applyFromDialog() throws ValidationException {
        this._sqlDriver.setName(this._driverName.getText().trim());
        this._sqlDriver.setJarFileNames(this._extraClassPathList.getTypedModel().getFileNames());
        String driverClassName = (String)this._driverClassCmb.getSelectedItem();
        this._sqlDriver.setDriverClassName(driverClassName != null ? driverClassName.trim() : null);
        this._sqlDriver.setUrl(this._url.getText().trim());
        this._sqlDriver.setWebSiteUrl(this._weburl.getText().trim());
    }

    private void displayErrorMessage(final Throwable th) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DriverInternalFrame.this._app.showErrorDialog(th);
            }
        });
    }

    private void createGUI() {
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        String winTitle = this._maintType == 2 ? s_stringMgr.getString("DriverInternalFrame.changedriver", this._sqlDriver.getName()) : s_stringMgr.getString("DriverInternalFrame.adddriver");
        this.setTitle(winTitle);
        this._driverName.setColumns(25);
        this._url.setColumns(25);
        Container contentPane = this.getContentPane();
        Color color = UIManager.getDefaults().getColor("Panel.background");
        if (color != null) {
            contentPane.setBackground(color);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        contentPane.setLayout(new GridBagLayout());
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.fill = 2;
        contentPane.add((Component)this._titleLbl, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 10, 5, 10);
        contentPane.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.createDriverPanel(), gbc);
        JTabbedPane tabPnl = new JTabbedPane();
        tabPnl.addTab(s_stringMgr.getString("DriverInternalFrame.javaclasspath"), this.createJavaClassPathPanel());
        tabPnl.addTab(s_stringMgr.getString("DriverInternalFrame.extraclasspath"), this.createExtraClassPathPanel());
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        contentPane.add((Component)tabPnl, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        contentPane.add(this.createDriverClassPanel(), gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 10, 5, 10);
        contentPane.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.createButtonsPanel(), gbc);
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DriverInternalFrame.this.performClose();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this.getRootPane().getActionMap().put("CloseAction", closeAction);
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel();
        JButton okBtn = new JButton(s_stringMgr.getString("DriverInternalFrame.ok"));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverInternalFrame.this.performOk();
            }
        });
        JButton closeBtn = new JButton(s_stringMgr.getString("DriverInternalFrame.close"));
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverInternalFrame.this.performClose();
            }
        });
        pnl.add(okBtn);
        pnl.add(closeBtn);
        GUIUtils.setJButtonSizesTheSame(new JButton[]{okBtn, closeBtn});
        this.getRootPane().setDefaultButton(okBtn);
        return pnl;
    }

    private JPanel createDriverPanel() {
        this._driverName.setColumns(25);
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("DriverInternalFrame.driver")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        pnl.add((Component)new JLabel(s_stringMgr.getString("DriverInternalFrame.name"), 4), gbc);
        ++gbc.gridy;
        pnl.add((Component)new JLabel(s_stringMgr.getString("DriverInternalFrame.egurl"), 4), gbc);
        ++gbc.gridy;
        pnl.add((Component)new JLabel(s_stringMgr.getString("DriverInternalFrame.weburl"), 4), gbc);
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        ++gbc.gridx;
        pnl.add((Component)this._driverName, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._url, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._weburl, gbc);
        return pnl;
    }

    private Component createDriverClassPanel() {
        this._driverClassCmb.setEditable(true);
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        pnl.add((Component)new JLabel(s_stringMgr.getString("DriverInternalFrame.classname"), 4), gbc);
        gbc.weightx = 1.0;
        ++gbc.gridx;
        pnl.add((Component)this._driverClassCmb, gbc);
        return pnl;
    }

    private JPanel createJavaClassPathPanel() {
        this._javaClasspathListDriversBtn = new ListDriversButton(this._javaClassPathList);
        this._javaClasspathListDriversBtn.setEnabled(this._javaClassPathList.getModel().getSize() > 0);
        IFileListBoxModel model = this._javaClassPathList.getTypedModel();
        if (model.getSize() > 0) {
            this._javaClassPathList.setSelectedIndex(0);
        }
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.anchor = 17;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        JScrollPane sp = new JScrollPane(this._javaClassPathList, 22, 32);
        Dimension dm = sp.getPreferredSize();
        dm.width = 400;
        sp.setPreferredSize(dm);
        pnl.add((Component)sp, gbc);
        ++gbc.gridx;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = 0.0;
        pnl.add((Component)this._javaClasspathListDriversBtn, gbc);
        return pnl;
    }

    private JPanel createExtraClassPathPanel() {
        this._extraClasspathListDriversBtn = new ListDriversButton(this._extraClassPathList);
        this._extraClassPathList.addListSelectionListener(new ExtraClassPathListBoxListener());
        this._extraClassPathList.getModel().addListDataListener(new ExtraClassPathListDataListener());
        this._extraClasspathUpBtn = new JButton(s_stringMgr.getString("DriverInternalFrame.up"));
        this._extraClasspathUpBtn.setEnabled(false);
        this._extraClasspathUpBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent evt) {
                FileListBox fileListBox = DriverInternalFrame.this._extraClassPathList;
                synchronized (fileListBox) {
                    int idx = DriverInternalFrame.this._extraClassPathList.getSelectedIndex();
                    if (idx > 0) {
                        IFileListBoxModel model = DriverInternalFrame.this._extraClassPathList.getTypedModel();
                        File file = model.removeFile(idx);
                        model.insertFileAt(file, --idx);
                        DriverInternalFrame.this._extraClassPathList.setSelectedIndex(idx);
                    }
                }
            }
        });
        this._extraClasspathDownBtn = new JButton(s_stringMgr.getString("DriverInternalFrame.down"));
        this._extraClasspathDownBtn.setEnabled(false);
        this._extraClasspathDownBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent evt) {
                FileListBox fileListBox = DriverInternalFrame.this._extraClassPathList;
                synchronized (fileListBox) {
                    int idx = DriverInternalFrame.this._extraClassPathList.getSelectedIndex();
                    IFileListBoxModel model = DriverInternalFrame.this._extraClassPathList.getTypedModel();
                    if (idx > -1 && idx < model.getSize() - 1) {
                        File file = model.removeFile(idx);
                        model.insertFileAt(file, ++idx);
                        DriverInternalFrame.this._extraClassPathList.setSelectedIndex(idx);
                    }
                }
            }
        });
        AddListEntryButton newBtn = new AddListEntryButton();
        this._extraClasspathDeleteBtn = new JButton(s_stringMgr.getString("DriverInternalFrame.delete"));
        this._extraClasspathDeleteBtn.setEnabled(false);
        this._extraClasspathDeleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int idx = DriverInternalFrame.this._extraClassPathList.getSelectedIndex();
                if (idx != -1) {
                    IFileListBoxModel model = DriverInternalFrame.this._extraClassPathList.getTypedModel();
                    model.removeFile(idx);
                    int size = model.getSize();
                    if (idx < size) {
                        DriverInternalFrame.this._extraClassPathList.setSelectedIndex(idx);
                    } else if (size > 0) {
                        DriverInternalFrame.this._extraClassPathList.setSelectedIndex(size - 1);
                    }
                }
            }
        });
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridheight = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        JScrollPane sp = new JScrollPane(this._extraClassPathList, 22, 32);
        Dimension dm = sp.getPreferredSize();
        dm.width = 400;
        sp.setPreferredSize(dm);
        pnl.add((Component)sp, gbc);
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        ++gbc.gridx;
        pnl.add((Component)this._extraClasspathListDriversBtn, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(5, 5, 5, 5);
        pnl.add((Component)new JSeparator(), gbc);
        gbc.insets = new Insets(4, 4, 4, 4);
        ++gbc.gridy;
        pnl.add((Component)this._extraClasspathUpBtn, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._extraClasspathDownBtn, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(5, 5, 5, 5);
        pnl.add((Component)new JSeparator(), gbc);
        gbc.insets = new Insets(4, 4, 4, 4);
        ++gbc.gridy;
        pnl.add((Component)newBtn, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._extraClasspathDeleteBtn, gbc);
        return pnl;
    }

    private void addDriverClassToCombo(final String driverClassName) {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                DriverInternalFrame.this._driverClassCmb.addItem(driverClassName);
            }
        });
    }

    private class ExtraClassPathListBoxListener
    implements ListSelectionListener {
        private ExtraClassPathListBoxListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            int selIdx = DriverInternalFrame.this._extraClassPathList.getSelectedIndex();
            DriverInternalFrame.this.lastExtraClassPathFileSelected = DriverInternalFrame.this._extraClassPathList.getSelectedFile();
            ListModel model = DriverInternalFrame.this._extraClassPathList.getModel();
            DriverInternalFrame.this._extraClasspathDeleteBtn.setEnabled(selIdx != -1);
            DriverInternalFrame.this._extraClasspathUpBtn.setEnabled(selIdx > 0 && model.getSize() > 1);
            DriverInternalFrame.this._extraClasspathDownBtn.setEnabled(selIdx > -1 && selIdx < model.getSize() - 1);
        }
    }

    private class ExtraClassPathListDataListener
    implements ListDataListener {
        private ExtraClassPathListDataListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent evt) {
            boolean enable = DriverInternalFrame.this._extraClassPathList.getModel().getSize() > 0;
            DriverInternalFrame.this._extraClasspathListDriversBtn.setEnabled(enable);
        }

        @Override
        public void intervalAdded(ListDataEvent evt) {
            boolean enable = DriverInternalFrame.this._extraClassPathList.getModel().getSize() > 0;
            DriverInternalFrame.this._extraClasspathListDriversBtn.setEnabled(enable);
        }

        @Override
        public void intervalRemoved(ListDataEvent evt) {
            boolean enable = DriverInternalFrame.this._extraClassPathList.getModel().getSize() > 0;
            DriverInternalFrame.this._extraClasspathListDriversBtn.setEnabled(enable);
        }
    }

    private final class ListDriversButton
    extends JButton
    implements ActionListener {
        private FileListBox _listBox;

        ListDriversButton(FileListBox listBox) {
            super(s_stringMgr.getString("DriverInternalFrame.listdrivers"));
            this.setEnabled(false);
            this._listBox = listBox;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DriverInternalFrame.this._driverClassCmb.removeAllItems();
            final String[] fileNames = this._listBox.getTypedModel().getFileNames();
            if (fileNames.length > 0) {
                DriverInternalFrame.this._app.getThreadPool().addTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            URL[] urls = new URL[fileNames.length];
                            for (int i = 0; i < fileNames.length; ++i) {
                                urls[i] = new File(fileNames[i]).toURI().toURL();
                            }
                            SQLDriverClassLoader cl = new SQLDriverClassLoader(urls);
                            Class<?>[] classes = cl.getDriverClasses(s_log);
                            for (int i = 0; i < classes.length; ++i) {
                                DriverInternalFrame.this.addDriverClassToCombo(classes[i].getName());
                            }
                        }
                        catch (MalformedURLException ex) {
                            DriverInternalFrame.this.displayErrorMessage(ex);
                        }
                    }
                });
            }
            if (DriverInternalFrame.this._driverClassCmb.getItemCount() > 0) {
                DriverInternalFrame.this._driverClassCmb.setSelectedIndex(0);
            }
        }
    }

    private final class AddListEntryButton
    extends JButton
    implements ActionListener {
        private JFileChooser _chooser;

        AddListEntryButton() {
            super(s_stringMgr.getString("DriverInternalFrame.add"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            File[] selFiles;
            int returnVal;
            if (this._chooser == null) {
                this._chooser = new JFileChooser();
                if (DriverInternalFrame.this.lastExtraClassPathFileSelected != null) {
                    if (DriverInternalFrame.this.lastExtraClassPathFileSelected.isDirectory()) {
                        this._chooser.setCurrentDirectory(DriverInternalFrame.this.lastExtraClassPathFileSelected);
                    } else {
                        this._chooser.setCurrentDirectory(new File(DriverInternalFrame.this.lastExtraClassPathFileSelected.getParent()));
                    }
                }
                this._chooser.setFileHidingEnabled(false);
                this._chooser.setMultiSelectionEnabled(true);
                this._chooser.setFileSelectionMode(2);
                this._chooser.addChoosableFileFilter(new FileExtensionFilter(s_stringMgr.getString("DriverInternalFrame.jarfiles"), new String[]{".jar", ".zip"}));
            }
            if ((returnVal = this._chooser.showOpenDialog(this.getParent())) == 0 && (selFiles = this._chooser.getSelectedFiles()) != null) {
                IFileListBoxModel myModel = DriverInternalFrame.this._extraClassPathList.getTypedModel();
                for (int i = 0; i < selFiles.length; ++i) {
                    myModel.addFile(selFiles[i]);
                }
                DriverInternalFrame.this._extraClassPathList.setSelectedIndex(myModel.getSize() - 1);
            }
        }
    }

    public static interface MaintenanceType {
        public static final int NEW = 1;
        public static final int MODIFY = 2;
        public static final int COPY = 3;
    }
}

