/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;

public class JDBCTransaction
implements Transaction {
    private static final Log log = LogFactory.getLog((Class)JDBCTransaction.class);
    private final JDBCContext jdbcContext;
    private final TransactionFactory.Context transactionContext;
    private boolean toggleAutoCommit;
    private boolean begun;
    private boolean rolledBack;
    private boolean committed;
    private boolean commitFailed;
    private List synchronizations;
    private boolean callback;
    private int timeout = -1;

    public JDBCTransaction(JDBCContext jdbcContext, TransactionFactory.Context transactionContext) {
        this.jdbcContext = jdbcContext;
        this.transactionContext = transactionContext;
    }

    public void begin() throws HibernateException {
        if (this.begun) {
            return;
        }
        if (this.commitFailed) {
            throw new TransactionException("cannot re-start transaction after failed commit");
        }
        log.debug((Object)"begin");
        try {
            this.toggleAutoCommit = this.jdbcContext.connection().getAutoCommit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("current autocommit status: " + this.toggleAutoCommit));
            }
            if (this.toggleAutoCommit) {
                log.debug((Object)"disabling autocommit");
                this.jdbcContext.connection().setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            log.error((Object)"JDBC begin failed", (Throwable)e);
            throw new TransactionException("JDBC begin failed: ", e);
        }
        this.callback = this.jdbcContext.registerCallbackIfNecessary();
        this.begun = true;
        this.committed = false;
        this.rolledBack = false;
        if (this.timeout > 0) {
            this.jdbcContext.getConnectionManager().getBatcher().setTransactionTimeout(this.timeout);
        }
        this.jdbcContext.afterTransactionBegin(this);
    }

    private void closeIfRequired() throws HibernateException {
        if (this.callback && this.transactionContext.shouldAutoClose() && !this.transactionContext.isClosed()) {
            try {
                this.transactionContext.managedClose();
            }
            catch (HibernateException he) {
                log.error((Object)"Could not close session", (Throwable)he);
            }
        }
    }

    public void commit() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"commit");
        if (!this.transactionContext.isFlushModeNever() && this.callback) {
            this.transactionContext.managedFlush();
        }
        this.notifyLocalSynchsBeforeTransactionCompletion();
        if (this.callback) {
            this.jdbcContext.beforeTransactionCompletion(this);
        }
        try {
            this.commitAndResetAutoCommit();
            log.debug((Object)"committed JDBC Connection");
            this.committed = true;
            if (this.callback) {
                this.jdbcContext.afterTransactionCompletion(true, this);
            }
            this.notifyLocalSynchsAfterTransactionCompletion(3);
        }
        catch (SQLException e) {
            log.error((Object)"JDBC commit failed", (Throwable)e);
            this.commitFailed = true;
            if (this.callback) {
                this.jdbcContext.afterTransactionCompletion(false, this);
            }
            this.notifyLocalSynchsAfterTransactionCompletion(5);
            throw new TransactionException("JDBC commit failed", e);
        }
        finally {
            this.closeIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitAndResetAutoCommit() throws SQLException {
        try {
            this.jdbcContext.connection().commit();
        }
        finally {
            this.toggleAutoCommit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws HibernateException {
        block7: {
            if (!this.begun && !this.commitFailed) {
                throw new TransactionException("Transaction not successfully started");
            }
            log.debug((Object)"rollback");
            if (this.commitFailed) return;
            try {
                try {
                    this.rollbackAndResetAutoCommit();
                    log.debug((Object)"rolled back JDBC Connection");
                    this.rolledBack = true;
                    this.notifyLocalSynchsAfterTransactionCompletion(4);
                }
                catch (SQLException e) {
                    log.error((Object)"JDBC rollback failed", (Throwable)e);
                    this.notifyLocalSynchsAfterTransactionCompletion(5);
                    throw new TransactionException("JDBC rollback failed", e);
                }
                Object var3_1 = null;
                if (!this.callback) break block7;
                this.jdbcContext.afterTransactionCompletion(false, this);
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                if (this.callback) {
                    this.jdbcContext.afterTransactionCompletion(false, this);
                }
                this.closeIfRequired();
                throw throwable;
            }
        }
        this.closeIfRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackAndResetAutoCommit() throws SQLException {
        try {
            this.jdbcContext.connection().rollback();
        }
        finally {
            this.toggleAutoCommit();
        }
    }

    private void toggleAutoCommit() {
        try {
            if (this.toggleAutoCommit) {
                log.debug((Object)"re-enabling autocommit");
                this.jdbcContext.connection().setAutoCommit(true);
            }
        }
        catch (Exception sqle) {
            log.error((Object)"Could not toggle autocommit", (Throwable)sqle);
        }
    }

    public boolean wasRolledBack() {
        return this.rolledBack;
    }

    public boolean wasCommitted() {
        return this.committed;
    }

    public boolean isActive() {
        return this.begun && !this.rolledBack && !(this.committed | this.commitFailed);
    }

    public void registerSynchronization(Synchronization sync) throws HibernateException {
        if (sync == null) {
            throw new NullPointerException("null Synchronization");
        }
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList();
        }
        this.synchronizations.add(sync);
    }

    private void notifyLocalSynchsBeforeTransactionCompletion() {
        if (this.synchronizations != null) {
            for (int i = 0; i < this.synchronizations.size(); ++i) {
                Synchronization sync = (Synchronization)this.synchronizations.get(i);
                try {
                    sync.beforeCompletion();
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)"exception calling user Synchronization", t);
                }
            }
        }
    }

    private void notifyLocalSynchsAfterTransactionCompletion(int status) {
        this.begun = false;
        if (this.synchronizations != null) {
            for (int i = 0; i < this.synchronizations.size(); ++i) {
                Synchronization sync = (Synchronization)this.synchronizations.get(i);
                try {
                    sync.afterCompletion(status);
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)"exception calling user Synchronization", t);
                }
            }
        }
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }
}

