/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.AttributeCreator;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationFailure;

public final class FixedAttribute
extends AttributeCreator {
    private NodeName nodeName;

    public FixedAttribute(NodeName nodeName, int validationAction, SimpleType schemaType) {
        this.nodeName = nodeName;
        this.setSchemaType(schemaType);
        this.setValidationAction(validationAction);
        this.setOptions(0);
    }

    public int getInstructionNameCode() {
        return 134;
    }

    public NodeName getAttributeName() {
        return this.nodeName;
    }

    public void setSelect(Expression select, Configuration config) {
        super.setSelect(select, config);
        if (this.nodeName.equals(StandardNames.XML_ID_NAME)) {
            select = SystemFunctionCall.makeSystemFunction("normalize-space", new Expression[]{select});
            super.setSelect(select, config);
        }
    }

    public void localTypeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        CharSequence value;
        ValidationFailure err;
        Configuration config = visitor.getConfiguration();
        ConversionRules rules = config.getConversionRules();
        SimpleType schemaType = this.getSchemaType();
        if (schemaType == null) {
            SchemaDeclaration decl;
            int validation = this.getValidationAction();
            if (validation == 1) {
                decl = config.getAttributeDeclaration(this.nodeName.getFingerprint());
                if (decl == null) {
                    XPathException se = new XPathException("Strict validation fails: there is no global attribute declaration for " + this.nodeName.getDisplayName());
                    se.setErrorCode("XTTE1510");
                    se.setLocator(this);
                    throw se;
                }
                schemaType = (SimpleType)decl.getType();
            } else if (validation == 2) {
                decl = config.getAttributeDeclaration(this.nodeName.getFingerprint());
                if (decl != null) {
                    schemaType = (SimpleType)decl.getType();
                } else {
                    visitor.getStaticContext().issueWarning("Lax validation has no effect: there is no global attribute declaration for " + this.nodeName.getDisplayName(), this);
                }
            }
        }
        if (Literal.isAtomic(this.select) && schemaType != null && !schemaType.isNamespaceSensitive() && (err = schemaType.validateContent(value = ((Literal)this.select).getValue().getStringValueCS(), DummyNamespaceResolver.getInstance(), rules)) != null) {
            XPathException se = new XPathException("Attribute value " + Err.wrap(value, 4) + " does not the match the required type " + schemaType.getDescription() + ". " + err.getMessage());
            se.setErrorCode("XTTE1540");
            throw se;
        }
        if (this.select instanceof StringLiteral) {
            boolean special = false;
            String val = ((StringLiteral)this.select).getStringValue();
            for (int k = 0; k < val.length(); ++k) {
                char c = val.charAt(k);
                if (c >= '!' && c <= '~' && c != '<' && c != '>' && c != '&' && c != '\"') continue;
                special = true;
                break;
            }
            if (!special) {
                this.setNoSpecialChars();
            }
        }
    }

    public int getAttributeNameCode() {
        return this.nodeName.getNameCode();
    }

    public int getCardinality() {
        return 16384;
    }

    public Expression copy() {
        FixedAttribute exp = new FixedAttribute(this.nodeName, this.getValidationAction(), this.getSchemaType());
        exp.setSelect(this.select.copy(), this.getExecutable().getConfiguration());
        return exp;
    }

    public NodeName evaluateNodeName(XPathContext context) {
        return this.nodeName;
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        SimpleType type;
        int fp = this.nodeName.getFingerprint();
        if (fp == 641 || fp == 643 || fp == 642 || fp == 644) {
            return;
        }
        if (parentType instanceof SimpleType) {
            XPathException err = new XPathException("Attribute " + this.nodeName.getDisplayName() + " is not permitted in the content model of the simple type " + parentType.getDescription());
            err.setIsTypeError(true);
            err.setLocator(this);
            if (this.getHostLanguage() == 50) {
                err.setErrorCode("XTTE1510");
            } else {
                err.setErrorCode("XQDY0027");
            }
            throw err;
        }
        try {
            type = ((ComplexType)parentType).getAttributeUseType(fp);
        }
        catch (SchemaException e) {
            throw new XPathException(e);
        }
        if (type == null) {
            XPathException err = new XPathException("Attribute " + this.nodeName.getDisplayName() + " is not permitted in the content model of the complex type " + parentType.getDescription());
            err.setIsTypeError(true);
            err.setLocator(this);
            if (this.getHostLanguage() == 50) {
                err.setErrorCode("XTTE1510");
            } else {
                err.setErrorCode("XQDY0027");
            }
            throw err;
        }
        try {
            this.select.checkPermittedContents(type, env, true);
        }
        catch (XPathException e) {
            if (e.getLocator() == null || e.getLocator() == e) {
                e.setLocator(this);
            }
            throw e;
        }
    }

    public NodeInfo evaluateItem(XPathContext context) throws XPathException {
        Orphan o = (Orphan)super.evaluateItem(context);
        assert (o != null);
        this.validateOrphanAttribute(o, context);
        return o;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("directAttribute");
        out.emitAttribute("name", this.nodeName.getDisplayName());
        out.emitAttribute("validation", Validation.toString(this.getValidationAction()));
        if (this.getSchemaType() != null) {
            out.emitAttribute("type", this.getSchemaType().getDescription());
        }
        this.getContentExpression().explain(out);
        out.endElement();
    }
}

