/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigNavigationActionsFactory;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigIndentOptionsProvider
extends FileIndentOptionsProvider {
    public static final String indentSizeKey = "indent_size";
    public static final String continuationSizeKey = "continuation_indent_size";
    public static final String tabWidthKey = "tab_width";
    public static final String indentStyleKey = "indent_style";
    private static final String PROJECT_ADVERTISEMENT_FLAG = "editor.config.ad.shown";
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("EditorConfig", NotificationDisplayType.STICKY_BALLOON, true);

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile psiFile) {
        VirtualFile file;
        if (settings == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(1);
        }
        if ((file = psiFile.getVirtualFile()) == null) {
            return null;
        }
        Project project = psiFile.getProject();
        if (project.isDisposed() || !Utils.isEnabled(settings)) {
            return null;
        }
        List<EditorConfig.OutPair> outPairs = SettingsProviderComponent.getInstance().getOutPairs(project, file);
        return EditorConfigIndentOptionsProvider.applyCodeStyleSettings(project, outPairs, file, settings);
    }

    private static CommonCodeStyleSettings.IndentOptions applyCodeStyleSettings(Project project, List<EditorConfig.OutPair> outPairs, VirtualFile file, CodeStyleSettings settings) {
        String indentSize = Utils.configValueForKey(outPairs, indentSizeKey);
        String continuationIndentSize = Utils.configValueForKey(outPairs, continuationSizeKey);
        String tabWidth = Utils.configValueForKey(outPairs, tabWidthKey);
        String indentStyle = Utils.configValueForKey(outPairs, indentStyleKey);
        CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)settings.getIndentOptions(file.getFileType()).clone();
        if (EditorConfigIndentOptionsProvider.applyIndentOptions(project, indentOptions, indentSize, continuationIndentSize, tabWidth, indentStyle, file.getCanonicalPath())) {
            indentOptions.setOverrideLanguageOptions(true);
            return indentOptions;
        }
        return null;
    }

    private static boolean applyIndentOptions(Project project, CommonCodeStyleSettings.IndentOptions indentOptions, String indentSize, String continuationIndentSize, String tabWidth, String indentStyle, String filePath) {
        boolean changed = false;
        String calculatedIndentSize = EditorConfigIndentOptionsProvider.calculateIndentSize(tabWidth, indentSize);
        String calculatedContinuationSize = EditorConfigIndentOptionsProvider.calculateContinuationIndentSize(calculatedIndentSize, continuationIndentSize);
        String calculatedTabWidth = EditorConfigIndentOptionsProvider.calculateTabWidth(tabWidth, indentSize);
        if (!calculatedIndentSize.isEmpty()) {
            if (EditorConfigIndentOptionsProvider.applyIndentSize(indentOptions, calculatedIndentSize)) {
                changed = true;
            } else {
                Utils.invalidConfigMessage(project, calculatedIndentSize, indentSizeKey, filePath);
            }
        }
        if (!calculatedContinuationSize.isEmpty()) {
            if (EditorConfigIndentOptionsProvider.applyContinuationIndentSize(indentOptions, calculatedContinuationSize)) {
                changed = true;
            } else {
                Utils.invalidConfigMessage(project, calculatedIndentSize, indentSizeKey, filePath);
            }
        }
        if (!calculatedTabWidth.isEmpty()) {
            if (EditorConfigIndentOptionsProvider.applyTabWidth(indentOptions, calculatedTabWidth)) {
                changed = true;
            } else {
                Utils.invalidConfigMessage(project, calculatedTabWidth, tabWidthKey, filePath);
            }
        }
        if (!indentStyle.isEmpty()) {
            if (EditorConfigIndentOptionsProvider.applyIndentStyle(indentOptions, indentStyle)) {
                changed = true;
            } else {
                Utils.invalidConfigMessage(project, indentStyle, indentStyleKey, filePath);
            }
        }
        return changed;
    }

    private static String calculateIndentSize(String tabWidth, String indentSize) {
        return indentSize.equals("tab") ? tabWidth : indentSize;
    }

    private static String calculateContinuationIndentSize(String indentSize, String continuationIndentSize) {
        return continuationIndentSize.isEmpty() ? indentSize : continuationIndentSize;
    }

    private static String calculateTabWidth(String tabWidth, String indentSize) {
        if (tabWidth.isEmpty() && indentSize.equals("tab")) {
            return "";
        }
        if (tabWidth.isEmpty()) {
            return indentSize;
        }
        return tabWidth;
    }

    private static boolean applyIndentSize(CommonCodeStyleSettings.IndentOptions indentOptions, String indentSize) {
        try {
            indentOptions.INDENT_SIZE = Integer.parseInt(indentSize);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean applyContinuationIndentSize(CommonCodeStyleSettings.IndentOptions indentOptions, String continuationIndentSize) {
        try {
            indentOptions.CONTINUATION_INDENT_SIZE = Integer.parseInt(continuationIndentSize);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean applyTabWidth(CommonCodeStyleSettings.IndentOptions indentOptions, String tabWidth) {
        try {
            indentOptions.TAB_SIZE = Integer.parseInt(tabWidth);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean applyIndentStyle(CommonCodeStyleSettings.IndentOptions indentOptions, String indentStyle) {
        if (indentStyle.equals("tab") || indentStyle.equals("space")) {
            indentOptions.USE_TAB_CHARACTER = indentStyle.equals("tab");
            return true;
        }
        return false;
    }

    public boolean areActionsAvailable(@NotNull VirtualFile file, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (file == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(2);
        }
        if (indentOptions == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(3);
        }
        return EditorConfigIndentOptionsProvider.isEditorConfigOptions(indentOptions);
    }

    @Nullable
    public AnAction[] getActions(@NotNull PsiFile file, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (file == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(4);
        }
        if (indentOptions == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(5);
        }
        if (EditorConfigIndentOptionsProvider.isEditorConfigOptions(indentOptions)) {
            ArrayList actions = ContainerUtil.newArrayList();
            actions.addAll(EditorConfigNavigationActionsFactory.getNavigationActions(file));
            return actions.toArray(AnAction.EMPTY_ARRAY);
        }
        return null;
    }

    @Nullable
    public AnAction createDisableAction(@NotNull Project project) {
        if (project == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(6);
        }
        return DumbAwareAction.create((String)EditorConfigBundle.message("action.disable"), e -> {
            if (project == null) {
                EditorConfigIndentOptionsProvider.$$$reportNull$$$0(12);
            }
            EditorConfigSettings settings = (EditorConfigSettings)CodeStyle.getSettings((Project)project).getCustomSettings(EditorConfigSettings.class);
            settings.ENABLED = false;
            EditorConfigIndentOptionsProvider.notifyIndentOptionsChanged((Project)project, null);
            EditorConfigIndentOptionsProvider.showDisabledDetectionNotification(project);
        });
    }

    @Nullable
    public String getHint(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(7);
        }
        return EditorConfigIndentOptionsProvider.isEditorConfigOptions(indentOptions) ? "EditorConfig" : null;
    }

    private static boolean isEditorConfigOptions(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(8);
        }
        return indentOptions.getFileIndentOptionsProvider() instanceof EditorConfigIndentOptionsProvider;
    }

    @Nullable
    public String getAdvertisementText(@NotNull PsiFile psiFile, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        PropertiesComponent projectProperties;
        boolean adFlag;
        if (psiFile == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(9);
        }
        if (indentOptions == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(10);
        }
        if (adFlag = (projectProperties = PropertiesComponent.getInstance((Project)psiFile.getProject())).getBoolean(PROJECT_ADVERTISEMENT_FLAG)) {
            return null;
        }
        projectProperties.setValue(PROJECT_ADVERTISEMENT_FLAG, true);
        return EditorConfigBundle.message("advertisement.text");
    }

    private static void showDisabledDetectionNotification(@NotNull Project project) {
        if (project == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(11);
        }
        EditorConfigDisabledNotification notification = new EditorConfigDisabledNotification(project);
        notification.notify(project);
    }

    public boolean isShowFileIndentOptionsEnabled() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigIndentOptionsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentOptions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "areActionsAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createDisableAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getHint";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isEditorConfigOptions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdvertisementText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "showDisabledDetectionNotification";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createDisableAction$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReEnableAction
    extends DumbAwareAction {
        private final Project myProject;
        private final Notification myNotification;

        private ReEnableAction(@NotNull Project project, Notification notification) {
            if (project == null) {
                ReEnableAction.$$$reportNull$$$0(0);
            }
            super(ApplicationBundle.message((String)"code.style.indent.provider.notification.re.enable", (Object[])new Object[0]));
            this.myProject = project;
            this.myNotification = notification;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ReEnableAction.$$$reportNull$$$0(1);
            }
            EditorConfigSettings settings = (EditorConfigSettings)CodeStyle.getSettings((Project)this.myProject).getCustomSettings(EditorConfigSettings.class);
            settings.ENABLED = true;
            EditorConfigIndentOptionsProvider.notifyIndentOptionsChanged((Project)this.myProject, (PsiFile)null);
            this.myNotification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigIndentOptionsProvider$ReEnableAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShowEditorConfigOption
    extends DumbAwareAction {
        private ShowEditorConfigOption(@Nullable String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowEditorConfigOption.$$$reportNull$$$0(0);
            }
            ShowSettingsUtilImpl.showSettingsDialog((Project)e.getProject(), (String)"preferences.sourceCode", (String)"EditorConfig");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/editorconfig/configmanagement/EditorConfigIndentOptionsProvider$ShowEditorConfigOption", "actionPerformed"));
        }
    }

    private static class EditorConfigDisabledNotification
    extends Notification {
        private EditorConfigDisabledNotification(Project project) {
            super(NOTIFICATION_GROUP.getDisplayId(), EditorConfigBundle.message("disabled.notification"), "", NotificationType.INFORMATION);
            this.addAction((AnAction)new ReEnableAction(project, this));
            this.addAction((AnAction)new ShowEditorConfigOption(ApplicationBundle.message((String)"code.style.indent.provider.notification.settings", (Object[])new Object[0])));
        }
    }
}

