/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.util.DasUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface ModelConsts {
    public static final short NO_POSITION = 0;
    public static final long NO_ID = Long.MIN_VALUE;
    @NotNull
    public static final String NO_NAME = DasUtil.NO_NAME;
    @NotNull
    public static final DataType NO_DATA_TYPE = DataType.UNKNOWN;
    public static final String NO_DISPLAY_ORDER = "\uffff";
    @NotNull
    public static final List<SourceError> NO_ERRORS = Collections.emptyList();
    public static final String ROOT_IDENTITY = "#ROOT";
    @NotNull
    public static final Set<ObjectKind> TABLE_OR_VIEW_KINDS = ModelConsts.setOf(ObjectKind.TABLE, ObjectKind.MAT_VIEW, ObjectKind.VIEW, ObjectKind.VIRTUAL_TABLE, ObjectKind.FOREIGN_TABLE);
    @NotNull
    public static final Set<ObjectKind> CONSTRAINT_KINDS = ModelConsts.setOf(ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK);

    public static <E> Set<E> setOf(E ... items) {
        return Collections.unmodifiableSet(new LinkedHashSet<E>(Arrays.asList(items)));
    }
}

