/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.Version;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DatabaseConnection {
    @NotNull
    public ConnectionRequestor getRequestor();

    @NotNull
    public AdvancedAuditService getAuditService();

    @NotNull
    public DatabaseConnectionPoint getConnectionPoint();

    @Nullable
    public DatabaseMetaData getMetaData() throws SQLException;

    @NotNull
    public Connection getJdbcConnection();

    @NotNull
    public ConsoleRunConfiguration getConfiguration();

    public void setAutoCommit(boolean var1) throws SQLException;

    public boolean getAutoCommit() throws SQLException;

    public void setReadOnly(boolean var1) throws SQLException;

    public boolean isReadOnly() throws SQLException;

    public void rollback() throws SQLException;

    public void rollback(@NotNull Savepoint var1) throws SQLException;

    public void releaseSavepoint(@NotNull Savepoint var1);

    public Savepoint setSavepoint() throws SQLException;

    @NotNull
    public Dbms getDbms();

    @NotNull
    public Version getVersion();

    @NotNull
    public Version getDriverVersion();

    public void commit() throws SQLException;
}

