/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.rails;

import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.rails.projectView.id.NodeId;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;

public class RailsUmlDnDSupport
implements DiagramDnDProvider<RClass> {
    public boolean isAcceptedForDnD(Object object, Project project) {
        if (object instanceof NodeId) {
            String mark = ((NodeId)object).getLocationRootMark();
            if ("AR_MODELCLASS_IN_MODELS_SUBTREE".equals(mark)) {
                PsiElement modelClass = ((NodeId)object).getPsiElement();
                return modelClass != null && modelClass.isValid();
            }
            if ("MODELS_SUBTREE".equals(mark)) {
                PsiElement directory = ((NodeId)object).getPsiElement();
                return directory instanceof PsiDirectory && directory.isValid();
            }
        }
        if (object instanceof RFile) {
            return RailsModel.fromFile((PsiFile)((PsiFile)object)) != null;
        }
        return false;
    }

    public RClass[] wrapToModelObject(Object object, Project project) {
        if (object instanceof NodeId) {
            String mark = ((NodeId)object).getLocationRootMark();
            if ("AR_MODELCLASS_IN_MODELS_SUBTREE".equals(mark)) {
                return new RClass[]{(RClass)((NodeId)object).getPsiElement()};
            }
            if ("MODELS_SUBTREE".equals(mark)) {
                ArrayList all = new ArrayList();
                PsiElement directory = ((NodeId)object).getPsiElement();
                if (directory instanceof PsiDirectory) {
                    PsiFile[] files;
                    for (PsiFile file : files = ((PsiDirectory)directory).getFiles()) {
                        List classes = RContainerUtil.getTopLevelClasses((RContainer)((RContainer)file));
                        all.addAll(classes);
                    }
                }
                return all.toArray(new RClass[0]);
            }
        } else {
            List classes = RContainerUtil.getTopLevelClasses((RContainer)((RContainer)object));
            return classes.toArray(new RClass[0]);
        }
        return new RClass[0];
    }
}

