/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.VcsError;
import com.intellij.dvcs.push.ui.PushTargetEditorListener;
import com.intellij.dvcs.push.ui.PushTargetTextField;
import com.intellij.dvcs.push.ui.VcsEditableTextComponent;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.push.HgTarget;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgPushTargetPanel
extends PushTargetPanel<HgTarget> {
    private static final String ENTER_REMOTE = "Enter Remote";
    private final HgRepository myRepository;
    private final String myBranchName;
    private final TextFieldWithCompletion myDestTargetPanel;
    private final VcsEditableTextComponent myTargetRenderedComponent;

    public HgPushTargetPanel(@NotNull HgRepository repository, @Nullable HgTarget defaultTarget) {
        if (repository == null) {
            HgPushTargetPanel.$$$reportNull$$$0(0);
        }
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.myRepository = repository;
        this.myBranchName = this.myRepository.getCurrentBranchName();
        List<String> targetVariants = HgUtil.getTargetNames(repository);
        String defaultText = defaultTarget != null ? defaultTarget.getPresentation() : "";
        this.myTargetRenderedComponent = new VcsEditableTextComponent("<a href=''>" + defaultText + "</a>", null);
        this.myDestTargetPanel = new PushTargetTextField(repository.getProject(), targetVariants, defaultText);
        this.add((Component)this.myDestTargetPanel, "Center");
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer, boolean isSelected, boolean isActive, @Nullable String forceRenderedText) {
        if (renderer == null) {
            HgPushTargetPanel.$$$reportNull$$$0(1);
        }
        if (forceRenderedText != null) {
            this.myDestTargetPanel.setText(forceRenderedText);
            renderer.append(forceRenderedText);
            return;
        }
        String targetText = this.myDestTargetPanel.getText();
        if (StringUtil.isEmptyOrSpaces((String)targetText)) {
            renderer.append(ENTER_REMOTE, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES, (Object)this.myTargetRenderedComponent);
        }
        this.myTargetRenderedComponent.setSelected(isSelected);
        this.myTargetRenderedComponent.setTransparent(!isActive);
        this.myTargetRenderedComponent.render(renderer);
    }

    @Nullable
    public HgTarget getValue() {
        return this.createValidPushTarget();
    }

    @NotNull
    private HgTarget createValidPushTarget() {
        HgTarget hgTarget = new HgTarget(this.myDestTargetPanel.getText(), this.myBranchName);
        if (hgTarget == null) {
            HgPushTargetPanel.$$$reportNull$$$0(2);
        }
        return hgTarget;
    }

    public void fireOnCancel() {
        this.myDestTargetPanel.setText(this.myTargetRenderedComponent.getText());
    }

    public void fireOnChange() {
        this.myTargetRenderedComponent.updateLinkText(this.myDestTargetPanel.getText());
    }

    @Nullable
    public ValidationInfo verify() {
        if (StringUtil.isEmptyOrSpaces((String)this.myDestTargetPanel.getText())) {
            return new ValidationInfo(VcsError.createEmptyTargetError((String)DvcsUtil.getShortRepositoryName((Repository)this.myRepository)).getText(), (JComponent)((Object)this));
        }
        return null;
    }

    public void setFireOnChangeAction(@NotNull Runnable action) {
        if (action == null) {
            HgPushTargetPanel.$$$reportNull$$$0(3);
        }
    }

    public void addTargetEditorListener(final @NotNull PushTargetEditorListener listener) {
        if (listener == null) {
            HgPushTargetPanel.$$$reportNull$$$0(4);
        }
        this.myDestTargetPanel.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                listener.onTargetInEditModeChanged(HgPushTargetPanel.this.myDestTargetPanel.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/zmlx/hg4idea/push/HgPushTargetPanel$1", "documentChanged"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/push/HgPushTargetPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/push/HgPushTargetPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createValidPushTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFireOnChangeAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTargetEditorListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

