/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshVFsSynchronously {
    private static final Logger LOG = Logger.getInstance(RefreshVFsSynchronously.class);

    private RefreshVFsSynchronously() {
    }

    public static void updateAllChanged(@NotNull UpdatedFiles updatedFiles) {
        if (updatedFiles == null) {
            RefreshVFsSynchronously.$$$reportNull$$$0(0);
        }
        FilesToRefreshCollector callback2 = new FilesToRefreshCollector();
        UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(updatedFiles, callback2);
        RefreshVFsSynchronously.refreshDeletedOrReplaced(callback2.getToRefreshDeletedOrReplaced());
        RefreshVFsSynchronously.refreshFiles(callback2.getToRefresh());
    }

    public static void refreshFiles(@NotNull Collection<? extends File> files2) {
        if (files2 == null) {
            RefreshVFsSynchronously.$$$reportNull$$$0(1);
        }
        HashSet filesToRefresh = ContainerUtil.newHashSet();
        for (File file2 : files2) {
            VirtualFile vf = RefreshVFsSynchronously.findFirstValidVirtualParent(file2);
            if (vf == null) continue;
            filesToRefresh.add(vf);
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])((VirtualFile[])ArrayUtil.toObjectArray((Collection)filesToRefresh, VirtualFile.class)));
    }

    private static void refreshDeletedOrReplaced(@NotNull Collection<File> deletedOrReplaced) {
        if (deletedOrReplaced == null) {
            RefreshVFsSynchronously.$$$reportNull$$$0(2);
        }
        HashSet filesToRefresh = ContainerUtil.newHashSet();
        for (File file2 : deletedOrReplaced) {
            File parent = file2.getParentFile();
            VirtualFile vf = RefreshVFsSynchronously.findFirstValidVirtualParent(parent);
            if (vf == null) continue;
            filesToRefresh.add(vf);
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])((VirtualFile[])ArrayUtil.toObjectArray((Collection)filesToRefresh, VirtualFile.class)));
    }

    @Nullable
    private static VirtualFile findFirstValidVirtualParent(@Nullable File file2) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile vf = null;
        while (!(file2 == null || vf != null && vf.isValid())) {
            vf = lfs.findFileByIoFile(file2);
            file2 = file2.getParentFile();
        }
        return vf == null || !vf.isValid() ? null : vf;
    }

    public static void updateChangesForRollback(List<Change> changes2) {
        RefreshVFsSynchronously.updateChangesImpl(changes2, RollbackChangeWrapper.ourInstance);
    }

    public static void updateChanges(Collection<Change> changes2) {
        RefreshVFsSynchronously.updateChangesImpl(changes2, DirectChangeWrapper.ourInstance);
    }

    private static void updateChangesImpl(Collection<Change> changes2, ChangeWrapper wrapper2) {
        HashSet deletedOrReplaced = ContainerUtil.newHashSet();
        HashSet toRefresh = ContainerUtil.newHashSet();
        for (Change change : changes2) {
            if (!wrapper2.beforeNull(change) && (wrapper2.movedOrRenamedOrReplaced(change) || wrapper2.afterNull(change))) {
                deletedOrReplaced.add(wrapper2.getBeforeFile(change));
            } else if (!wrapper2.beforeNull(change)) {
                toRefresh.add(wrapper2.getBeforeFile(change));
            }
            if (wrapper2.afterNull(change) || !wrapper2.beforeNull(change) && Comparing.equal((Object)change.getAfterRevision().getFile(), (Object)change.getBeforeRevision().getFile())) continue;
            toRefresh.add(wrapper2.getAfterFile(change));
        }
        RefreshVFsSynchronously.refreshFiles(toRefresh);
        RefreshVFsSynchronously.refreshDeletedOrReplaced(deletedOrReplaced);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedOrReplaced";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/update/RefreshVFsSynchronously";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAllChanged";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshDeletedOrReplaced";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FilesToRefreshCollector
    implements UpdateFilesHelper.Callback {
        private final Collection<File> myToRefresh = new THashSet();
        private final Collection<File> myToRefreshDeletedOrReplaced = new THashSet();

        private FilesToRefreshCollector() {
        }

        @Override
        public void onFile(String filePath, String groupId) {
            File file2 = new File(filePath);
            if ("REMOVED_FROM_REPOSITORY".equals(groupId) || "MERGED_WITH_TREE_CONFLICT".endsWith(groupId)) {
                this.myToRefreshDeletedOrReplaced.add(file2);
            } else {
                this.myToRefresh.add(file2);
            }
        }

        @NotNull
        public Collection<File> getToRefresh() {
            Collection<File> collection = this.myToRefresh;
            if (collection == null) {
                FilesToRefreshCollector.$$$reportNull$$$0(0);
            }
            return collection;
        }

        @NotNull
        public Collection<File> getToRefreshDeletedOrReplaced() {
            Collection<File> collection = this.myToRefreshDeletedOrReplaced;
            if (collection == null) {
                FilesToRefreshCollector.$$$reportNull$$$0(1);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/vcs/update/RefreshVFsSynchronously$FilesToRefreshCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToRefresh";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToRefreshDeletedOrReplaced";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static interface ChangeWrapper {
        public boolean beforeNull(Change var1);

        public boolean afterNull(Change var1);

        @Nullable
        public File getBeforeFile(Change var1);

        @Nullable
        public File getAfterFile(Change var1);

        public boolean movedOrRenamedOrReplaced(Change var1);
    }

    private static class DirectChangeWrapper
    implements ChangeWrapper {
        private static final DirectChangeWrapper ourInstance = new DirectChangeWrapper();

        private DirectChangeWrapper() {
        }

        @Override
        public boolean beforeNull(Change change) {
            return change.getBeforeRevision() == null;
        }

        @Override
        public boolean afterNull(Change change) {
            return change.getAfterRevision() == null;
        }

        @Override
        @Nullable
        public File getBeforeFile(Change change) {
            return this.beforeNull(change) ? null : change.getBeforeRevision().getFile().getIOFile();
        }

        @Override
        @Nullable
        public File getAfterFile(Change change) {
            return this.afterNull(change) ? null : change.getAfterRevision().getFile().getIOFile();
        }

        @Override
        public boolean movedOrRenamedOrReplaced(Change change) {
            return change.isMoved() || change.isRenamed() || change.isIsReplaced();
        }
    }

    private static class RollbackChangeWrapper
    implements ChangeWrapper {
        private static final RollbackChangeWrapper ourInstance = new RollbackChangeWrapper();

        private RollbackChangeWrapper() {
        }

        @Override
        public boolean beforeNull(Change change) {
            return change.getAfterRevision() == null;
        }

        @Override
        public boolean afterNull(Change change) {
            return change.getBeforeRevision() == null;
        }

        @Override
        public File getBeforeFile(Change change) {
            return this.beforeNull(change) ? null : change.getAfterRevision().getFile().getIOFile();
        }

        @Override
        public File getAfterFile(Change change) {
            return this.afterNull(change) ? null : change.getBeforeRevision().getFile().getIOFile();
        }

        @Override
        public boolean movedOrRenamedOrReplaced(Change change) {
            return change.isMoved() || change.isRenamed() || change.isIsReplaced();
        }
    }
}

