/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.colors;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorPalette;
import com.intellij.openapi.editor.colors.EditorColorPaletteFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.openapi.options.colors.pages.GeneralColorsPage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorPaletteFactoryImpl
extends EditorColorPaletteFactory {
    public EditorColorPalette getPalette(@NotNull EditorColorsScheme scheme2, @Nullable Language language) {
        if (scheme2 == null) {
            EditorColorPaletteFactoryImpl.$$$reportNull$$$0(0);
        }
        return new ColorPagesPalette(scheme2, language);
    }

    @Contract(value="false, _ -> true", pure=true)
    private static boolean pageIsGoodForAnyLanguage(boolean filterOutRainbowNonConflictingAttrKeys, @NotNull ColorSettingsPage page) {
        if (page == null) {
            EditorColorPaletteFactoryImpl.$$$reportNull$$$0(1);
        }
        return !filterOutRainbowNonConflictingAttrKeys || page instanceof GeneralColorsPage || page instanceof RainbowColorSettingsPage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "page";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/options/colors/EditorColorPaletteFactoryImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPalette";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "pageIsGoodForAnyLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ColorPagesPalette
    extends EditorColorPalette {
        @Nullable
        private final Language myLanguage;

        ColorPagesPalette(@NotNull EditorColorsScheme colorsScheme, @Nullable Language language) {
            if (colorsScheme == null) {
                ColorPagesPalette.$$$reportNull$$$0(0);
            }
            super(colorsScheme);
            this.myLanguage = language;
        }

        protected Collection<TextAttributesKey> getTextAttributeKeys(boolean filterOutRainbowNonConflictingAttrKeys) {
            HashSet<TextAttributesKey> textAttributesKeys = new HashSet<TextAttributesKey>();
            for (ColorSettingsPage page : ColorSettingsPages.getInstance().getRegisteredPages()) {
                Map map;
                Language pageLanguage = ColorPagesPalette.guessPageLanguage(page);
                if ((this.myLanguage != null || pageLanguage != null) && (this.myLanguage == null || !this.myLanguage.is(pageLanguage) && (!this.myLanguage.is(Language.ANY) || !EditorColorPaletteFactoryImpl.pageIsGoodForAnyLanguage(filterOutRainbowNonConflictingAttrKeys, page)))) continue;
                for (AttributesDescriptor descriptor : page.getAttributeDescriptors()) {
                    TextAttributesKey textAttributesKey = descriptor.getKey();
                    if (filterOutRainbowNonConflictingAttrKeys && (textAttributesKey == DefaultLanguageHighlighterColors.LOCAL_VARIABLE || textAttributesKey == DefaultLanguageHighlighterColors.PARAMETER) || filterOutRainbowNonConflictingAttrKeys && pageLanguage != null && (!(page instanceof RainbowColorSettingsPage) || ((RainbowColorSettingsPage)page).isRainbowType(textAttributesKey))) continue;
                    textAttributesKeys.add(textAttributesKey);
                }
                if (!(page instanceof GeneralColorsPage) || (map = page.getAdditionalHighlightingTagToDescriptorMap()) == null) continue;
                textAttributesKeys.addAll(map.values());
            }
            return textAttributesKeys;
        }

        @Nullable
        private static Language guessPageLanguage(@NotNull ColorSettingsPage page) {
            if (page == null) {
                ColorPagesPalette.$$$reportNull$$$0(1);
            }
            for (Language language : Language.getRegisteredLanguages()) {
                if ((!(page instanceof RainbowColorSettingsPage) || !language.is(((RainbowColorSettingsPage)page).getLanguage())) && !page.getDisplayName().equals(language.getDisplayName())) continue;
                return language;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorsScheme";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "page";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/options/colors/EditorColorPaletteFactoryImpl$ColorPagesPalette";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "guessPageLanguage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

