/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.actions.BaseNavigateToSourceAction;
import com.intellij.ide.actions.ExternalJavaDocAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.awt.image.renderable.RenderableImageProducer;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

public class DocumentationComponent
extends JPanel
implements Disposable,
DataProvider {
    private static final Logger LOG = Logger.getInstance(DocumentationComponent.class);
    private static final String DOCUMENTATION_TOPIC_ID = "reference.toolWindows.Documentation";
    private static final Color DOCUMENTATION_COLOR = new JBColor(new Color(0xF7F7F7), new Color(4606026));
    private static final JBColor BORDER_COLOR = new JBColor(new Color(0xADADAD), new Color(0x616366));
    public static final ColorKey COLOR_KEY = ColorKey.createColorKey((String)"DOCUMENTATION_COLOR", (Color)DOCUMENTATION_COLOR);
    public static final Color SECTION_COLOR = Gray.get((int)144);
    private static final Highlighter.HighlightPainter LINK_HIGHLIGHTER = new LinkHighlighter();
    private static final int PREFERRED_HEIGHT_MAX_EM = 10;
    private static final JBDimension MAX_DEFAULT = new JBDimension(650, 500);
    private static final JBDimension MIN_DEFAULT = new JBDimension(300, 20);
    private final ExternalDocAction myExternalDocAction;
    private DocumentationManager myManager;
    private SmartPsiElementPointer myElement;
    private long myModificationCount;
    public static final String QUICK_DOC_FONT_SIZE_PROPERTY = "quick.doc.font.size";
    private final Stack<Context> myBackStack = new Stack();
    private final Stack<Context> myForwardStack = new Stack();
    private final ActionToolbar myToolBar;
    private volatile boolean myIsEmpty;
    private boolean mySizeTrackerRegistered;
    private JSlider myFontSizeSlider;
    private final JComponent mySettingsPanel;
    private boolean myIgnoreFontSizeSliderChange;
    private String myExternalUrl;
    private DocumentationProvider myProvider;
    private final MyDictionary<String, Image> myImageProvider = new MyDictionary<String, Image>(){

        @Override
        public Image get(Object key) {
            return DocumentationComponent.this.getImageByKeyImpl(key);
        }
    };
    private Runnable myToolwindowCallback;
    private final ActionButton myCorner;
    private final MyScrollPane myScrollPane;
    private final JEditorPane myEditorPane;
    private String myText;
    private final JComponent myControlPanel;
    private boolean myControlPanelVisible;
    private int myHighlightedLink = -1;
    private Object myHighlightingTag;
    private AbstractPopup myHint;
    private final Map<KeyStroke, ActionListener> myKeyboardActions = new HashMap<KeyStroke, ActionListener>();

    @NotNull
    public static DocumentationComponent createAndFetch(@NotNull Project project, @NotNull PsiElement element, @NotNull Disposable disposable) {
        if (project == null) {
            DocumentationComponent.$$$reportNull$$$0(0);
        }
        if (element == null) {
            DocumentationComponent.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            DocumentationComponent.$$$reportNull$$$0(2);
        }
        DocumentationManager manager = DocumentationManager.getInstance(project);
        DocumentationComponent component = new DocumentationComponent(manager);
        Disposer.register((Disposable)disposable, (Disposable)component);
        manager.fetchDocInfo(element, component);
        DocumentationComponent documentationComponent = component;
        if (documentationComponent == null) {
            DocumentationComponent.$$$reportNull$$$0(3);
        }
        return documentationComponent;
    }

    public DocumentationComponent(final DocumentationManager manager) {
        this.myManager = manager;
        this.myIsEmpty = true;
        this.myEditorPane = new JEditorPane("text/html", ""){
            Point initialClick;
            {
                this.enableEvents(8L);
            }

            @Override
            protected void processKeyEvent(KeyEvent e) {
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                ActionListener listener2 = (ActionListener)DocumentationComponent.this.myKeyboardActions.get(keyStroke);
                if (listener2 != null) {
                    listener2.actionPerformed(new ActionEvent(DocumentationComponent.this, 0, ""));
                    e.consume();
                    return;
                }
                super.processKeyEvent(e);
            }

            @Override
            protected void processMouseEvent(MouseEvent e) {
                if (e.getID() == 501 && DocumentationComponent.this.myHint != null) {
                    int y;
                    int x;
                    this.initialClick = null;
                    StyledDocument document = (StyledDocument)this.getDocument();
                    if (!(this.hasTextAt(document, x = e.getX(), y = e.getY()) || this.hasTextAt(document, x + 3, y) || this.hasTextAt(document, x - 3, y) || this.hasTextAt(document, x, y + 3) || this.hasTextAt(document, x, y - 3))) {
                        this.initialClick = e.getPoint();
                    }
                }
                super.processMouseEvent(e);
            }

            private boolean hasTextAt(StyledDocument document, int x, int y) {
                Element element = document.getCharacterElement(this.viewToModel(new Point(x, y)));
                try {
                    String text = document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                    if (StringUtil.isEmpty((String)text.trim())) {
                        return false;
                    }
                }
                catch (BadLocationException ignored) {
                    return false;
                }
                return true;
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent e) {
                if (e.getID() == 506 && DocumentationComponent.this.myHint != null && this.initialClick != null) {
                    Point location = DocumentationComponent.this.myHint.getLocationOnScreen();
                    DocumentationComponent.this.myHint.setLocation(new Point(location.x + e.getX() - this.initialClick.x, location.y + e.getY() - this.initialClick.y));
                    e.consume();
                    return;
                }
                super.processMouseMotionEvent(e);
            }

            @Override
            protected void paintComponent(Graphics g) {
                GraphicsUtil.setupAntialiasing((Graphics)g);
                super.paintComponent(g);
            }

            @Override
            public void setDocument(Document doc) {
                super.setDocument(doc);
                doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
                if (doc instanceof StyledDocument) {
                    doc.putProperty("imageCache", DocumentationComponent.this.myImageProvider);
                }
            }
        };
        DataProvider helpDataProvider = dataId -> PlatformDataKeys.HELP_ID.is(dataId) ? DOCUMENTATION_TOPIC_ID : null;
        this.myEditorPane.putClientProperty("DataProvider", helpDataProvider);
        this.myText = "";
        this.myEditorPane.setEditable(false);
        this.myEditorPane.setCaret(new DefaultCaret(){

            @Override
            protected void adjustVisibility(Rectangle r) {
            }
        });
        if (ScreenReader.isActive()) {
            this.myEditorPane.getCaret().setVisible(true);
        }
        this.myEditorPane.setBackground(EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)COLOR_KEY));
        UIUtil.JBHtmlEditorKit editorKit = new UIUtil.JBHtmlEditorKit(true){

            public ViewFactory getViewFactory() {
                return new HTMLEditorKit.HTMLFactory(){

                    @Override
                    public View create(Element elem) {
                        View view;
                        if ("icon".equals(elem.getName())) {
                            ModuleType id;
                            Icon icon;
                            Object src = elem.getAttributes().getAttribute(HTML.Attribute.SRC);
                            Icon icon2 = icon = src != null ? IconLoader.findIcon((String)((String)src), (boolean)false) : null;
                            if (icon == null && (id = ModuleTypeManager.getInstance().findByID((String)src)) != null) {
                                icon = id.getIcon();
                            }
                            if (icon != null) {
                                final Icon viewIcon = icon;
                                return new View(elem){

                                    @Override
                                    public float getPreferredSpan(int axis) {
                                        switch (axis) {
                                            case 0: {
                                                return viewIcon.getIconWidth();
                                            }
                                            case 1: {
                                                return viewIcon.getIconHeight();
                                            }
                                        }
                                        throw new IllegalArgumentException("Invalid axis: " + axis);
                                    }

                                    @Override
                                    public void paint(Graphics g, Shape allocation) {
                                        viewIcon.paintIcon(null, g, allocation.getBounds().x, allocation.getBounds().y - 4);
                                    }

                                    @Override
                                    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
                                        int p0 = this.getStartOffset();
                                        int p1 = this.getEndOffset();
                                        if (pos >= p0 && pos <= p1) {
                                            Rectangle r = a.getBounds();
                                            if (pos == p1) {
                                                r.x += r.width;
                                            }
                                            r.width = 0;
                                            return r;
                                        }
                                        throw new BadLocationException(pos + " not in range " + p0 + "," + p1, pos);
                                    }

                                    @Override
                                    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
                                        Rectangle alloc = (Rectangle)a;
                                        if (x < (float)(alloc.x + alloc.width / 2)) {
                                            bias[0] = Position.Bias.Forward;
                                            return this.getStartOffset();
                                        }
                                        bias[0] = Position.Bias.Backward;
                                        return this.getEndOffset();
                                    }
                                };
                            }
                        }
                        if ((view = super.create(elem)) instanceof ImageView) {
                            return new ImageView(elem){

                                @Override
                                public float getMaximumSpan(int axis) {
                                    return super.getMaximumSpan(axis) / JBUI.sysScale((Component)DocumentationComponent.this.myEditorPane);
                                }

                                @Override
                                public float getMinimumSpan(int axis) {
                                    return super.getMinimumSpan(axis) / JBUI.sysScale((Component)DocumentationComponent.this.myEditorPane);
                                }

                                @Override
                                public float getPreferredSpan(int axis) {
                                    return super.getPreferredSpan(axis) / JBUI.sysScale((Component)DocumentationComponent.this.myEditorPane);
                                }

                                @Override
                                public void paint(Graphics g, Shape a) {
                                    Rectangle bounds2 = a.getBounds();
                                    int width = (int)super.getPreferredSpan(0);
                                    int height = (int)super.getPreferredSpan(1);
                                    BufferedImage image = new BufferedImage(width, height, 2);
                                    Graphics2D graphics = image.createGraphics();
                                    super.paint(graphics, new Rectangle(image.getWidth(), image.getHeight()));
                                    UIUtil.drawImage((Graphics)g, (Image)ImageUtil.ensureHiDPI((Image)image, (JBUI.ScaleContext)JBUI.ScaleContext.create((Component)DocumentationComponent.this.myEditorPane)), (int)bounds2.x, (int)bounds2.y, null);
                                }
                            };
                        }
                        return view;
                    }
                };
            }
        };
        DocumentationComponent.prepareCSS((HTMLEditorKit)editorKit);
        this.myEditorPane.setEditorKit((EditorKit)editorKit);
        this.myEditorPane.setBorder((Border)JBUI.Borders.empty());
        this.myScrollPane = new MyScrollPane();
        this.myScrollPane.putClientProperty("DataProvider", helpDataProvider);
        final FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component previouslyFocused = WindowManagerEx.getInstanceEx().getFocusedComponent(manager.getProject(DocumentationComponent.this.getElement()));
                if (previouslyFocused != DocumentationComponent.this.myEditorPane && DocumentationComponent.this.myHint != null && !DocumentationComponent.this.myHint.isDisposed()) {
                    DocumentationComponent.this.myHint.cancel();
                }
            }
        };
        this.myEditorPane.addFocusListener(focusAdapter);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                DocumentationComponent.this.myEditorPane.removeFocusListener(focusAdapter);
            }
        });
        this.setLayout(new BorderLayout());
        this.mySettingsPanel = this.createSettingsPanel();
        this.setOpaque(true);
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        DefaultActionGroup actions = new DefaultActionGroup();
        BackAction back = new BackAction();
        ForwardAction forward = new ForwardAction();
        EditDocumentationSourceAction edit = new EditDocumentationSourceAction();
        this.myExternalDocAction = new ExternalDocAction();
        actions.add((AnAction)back);
        actions.add((AnAction)forward);
        actions.add((AnAction)edit);
        try {
            String backKey = ScreenReader.isActive() ? "alt LEFT" : "LEFT";
            CustomShortcutSet backShortcutSet = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)backKey), KeymapUtil.parseMouseShortcut((String)"button4")});
            String forwardKey = ScreenReader.isActive() ? "alt RIGHT" : "RIGHT";
            CustomShortcutSet forwardShortcutSet = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)forwardKey), KeymapUtil.parseMouseShortcut((String)"button5")});
            back.registerCustomShortcutSet((ShortcutSet)backShortcutSet, this);
            forward.registerCustomShortcutSet((ShortcutSet)forwardShortcutSet, this);
            back.registerCustomShortcutSet((ShortcutSet)backShortcutSet, this.myEditorPane);
            forward.registerCustomShortcutSet((ShortcutSet)forwardShortcutSet, this.myEditorPane);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        this.myExternalDocAction.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"UP"}), this);
        this.myExternalDocAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExternalJavaDoc").getShortcutSet(), this.myEditorPane);
        edit.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this);
        final ActionPopupMenu contextMenu = ((ActionManagerImpl)ActionManager.getInstance()).createActionPopupMenu("JavadocToolbar", (ActionGroup)actions, new MenuItemPresentationFactory(true));
        PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                contextMenu.getComponent().show(comp, x, y);
            }
        };
        this.myEditorPane.addMouseListener((MouseListener)popupHandler);
        Disposer.register((Disposable)this, () -> this.myEditorPane.removeMouseListener((MouseListener)popupHandler));
        new NextLinkAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"TAB"}), this);
        new PreviousLinkAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}), this);
        new ActivateLinkAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER"}), this);
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        toolbarActions.add((AnAction)actions);
        toolbarActions.addAction((AnAction)new ShowAsToolwindowAction()).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new MyShowSettingsAction(true)).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new ShowToolbarAction()).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new RestoreDefaultSizeAction()).setAsSecondary(true);
        this.myToolBar = new ActionToolbarImpl("JavadocToolbar", (ActionGroup)toolbarActions, true, DataManager.getInstance(), ActionManagerEx.getInstanceEx(), KeymapManagerEx.getInstanceEx()){
            Point initialClick;

            @Override
            protected void processMouseEvent(MouseEvent e) {
                if (e.getID() == 501 && DocumentationComponent.this.myHint != null) {
                    this.initialClick = e.getPoint();
                }
                super.processMouseEvent(e);
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent e) {
                if (e.getID() == 506 && DocumentationComponent.this.myHint != null && this.initialClick != null) {
                    Point location = DocumentationComponent.this.myHint.getLocationOnScreen();
                    DocumentationComponent.this.myHint.setLocation(new Point(location.x + e.getX() - this.initialClick.x, location.y + e.getY() - this.initialClick.y));
                    e.consume();
                    return;
                }
                super.processMouseMotionEvent(e);
            }
        };
        JBLayeredPane layeredPane = new JBLayeredPane(){

            public void doLayout() {
                Rectangle r = this.getBounds();
                for (Component component : this.getComponents()) {
                    if (component instanceof JScrollPane) {
                        component.setBounds(0, 0, r.width, r.height);
                        continue;
                    }
                    Dimension d = component.getPreferredSize();
                    component.setBounds(r.width - d.width - 2, r.height - d.height - 3, d.width, d.height);
                }
            }

            public Dimension getPreferredSize() {
                Dimension size = DocumentationComponent.this.myScrollPane.getPreferredSize();
                if (DocumentationComponent.this.myHint == null && DocumentationComponent.this.myManager != null && ((DocumentationComponent)DocumentationComponent.this).myManager.myToolWindow == null) {
                    int em = DocumentationComponent.this.myEditorPane.getFont().getSize();
                    int prefHeightMax = 10 * em;
                    return new Dimension(size.width, Math.min(prefHeightMax, size.height + (DocumentationComponent.this.needsToolbar() ? ((DocumentationComponent)DocumentationComponent.this).myControlPanel.getPreferredSize().height : 0)));
                }
                return size;
            }
        };
        layeredPane.add((Component)((Object)this.myScrollPane));
        layeredPane.setLayer((Component)((Object)this.myScrollPane), 0);
        MyGearActionGroup gearActions = new MyGearActionGroup(new AnAction[0]);
        gearActions.add(new ShowAsToolwindowAction());
        gearActions.add(new MyShowSettingsAction(false));
        gearActions.add((AnAction)new ShowToolbarAction());
        gearActions.add(new RestoreDefaultSizeAction());
        gearActions.addSeparator();
        gearActions.addAll((ActionGroup)actions);
        Presentation presentation = new Presentation();
        presentation.setIcon(AllIcons.General.GearPlain);
        this.myCorner = new ActionButton((AnAction)gearActions, presentation, "unknown", new Dimension(20, 20)){

            @Override
            public void paintComponent(Graphics g) {
                this.paintButtonLook(g);
            }
        };
        this.myCorner.setNoIconsInPopup(true);
        layeredPane.add(this.myCorner);
        layeredPane.setLayer(this.myCorner, JLayeredPane.POPUP_LAYER);
        this.add((Component)layeredPane, "Center");
        this.myControlPanel = this.myToolBar.getComponent();
        this.myControlPanel.setBorder(IdeBorderFactory.createBorder((int)8));
        this.myControlPanelVisible = false;
        final HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                HyperlinkEvent.EventType type = e.getEventType();
                if (type == HyperlinkEvent.EventType.ACTIVATED) {
                    manager.navigateByLink(DocumentationComponent.this, e.getDescription());
                }
            }
        };
        this.myEditorPane.addHyperlinkListener(hyperlinkListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                DocumentationComponent.this.myEditorPane.removeHyperlinkListener(hyperlinkListener);
            }
        });
        if (this.myHint != null) {
            Disposer.register((Disposable)this.myHint, (Disposable)this);
        } else if (this.myManager.myToolWindow != null) {
            Disposer.register((Disposable)this.myManager.myToolWindow.getContentManager(), (Disposable)this);
        }
        this.registerActions();
        this.updateControlState();
    }

    public AnAction[] getActions() {
        return (AnAction[])this.myToolBar.getActions().stream().filter(action -> !(action instanceof Separator)).toArray(AnAction[]::new);
    }

    public AnAction getFontSizeAction() {
        return new MyShowSettingsAction(false);
    }

    public void removeCornerMenu() {
        this.myCorner.setVisible(false);
    }

    public void setToolwindowCallback(Runnable callback2) {
        this.myToolwindowCallback = callback2;
    }

    public void showExternalDoc() {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
        this.myExternalDocAction.actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext));
    }

    @Override
    public boolean requestFocusInWindow() {
        if (ScreenReader.isActive()) {
            return this.myEditorPane.requestFocusInWindow();
        }
        return this.myScrollPane.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
            if (ScreenReader.isActive()) {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditorPane, true);
            } else {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myScrollPane), true);
            }
        });
    }

    private static void prepareCSS(HTMLEditorKit editorKit) {
        Color borderColor = ColorUtil.mix((Color)DOCUMENTATION_COLOR, (Color)BORDER_COLOR, (double)0.5);
        String editorFontName = StringUtil.escapeQuotes((String)EditorColorsManager.getInstance().getGlobalScheme().getEditorFontName());
        editorKit.getStyleSheet().addRule("code {font-family:\"" + editorFontName + "\"}");
        editorKit.getStyleSheet().addRule("pre {font-family:\"" + editorFontName + "\"}");
        editorKit.getStyleSheet().addRule(".pre {font-family:\"" + editorFontName + "\"}");
        editorKit.getStyleSheet().addRule("html { padding-bottom: 5px; }");
        editorKit.getStyleSheet().addRule("a { color: #" + ColorUtil.toHex((Color)DocumentationComponent.getLinkColor()) + "; text-decoration: none;}");
        editorKit.getStyleSheet().addRule(".definition { padding: 3px 17px 1px 7px; border-bottom: thin solid #" + ColorUtil.toHex((Color)borderColor) + "; }");
        editorKit.getStyleSheet().addRule(".content { padding: 5px 16px 0 7px; max-width: 100% }");
        editorKit.getStyleSheet().addRule(".bottom { padding: 3px 16px 0 7px; }");
        editorKit.getStyleSheet().addRule(".bottom-no-content { padding: 5px 16px 0 7px; }");
        editorKit.getStyleSheet().addRule("p { padding: 1px 0 2px 0; }");
        editorKit.getStyleSheet().addRule("ul { padding: 5px 16px 0 7px; }");
        editorKit.getStyleSheet().addRule("li { padding: 1px 0 2px 0; }");
        editorKit.getStyleSheet().addRule(".grayed { color: #909090; display: inline;}");
        editorKit.getStyleSheet().addRule(".centered { text-align: center}");
        editorKit.getStyleSheet().addRule(".sections { padding: 0 16px 0 7px; border-spacing: 0; }");
        editorKit.getStyleSheet().addRule("tr { margin: 0 0 0 0; padding: 0 0 0 0; }");
        editorKit.getStyleSheet().addRule("td { margin: 2px 0 3.5px 0; padding: 0 0 0 0; }");
        editorKit.getStyleSheet().addRule(".section { color: " + ColorUtil.toHtmlColor((Color)SECTION_COLOR) + "; padding-right: 4px}");
    }

    private static Color getLinkColor() {
        Color color = UIManager.getColor("link.foreground");
        return color != null ? color : IdeTooltipManager.getInstance().getLinkForeground(false);
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DocumentationComponent.$$$reportNull$$$0(4);
        }
        if (DocumentationManager.SELECTED_QUICK_DOC_TEXT.getName().equals(dataId)) {
            String selectedText = this.myEditorPane.getSelectedText();
            return selectedText == null ? null : selectedText.replace('\u00a0', ' ');
        }
        return null;
    }

    private JComponent createSettingsPanel() {
        JPanel result2 = new JPanel(new FlowLayout(2, 3, 0));
        result2.add(new JLabel(ApplicationBundle.message((String)"label.font.size", (Object[])new Object[0])));
        this.myFontSizeSlider = new JSlider(0, 0, FontSize.values().length - 1, 3);
        this.myFontSizeSlider.setMinorTickSpacing(1);
        this.myFontSizeSlider.setPaintTicks(true);
        this.myFontSizeSlider.setPaintTrack(true);
        this.myFontSizeSlider.setSnapToTicks(true);
        UIUtil.setSliderIsFilled((JSlider)this.myFontSizeSlider, (boolean)true);
        result2.add(this.myFontSizeSlider);
        result2.setBorder(BorderFactory.createLineBorder(JBColor.border(), 1));
        this.myFontSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DocumentationComponent.this.myIgnoreFontSizeSliderChange) {
                    return;
                }
                DocumentationComponent.this.setQuickDocFontSize(FontSize.values()[DocumentationComponent.this.myFontSizeSlider.getValue()]);
                DocumentationComponent.this.applyFontProps();
            }
        });
        String tooltipText = ApplicationBundle.message((String)"quickdoc.tooltip.font.size.by.wheel", (Object[])new Object[0]);
        result2.setToolTipText(tooltipText);
        this.myFontSizeSlider.setToolTipText(tooltipText);
        result2.setVisible(false);
        result2.setOpaque(true);
        this.myFontSizeSlider.setOpaque(true);
        return result2;
    }

    @NotNull
    public static FontSize getQuickDocFontSize() {
        String strValue = PropertiesComponent.getInstance().getValue(QUICK_DOC_FONT_SIZE_PROPERTY);
        if (strValue != null) {
            FontSize fontSize;
            try {
                fontSize = FontSize.valueOf((String)strValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (fontSize == null) {
                DocumentationComponent.$$$reportNull$$$0(5);
            }
            return fontSize;
        }
        FontSize fontSize = FontSize.SMALL;
        if (fontSize == null) {
            DocumentationComponent.$$$reportNull$$$0(6);
        }
        return fontSize;
    }

    public void setQuickDocFontSize(@NotNull FontSize fontSize) {
        if (fontSize == null) {
            DocumentationComponent.$$$reportNull$$$0(7);
        }
        PropertiesComponent.getInstance().setValue(QUICK_DOC_FONT_SIZE_PROPERTY, fontSize.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFontSizeSliderSize(FontSize fontSize) {
        this.myIgnoreFontSizeSliderChange = true;
        try {
            FontSize[] sizes = FontSize.values();
            for (int i = 0; i < sizes.length; ++i) {
                if (fontSize != sizes[i]) continue;
                this.myFontSizeSlider.setValue(i);
                break;
            }
        }
        finally {
            this.myIgnoreFontSizeSliderChange = false;
        }
    }

    public boolean isEmpty() {
        return this.myIsEmpty;
    }

    public void startWait() {
        this.myIsEmpty = true;
    }

    private void setControlPanelVisible() {
        if (this.myControlPanelVisible) {
            return;
        }
        this.add((Component)this.myControlPanel, "North");
        this.myControlPanelVisible = true;
    }

    public void setHint(JBPopup hint) {
        this.myHint = (AbstractPopup)hint;
    }

    public JBPopup getHint() {
        return this.myHint;
    }

    public JComponent getComponent() {
        return this.myEditorPane;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement != null ? this.myElement.getElement() : null;
    }

    private void setElement(SmartPsiElementPointer element) {
        this.myElement = element;
        this.myModificationCount = this.getCurrentModificationCount();
    }

    public boolean isUpToDate() {
        return this.getElement() != null && this.myModificationCount == this.getCurrentModificationCount();
    }

    private long getCurrentModificationCount() {
        return this.myElement != null ? PsiModificationTracker.SERVICE.getInstance((Project)this.myElement.getProject()).getModificationCount() : -1L;
    }

    public void setText(@NotNull String text, @Nullable PsiElement element, @Nullable DocumentationProvider provider) {
        if (text == null) {
            DocumentationComponent.$$$reportNull$$$0(8);
        }
        this.setData(element, text, null, null, provider);
    }

    public void replaceText(@NotNull String text, @Nullable PsiElement element) {
        PsiElement current;
        if (text == null) {
            DocumentationComponent.$$$reportNull$$$0(9);
        }
        if ((current = this.getElement()) == null || !current.getManager().areElementsEquivalent(current, element)) {
            return;
        }
        this.restoreContext(this.saveContext().withText(text));
    }

    public void clearHistory() {
        this.myForwardStack.clear();
        this.myBackStack.clear();
    }

    private void pushHistory() {
        if (this.myElement != null) {
            this.myBackStack.push(this.saveContext());
            this.myForwardStack.clear();
        }
    }

    public void setData(@Nullable PsiElement element, @NotNull String text, @Nullable String effectiveExternalUrl, @Nullable String ref, @Nullable DocumentationProvider provider) {
        if (text == null) {
            DocumentationComponent.$$$reportNull$$$0(10);
        }
        this.pushHistory();
        this.myExternalUrl = effectiveExternalUrl;
        this.myProvider = provider;
        SmartPsiElementPointer pointer = null;
        if (element != null && element.isValid()) {
            pointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        }
        this.setDataInternal(pointer, text, new Rectangle(0, 0), 0, ref);
    }

    private void setDataInternal(@Nullable SmartPsiElementPointer element, @NotNull String text, @NotNull Rectangle viewRect, int caretPosition, @Nullable String ref) {
        if (text == null) {
            DocumentationComponent.$$$reportNull$$$0(11);
        }
        if (viewRect == null) {
            DocumentationComponent.$$$reportNull$$$0(12);
        }
        this.myIsEmpty = false;
        if (this.myManager == null) {
            return;
        }
        this.updateControlState();
        this.setElement(element);
        this.highlightLink(-1);
        DocumentationComponent.setTextFast(this.myEditorPane, this.decorate(text));
        this.applyFontProps();
        this.showHint();
        this.myText = text;
        this.myEditorPane.setCaretPosition(caretPosition);
        this.myEditorPane.scrollRectToVisible(viewRect);
        if (ref != null) {
            this.myEditorPane.scrollToReference(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTextFast(@NotNull JEditorPane editorPane, @NotNull String text) {
        if (editorPane == null) {
            DocumentationComponent.$$$reportNull$$$0(13);
        }
        if (text == null) {
            DocumentationComponent.$$$reportNull$$$0(14);
        }
        EditorKit kit = editorPane.getEditorKit();
        Document document = editorPane.getDocument();
        editorPane.setDocument(kit.createDefaultDocument());
        try {
            document.remove(0, document.getLength());
            kit.read(new StringReader(text), document, 0);
        }
        catch (IOException | BadLocationException exception) {
        }
        finally {
            editorPane.setDocument(document);
        }
    }

    private void showHint() {
        if (this.myHint == null) {
            return;
        }
        this.setHintSize();
        Component focusOwner = IdeFocusManager.getInstance((Project)this.myManager.myProject).getFocusOwner();
        DataContext dataContext = DataManager.getInstance().getDataContext(focusOwner);
        PopupPositionManager.positionPopupInBestPosition(this.myHint, this.myManager.getEditor(), dataContext, PopupPositionManager.Position.RIGHT, PopupPositionManager.Position.LEFT);
        Window window = this.myHint.getPopupWindow();
        if (window != null) {
            window.setFocusableWindowState(true);
        }
        if (this.myHint.getDimensionServiceKey() == null) {
            this.registerSizeTracker();
        }
    }

    private void setHintSize() {
        Dimension hintSize;
        int maxWidth;
        Component popupAnchor = this.getPopupAnchor();
        int n = maxWidth = popupAnchor != null ? JBUI.scale((int)435) : DocumentationComponent.MAX_DEFAULT.width;
        if (this.myHint.getDimensionServiceKey() == null) {
            Dimension preferredSize = this.myEditorPane.getPreferredSize();
            int width = this.definitionPreferredWidth();
            width = width < 0 ? preferredSize.width : width;
            width = Math.min(maxWidth, Math.max(JBUI.scale((int)300), width));
            this.myEditorPane.setBounds(0, 0, width, DocumentationComponent.MAX_DEFAULT.height);
            this.myEditorPane.setText(this.myEditorPane.getText());
            preferredSize = this.myEditorPane.getPreferredSize();
            int height = preferredSize.height + (this.needsToolbar() ? this.myControlPanel.getPreferredSize().height : 0);
            height = Math.min(DocumentationComponent.MAX_DEFAULT.height, Math.max(DocumentationComponent.MIN_DEFAULT.height, height));
            hintSize = new Dimension(width, height);
        } else {
            hintSize = DimensionService.getInstance().getSize("javadoc.popup.new", this.myManager.myProject);
            if (hintSize == null) {
                hintSize = new Dimension((Dimension)MIN_DEFAULT);
            } else {
                hintSize.width = Math.max(hintSize.width, DocumentationComponent.MIN_DEFAULT.width);
                hintSize.height = Math.max(hintSize.height, DocumentationComponent.MIN_DEFAULT.height);
            }
        }
        this.myHint.setSize(hintSize);
    }

    private Component getPopupAnchor() {
        LookupEx lookup = LookupManager.getActiveLookup(this.myManager.getEditor());
        if (lookup != null && lookup.getCurrentItem() != null && lookup.getComponent().isShowing()) {
            return lookup.getComponent();
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        JBPopup popup2 = PopupUtil.getPopupContainerFor((Component)focusOwner);
        if (popup2 != null && popup2 != this.myHint) {
            return popup2.getContent();
        }
        return null;
    }

    private void registerSizeTracker() {
        AbstractPopup hint = this.myHint;
        if (hint == null || this.mySizeTrackerRegistered) {
            return;
        }
        this.mySizeTrackerRegistered = true;
        hint.addResizeListener(() -> hint.setDimensionServiceKey("javadoc.popup.new"), this);
    }

    private int definitionPreferredWidth() {
        TextUI ui = this.myEditorPane.getUI();
        View view = ui.getRootView(this.myEditorPane);
        View definition = DocumentationComponent.findDefinition(view);
        return definition != null ? (int)definition.getPreferredSpan(0) : -1;
    }

    private static View findDefinition(View view) {
        if ("definition".equals(view.getElement().getAttributes().getAttribute(HTML.Attribute.CLASS))) {
            return view;
        }
        for (int i = 0; i < view.getViewCount(); ++i) {
            View definition = DocumentationComponent.findDefinition(view.getView(i));
            if (definition == null) continue;
            return definition;
        }
        return null;
    }

    private String decorate(String text) {
        String links;
        String location;
        text = StringUtil.replaceIgnoreCase((String)text, (String)"</html>", (String)"");
        boolean hasContent = (text = StringUtil.replaceIgnoreCase((String)text, (String)"</body>", (String)"")).contains("<div class='content'>");
        if (!hasContent && !text.contains("<div class='definition'><pre>")) {
            int bodyStart = DocumentationComponent.findContentStart(text);
            text = bodyStart > 0 ? text.substring(0, bodyStart) + "<div class='content'>" + text.substring(bodyStart) + "</div>" : "<div class='content'>" + text + "</div>";
            hasContent = true;
        }
        if ((location = this.getLocationText()) != null) {
            text = text + DocumentationComponent.getBottom(hasContent) + location + "</div>";
        }
        if ((links = DocumentationComponent.getExternalText(this.myManager, this.getElement(), this.myExternalUrl, this.myProvider)) != null) {
            text = text + DocumentationComponent.getBottom(location != null) + links;
        }
        text = DocumentationComponent.addExternalLinksIcon(text);
        return text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static String getExternalText(@NotNull DocumentationManager manager, @Nullable PsiElement element, @Nullable String externalUrl, @Nullable DocumentationProvider provider) {
        if (manager == null) {
            DocumentationComponent.$$$reportNull$$$0(15);
        }
        if (element == null || provider == null) {
            return null;
        }
        PsiElement originalElement = DocumentationManager.getOriginalElement(element);
        if (!DocumentationComponent.shouldShowExternalDocumentationLink(provider, element, originalElement)) {
            return null;
        }
        String title = manager.getTitle(element);
        if (externalUrl == null) {
            List urls = provider.getUrlFor(element, originalElement);
            if (urls == null) return null;
            boolean hasBadUrl = false;
            StringBuilder result2 = new StringBuilder();
            for (String url : urls) {
                String link = DocumentationComponent.getLink(title, url);
                if (link == null) {
                    hasBadUrl = true;
                    break;
                }
                if (result2.length() > 0) {
                    result2.append("<p>");
                }
                result2.append(link);
            }
            if (hasBadUrl) return "<a href='external_doc'>External documentation for `" + title + "`<icon src='AllIcons.Ide.External_link_arrow'></a></div>";
            return result2.toString();
        }
        String link = DocumentationComponent.getLink(title, externalUrl);
        if (link == null) return "<a href='external_doc'>External documentation for `" + title + "`<icon src='AllIcons.Ide.External_link_arrow'></a></div>";
        return link;
    }

    private static String getLink(String title, String url) {
        StringBuilder result2 = new StringBuilder();
        String hostname = DocumentationComponent.getHostname(url);
        if (hostname == null) {
            return null;
        }
        result2.append("<a href='");
        result2.append(url);
        result2.append("'>`");
        result2.append(title).append("` on ").append(hostname);
        result2.append("</a>");
        return result2.toString();
    }

    static boolean shouldShowExternalDocumentationLink(DocumentationProvider provider, PsiElement element, PsiElement originalElement) {
        if (provider instanceof CompositeDocumentationProvider) {
            List providers = ((CompositeDocumentationProvider)provider).getProviders();
            for (DocumentationProvider p : providers) {
                if (!(p instanceof ExternalDocumentationHandler)) continue;
                return ((ExternalDocumentationHandler)p).canHandleExternal(element, originalElement);
            }
        } else if (provider instanceof ExternalDocumentationHandler) {
            return ((ExternalDocumentationHandler)provider).canHandleExternal(element, originalElement);
        }
        return true;
    }

    private static String getHostname(String url) {
        try {
            return new URL(url).toURI().getHost();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return null;
        }
    }

    private static int findContentStart(String text) {
        int index = StringUtil.indexOfIgnoreCase((String)text, (String)"<body>", (int)0);
        if (index >= 0) {
            return index + 6;
        }
        index = StringUtil.indexOfIgnoreCase((String)text, (String)"</head>", (int)0);
        if (index >= 0) {
            return index + 7;
        }
        index = StringUtil.indexOfIgnoreCase((String)text, (String)"</style>", (int)0);
        if (index >= 0) {
            return index + 8;
        }
        index = StringUtil.indexOfIgnoreCase((String)text, (String)"<html>", (int)0);
        if (index >= 0) {
            return index + 6;
        }
        return -1;
    }

    @NotNull
    private static String getBottom(boolean hasContent) {
        String string = "<div class='" + (hasContent ? "bottom" : "bottom-no-content") + "'>";
        if (string == null) {
            DocumentationComponent.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static String addExternalLinksIcon(String text) {
        return text.replaceAll("(<a\\s*href=[\"']http[^>]*>)([^>]*)(</a>)", "$1$2<icon src='AllIcons.Ide.External_link_arrow'>$3");
    }

    private String getLocationText() {
        PsiElement element = this.getElement();
        if (element != null) {
            VirtualFile vfile;
            PsiFile file2 = element.getContainingFile();
            VirtualFile virtualFile = vfile = file2 == null ? null : file2.getVirtualFile();
            if (vfile == null) {
                return null;
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
            Module module = fileIndex.getModuleForFile(vfile);
            if (module != null) {
                if (ModuleManager.getInstance((Project)element.getProject()).getModules().length == 1) {
                    return null;
                }
                return "<icon src='" + ModuleType.get((Module)module).getId() + "'>&nbsp;" + module.getName().replace("<", "&lt;");
            }
            List entries2 = fileIndex.getOrderEntriesForFile(vfile);
            for (OrderEntry order : entries2) {
                if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
                return "<icon src='AllIcons.Nodes.PpLibFolder'>&nbsp;" + order.getPresentableName().replace("<", "&lt;");
            }
        }
        return null;
    }

    private void applyFontProps() {
        Document document = this.myEditorPane.getDocument();
        if (!(document instanceof StyledDocument)) {
            return;
        }
        String fontName = Registry.is((String)"documentation.component.editor.font") ? EditorColorsManager.getInstance().getGlobalScheme().getEditorFontName() : this.myEditorPane.getFont().getFontName();
        this.myEditorPane.setFont(UIUtil.getFontWithFallback((String)fontName, (int)0, (int)JBUI.scale((int)DocumentationComponent.getQuickDocFontSize().getSize())));
    }

    @Nullable
    private Image getImageByKeyImpl(Object key) {
        if (this.myManager == null || key == null) {
            return null;
        }
        PsiElement element = this.getElement();
        if (element == null) {
            return null;
        }
        URL url = (URL)key;
        Image inMemory = this.myManager.getElementImage(element, url.toExternalForm());
        if (inMemory != null) {
            return inMemory;
        }
        Url parsedUrl = Urls.parseEncoded(url.toExternalForm());
        BuiltInServerManager builtInServerManager = BuiltInServerManager.getInstance();
        if (parsedUrl != null && builtInServerManager.isOnBuiltInWebServer(parsedUrl)) {
            try {
                url = new URL(builtInServerManager.addAuthToken(parsedUrl).toExternalForm());
            }
            catch (MalformedURLException e) {
                LOG.warn((Throwable)e);
            }
        }
        final URL imageUrl = url;
        return Toolkit.getDefaultToolkit().createImage(new RenderableImageProducer(new RenderableImage(){
            private Image myImage;
            private boolean myImageLoaded;

            @Override
            public Vector<RenderableImage> getSources() {
                return null;
            }

            @Override
            public Object getProperty(String name) {
                return null;
            }

            @Override
            public String[] getPropertyNames() {
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }

            @Override
            public boolean isDynamic() {
                return false;
            }

            @Override
            public float getWidth() {
                return this.getImage().getWidth(null);
            }

            @Override
            public float getHeight() {
                return this.getImage().getHeight(null);
            }

            @Override
            public float getMinX() {
                return 0.0f;
            }

            @Override
            public float getMinY() {
                return 0.0f;
            }

            @Override
            public RenderedImage createScaledRendering(int w, int h, RenderingHints hints) {
                return this.createDefaultRendering();
            }

            @Override
            public RenderedImage createDefaultRendering() {
                return (RenderedImage)((Object)this.getImage());
            }

            @Override
            public RenderedImage createRendering(RenderContext renderContext) {
                return this.createDefaultRendering();
            }

            private Image getImage() {
                if (!this.myImageLoaded) {
                    Image image = ImageLoader.loadFromUrl((URL)imageUrl);
                    this.myImage = ImageUtil.toBufferedImage((Image)(image != null ? image : ((ImageIcon)UIManager.getLookAndFeelDefaults().get("html.missingImage")).getImage()));
                    this.myImageLoaded = true;
                }
                return this.myImage;
            }
        }, null));
    }

    private void goBack() {
        if (this.myBackStack.isEmpty()) {
            return;
        }
        Context context = this.myBackStack.pop();
        this.myForwardStack.push(this.saveContext());
        this.restoreContext(context);
    }

    private void goForward() {
        if (this.myForwardStack.isEmpty()) {
            return;
        }
        Context context = this.myForwardStack.pop();
        this.myBackStack.push(this.saveContext());
        this.restoreContext(context);
    }

    private Context saveContext() {
        Rectangle rect = this.myScrollPane.getViewport().getViewRect();
        return new Context(this.myElement, this.myText, this.myExternalUrl, this.myProvider, rect, this.myEditorPane.getCaretPosition(), this.myHighlightedLink);
    }

    private void restoreContext(@NotNull Context context) {
        if (context == null) {
            DocumentationComponent.$$$reportNull$$$0(17);
        }
        this.myExternalUrl = context.externalUrl;
        this.myProvider = context.provider;
        this.setDataInternal(context.element, context.text, context.viewRect, context.caretPosition, null);
        this.highlightLink(context.highlightedLink);
    }

    private void updateControlState() {
        if (this.needsToolbar()) {
            this.myToolBar.updateActionsImmediately();
            this.setControlPanelVisible();
            this.removeCornerMenu();
        } else {
            this.myControlPanelVisible = false;
            this.remove(this.myControlPanel);
            if (this.myManager.myToolWindow != null) {
                return;
            }
            this.myCorner.setVisible(true);
        }
    }

    private boolean needsToolbar() {
        return this.myManager.myToolWindow == null && Registry.is((String)"documentation.show.toolbar");
    }

    private static boolean isToolbar(@NotNull AnActionEvent e) {
        if (e == null) {
            DocumentationComponent.$$$reportNull$$$0(18);
        }
        return "JavadocToolbar".equals(e.getPlace());
    }

    private boolean hasExternalDoc() {
        boolean enabled = false;
        if (this.myElement != null && this.myProvider != null) {
            PsiElement element = this.myElement.getElement();
            PsiElement originalElement = DocumentationManager.getOriginalElement(element);
            enabled = element != null && CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)this.myProvider, (PsiElement)element, (PsiElement)originalElement);
        }
        return enabled;
    }

    private void registerActions() {
        if (!ScreenReader.isActive()) {
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(38, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value = scrollBar.getValue() - scrollBar.getUnitIncrement(-1);
                    value = Math.max(value, 0);
                    scrollBar.setValue(value);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(40, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value = scrollBar.getValue() + scrollBar.getUnitIncrement(1);
                    value = Math.min(value, scrollBar.getMaximum());
                    scrollBar.setValue(value);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(37, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    int value = scrollBar.getValue() - scrollBar.getUnitIncrement(-1);
                    value = Math.max(value, 0);
                    scrollBar.setValue(value);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(39, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    int value = scrollBar.getValue() + scrollBar.getUnitIncrement(1);
                    value = Math.min(value, scrollBar.getMaximum());
                    scrollBar.setValue(value);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(33, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value = scrollBar.getValue() - scrollBar.getBlockIncrement(-1);
                    value = Math.max(value, 0);
                    scrollBar.setValue(value);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(34, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value = scrollBar.getValue() + scrollBar.getBlockIncrement(1);
                    value = Math.min(value, scrollBar.getMaximum());
                    scrollBar.setValue(value);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(36, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    scrollBar.setValue(0);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(35, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    scrollBar.setValue(scrollBar.getMaximum());
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(36, 2), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    scrollBar.setValue(0);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(35, 2), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    scrollBar.setValue(scrollBar.getMaximum());
                }
            });
        }
    }

    public String getText() {
        return this.myText;
    }

    public void dispose() {
        this.myBackStack.clear();
        this.myForwardStack.clear();
        this.myKeyboardActions.clear();
        this.myElement = null;
        this.myManager = null;
        this.myHint = null;
    }

    private int getLinkCount() {
        HTMLDocument document = (HTMLDocument)this.myEditorPane.getDocument();
        int linkCount = 0;
        HTMLDocument.Iterator it = document.getIterator(HTML.Tag.A);
        while (it.isValid()) {
            if (it.getAttributes().isDefined(HTML.Attribute.HREF)) {
                ++linkCount;
            }
            it.next();
        }
        return linkCount;
    }

    @Nullable
    private HTMLDocument.Iterator getLink(int n) {
        if (n >= 0) {
            HTMLDocument document = (HTMLDocument)this.myEditorPane.getDocument();
            int linkCount = 0;
            HTMLDocument.Iterator it = document.getIterator(HTML.Tag.A);
            while (it.isValid()) {
                if (it.getAttributes().isDefined(HTML.Attribute.HREF) && linkCount++ == n) {
                    return it;
                }
                it.next();
            }
        }
        return null;
    }

    private void highlightLink(int n) {
        this.myHighlightedLink = n;
        Highlighter highlighter = this.myEditorPane.getHighlighter();
        HTMLDocument.Iterator link = this.getLink(n);
        if (link != null) {
            int startOffset = link.getStartOffset();
            int endOffset = link.getEndOffset();
            try {
                if (this.myHighlightingTag == null) {
                    this.myHighlightingTag = highlighter.addHighlight(startOffset, endOffset, LINK_HIGHLIGHTER);
                } else {
                    highlighter.changeHighlight(this.myHighlightingTag, startOffset, endOffset);
                }
                this.myEditorPane.setCaretPosition(startOffset);
            }
            catch (BadLocationException e) {
                LOG.warn("Error highlighting link", (Throwable)e);
            }
        } else if (this.myHighlightingTag != null) {
            highlighter.removeHighlight(this.myHighlightingTag);
            this.myHighlightingTag = null;
        }
    }

    private void activateLink(int n) {
        HTMLDocument.Iterator link = this.getLink(n);
        if (link != null) {
            String href = (String)link.getAttributes().getAttribute(HTML.Attribute.HREF);
            this.myManager.navigateByLink(this, href);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontSize";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRect";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorPane";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndFetch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickDocFontSize";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBottom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAndFetch";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setQuickDocFontSize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setDataInternal";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setTextFast";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExternalText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "restoreContext";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isToolbar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RestoreDefaultSizeAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        RestoreDefaultSizeAction() {
            super("Restore Size");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreDefaultSizeAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(DocumentationComponent.this.myHint != null && DocumentationComponent.this.myHint.getDimensionServiceKey() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreDefaultSizeAction.$$$reportNull$$$0(1);
            }
            DimensionService.getInstance().setSize("javadoc.popup.new", null, ((DocumentationComponent)DocumentationComponent.this).myManager.myProject);
            DocumentationComponent.this.myHint.setDimensionServiceKey(null);
            DocumentationComponent.this.showHint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$RestoreDefaultSizeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowAsToolwindowAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        ShowAsToolwindowAction() {
            super("Open as Tool Window");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAsToolwindowAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(DocumentationComponent.this.myToolwindowCallback != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAsToolwindowAction.$$$reportNull$$$0(1);
            }
            DocumentationComponent.this.myToolwindowCallback.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ShowAsToolwindowAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyScrollPane
    extends JBScrollPane {
        MyScrollPane() {
            super((Component)DocumentationComponent.this.myEditorPane, 20, 30);
            this.setLayout((LayoutManager)new JBScrollPane.Layout(){

                public void layoutContainer(Container parent) {
                    Rectangle bounds2;
                    super.layoutContainer(parent);
                    if (!DocumentationComponent.this.myCorner.isVisible()) {
                        return;
                    }
                    if (this.vsb != null) {
                        bounds2 = this.vsb.getBounds();
                        this.vsb.setBounds(bounds2.x, bounds2.y, bounds2.width, bounds2.height - ((DocumentationComponent)DocumentationComponent.this).myCorner.getPreferredSize().height - 3);
                    }
                    if (this.hsb != null) {
                        bounds2 = this.hsb.getBounds();
                        int vsbOffset = this.vsb != null ? this.vsb.getBounds().width : 0;
                        this.hsb.setBounds(bounds2.x, bounds2.y, bounds2.width - ((DocumentationComponent)DocumentationComponent.this).myCorner.getPreferredSize().width - 3 + vsbOffset, bounds2.height);
                    }
                }
            });
        }

        public Border getViewportBorder() {
            return null;
        }

        protected void processMouseWheelEvent(MouseWheelEvent e) {
            if (!EditorSettingsExternalizable.getInstance().isWheelFontChangeEnabled() || !EditorUtil.isChangeFontSize(e)) {
                super.processMouseWheelEvent(e);
                return;
            }
            int rotation = e.getWheelRotation();
            if (rotation == 0) {
                return;
            }
            boolean increase = rotation <= 0;
            FontSize newFontSize = DocumentationComponent.getQuickDocFontSize();
            for (int change = Math.abs(rotation); change > 0; --change) {
                newFontSize = increase ? newFontSize.larger() : newFontSize.smaller();
            }
            if (newFontSize == DocumentationComponent.getQuickDocFontSize()) {
                return;
            }
            DocumentationComponent.this.setQuickDocFontSize(newFontSize);
            DocumentationComponent.this.applyFontProps();
            DocumentationComponent.this.setFontSizeSliderSize(newFontSize);
        }
    }

    private class ShowToolbarAction
    extends ToggleAction
    implements HintManagerImpl.ActionToIgnore {
        ShowToolbarAction() {
            super("Show Toolbar");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowToolbarAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            if (DocumentationComponent.this.myManager == null || ((DocumentationComponent)DocumentationComponent.this).myManager.myToolWindow != null) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowToolbarAction.$$$reportNull$$$0(1);
            }
            return Registry.get((String)"documentation.show.toolbar").asBoolean();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowToolbarAction.$$$reportNull$$$0(2);
            }
            Registry.get((String)"documentation.show.toolbar").setValue(state);
            DocumentationComponent.this.updateControlState();
            DocumentationComponent.this.showHint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ShowToolbarAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LinkHighlighter
    implements Highlighter.HighlightPainter {
        private static final Stroke STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f}, 0.0f);

        private LinkHighlighter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g, int p0, int p1, Shape bounds2, JTextComponent c) {
            try {
                Rectangle target2 = c.getUI().getRootView(c).modelToView(p0, Position.Bias.Forward, p1, Position.Bias.Backward, bounds2).getBounds();
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    g2d.setStroke(STROKE);
                    g2d.setColor(c.getSelectionColor());
                    g2d.drawRect(target2.x, target2.y, target2.width - 1, target2.height - 1);
                }
                finally {
                    g2d.dispose();
                }
            }
            catch (Exception e) {
                LOG.warn("Error painting link highlight", (Throwable)e);
            }
        }
    }

    private class ActivateLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private ActivateLinkAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ActivateLinkAction.$$$reportNull$$$0(0);
            }
            DocumentationComponent.this.activateLink(DocumentationComponent.this.myHighlightedLink);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationComponent$ActivateLinkAction", "actionPerformed"));
        }
    }

    private class NextLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private NextLinkAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            int linkCount;
            if (e == null) {
                NextLinkAction.$$$reportNull$$$0(0);
            }
            if ((linkCount = DocumentationComponent.this.getLinkCount()) <= 0) {
                return;
            }
            DocumentationComponent.this.highlightLink((DocumentationComponent.this.myHighlightedLink + 1) % linkCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationComponent$NextLinkAction", "actionPerformed"));
        }
    }

    private class PreviousLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private PreviousLinkAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            int linkCount;
            if (e == null) {
                PreviousLinkAction.$$$reportNull$$$0(0);
            }
            if ((linkCount = DocumentationComponent.this.getLinkCount()) <= 0) {
                return;
            }
            DocumentationComponent.this.highlightLink(DocumentationComponent.this.myHighlightedLink < 0 ? linkCount - 1 : (DocumentationComponent.this.myHighlightedLink + linkCount - 1) % linkCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationComponent$PreviousLinkAction", "actionPerformed"));
        }
    }

    private static abstract class MyDictionary<K, V>
    extends Dictionary<K, V> {
        private MyDictionary() {
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<K> keys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<V> elements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }
    }

    private class MyShowSettingsAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private final boolean myOnToolbar;

        MyShowSettingsAction(boolean onToolbar) {
            super("Adjust font size...");
            this.myOnToolbar = onToolbar;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowSettingsAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            if (DocumentationComponent.this.myManager == null || this.myOnToolbar && ((DocumentationComponent)DocumentationComponent.this).myManager.myToolWindow != null) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowSettingsAction.$$$reportNull$$$0(1);
            }
            JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder(DocumentationComponent.this.mySettingsPanel, (JComponent)DocumentationComponent.this.myFontSizeSlider).createPopup();
            DocumentationComponent.this.setFontSizeSliderSize(DocumentationComponent.getQuickDocFontSize());
            DocumentationComponent.this.mySettingsPanel.setVisible(true);
            Point location = MouseInfo.getPointerInfo().getLocation();
            popup2.show(new RelativePoint(new Point(location.x - ((DocumentationComponent)DocumentationComponent.this).mySettingsPanel.getPreferredSize().width / 2, location.y - ((DocumentationComponent)DocumentationComponent.this).mySettingsPanel.getPreferredSize().height / 2)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$MyShowSettingsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Context {
        final SmartPsiElementPointer element;
        final String text;
        final String externalUrl;
        final DocumentationProvider provider;
        final Rectangle viewRect;
        final int caretPosition;
        final int highlightedLink;

        Context(SmartPsiElementPointer element, String text, String externalUrl, DocumentationProvider provider, Rectangle viewRect, int caretPosition, int highlightedLink) {
            this.element = element;
            this.text = text;
            this.externalUrl = externalUrl;
            this.provider = provider;
            this.viewRect = viewRect;
            this.caretPosition = caretPosition;
            this.highlightedLink = highlightedLink;
        }

        @NotNull
        Context withText(@NotNull String text) {
            if (text == null) {
                Context.$$$reportNull$$$0(0);
            }
            Context context = new Context(this.element, text, this.externalUrl, this.provider, this.viewRect, this.caretPosition, this.highlightedLink);
            if (context == null) {
                Context.$$$reportNull$$$0(1);
            }
            return context;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationComponent$Context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$Context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "withText";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ExternalDocAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private ExternalDocAction() {
            super(CodeInsightBundle.message((String)"javadoc.action.view.external", (Object[])new Object[0]), null, AllIcons.Actions.PreviousOccurence);
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExternalJavaDoc").getShortcutSet(), null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExternalDocAction.$$$reportNull$$$0(0);
            }
            if (DocumentationComponent.this.myElement == null) {
                return;
            }
            PsiElement element = DocumentationComponent.this.myElement.getElement();
            PsiElement originalElement = DocumentationManager.getOriginalElement(element);
            ExternalJavaDocAction.showExternalJavadoc(element, originalElement, DocumentationComponent.this.myExternalUrl, e.getDataContext());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExternalDocAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(DocumentationComponent.this.hasExternalDoc());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ExternalDocAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class EditDocumentationSourceAction
    extends BaseNavigateToSourceAction {
        private EditDocumentationSourceAction() {
            super(true);
            this.getTemplatePresentation().setIcon(AllIcons.Actions.EditSource);
            this.getTemplatePresentation().setText("Edit Source");
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditDocumentationSourceAction.$$$reportNull$$$0(0);
            }
            super.actionPerformed(e);
            AbstractPopup hint = DocumentationComponent.this.myHint;
            if (hint != null && hint.isVisible()) {
                hint.cancel();
            }
        }

        @Override
        @Nullable
        protected Navigatable[] getNavigatables(DataContext dataContext) {
            SmartPsiElementPointer element = DocumentationComponent.this.myElement;
            if (element != null) {
                Navigatable[] navigatableArray;
                PsiElement psiElement = element.getElement();
                if (psiElement instanceof Navigatable) {
                    Navigatable[] navigatableArray2 = new Navigatable[1];
                    navigatableArray = navigatableArray2;
                    navigatableArray2[0] = (Navigatable)psiElement;
                } else {
                    navigatableArray = null;
                }
                return navigatableArray;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationComponent$EditDocumentationSourceAction", "actionPerformed"));
        }
    }

    private class ForwardAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        ForwardAction() {
            super(CodeInsightBundle.message((String)"javadoc.action.forward", (Object[])new Object[0]), null, AllIcons.Actions.Forward);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ForwardAction.$$$reportNull$$$0(0);
            }
            DocumentationComponent.this.goForward();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ForwardAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(!DocumentationComponent.this.myForwardStack.isEmpty());
            if (!DocumentationComponent.isToolbar(e)) {
                presentation.setVisible(presentation.isEnabled());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ForwardAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class BackAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        BackAction() {
            super(CodeInsightBundle.message((String)"javadoc.action.back", (Object[])new Object[0]), null, AllIcons.Actions.Back);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                BackAction.$$$reportNull$$$0(0);
            }
            DocumentationComponent.this.goBack();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                BackAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(!DocumentationComponent.this.myBackStack.isEmpty());
            if (!DocumentationComponent.isToolbar(e)) {
                presentation.setVisible(presentation.isEnabled());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$BackAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyGearActionGroup
    extends DefaultActionGroup
    implements HintManagerImpl.ActionToIgnore {
        MyGearActionGroup(AnAction ... actions) {
            if (actions == null) {
                MyGearActionGroup.$$$reportNull$$$0(0);
            }
            super(actions);
            this.setPopup(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/codeInsight/documentation/DocumentationComponent$MyGearActionGroup", "<init>"));
        }
    }
}

