/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.PlatformDocumentationUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalFilter {
    private static final Logger LOG = Logger.getInstance(AbstractExternalFilter.class);
    private static final Pattern ourClassDataStartPattern = Pattern.compile("START OF CLASS DATA", 2);
    private static final Pattern ourClassDataEndPattern = Pattern.compile("SUMMARY ========", 2);
    private static final Pattern ourNonClassDataEndPattern = Pattern.compile("<A (NAME|ID)=", 2);
    @NonNls
    protected static final Pattern ourAnchorSuffix = Pattern.compile("#(.*)$");
    @NonNls
    protected static final Pattern ourHtmlFileSuffix = Pattern.compile("/([^/]*[.][hH][tT][mM][lL]?)$");
    @NonNls
    private static final Pattern ourAnnihilator = Pattern.compile("/[^/^.]*/[.][.]/");
    @NonNls
    private static final String JAR_PROTOCOL = "jar:";
    @NonNls
    private static final String HR = "<HR>";
    @NonNls
    private static final String P = "<P>";
    @NonNls
    private static final String DL = "<DL>";
    @NonNls
    protected static final String H2 = "</H2>";
    @NonNls
    protected static final String HTML_CLOSE = "</HTML>";
    @NonNls
    protected static final String HTML = "<HTML>";
    @NonNls
    private static final String BR = "<BR>";
    @NonNls
    private static final String DT = "<DT>";
    private static final Pattern CHARSET_META_PATTERN = Pattern.compile("<meta[^>]+\\s*charset=\"?([\\w\\-]*)\\s*\">", 2);
    private static final String FIELD_SUMMARY = "<!-- =========== FIELD SUMMARY =========== -->";
    private static final String CLASS_SUMMARY = "<div class=\"summary\">";
    @NonNls
    private static final String GREATEST_END_SECTION = "<!-- ========= END OF CLASS DATA ========= -->";

    protected static String doAnnihilate(String path) {
        int len = path.length();
        while (len > (len = (path = ourAnnihilator.matcher(path).replaceAll("/")).length())) {
        }
        return path;
    }

    public CharSequence correctRefs(String root, CharSequence read2) {
        CharSequence result2 = read2;
        for (RefConvertor myReferenceConvertor : this.getRefConverters()) {
            result2 = myReferenceConvertor.refFilter(root, result2);
        }
        return result2;
    }

    protected abstract RefConvertor[] getRefConverters();

    @Nullable
    public String getExternalDocInfo(String url) throws Exception {
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode() && app.isDispatchThread() || app.isWriteAccessAllowed()) {
            LOG.error("May block indefinitely: shouldn't be called from EDT or under write lock");
            return null;
        }
        if (url == null || !MyJavadocFetcher.ourFree) {
            return null;
        }
        MyJavadocFetcher fetcher = new MyJavadocFetcher(url, new MyDocBuilder(){

            @Override
            public void buildFromStream(String url, Reader input, StringBuilder result2) throws IOException {
                AbstractExternalFilter.this.doBuildFromStream(url, input, result2);
            }
        });
        try {
            app.executeOnPooledThread((Runnable)fetcher).get();
        }
        catch (Exception e) {
            return null;
        }
        Exception exception = fetcher.myException;
        if (exception != null) {
            fetcher.myException = null;
            throw exception;
        }
        return this.correctDocText(url, fetcher.data);
    }

    @NotNull
    protected String correctDocText(@NotNull String url, @NotNull CharSequence data) {
        if (url == null) {
            AbstractExternalFilter.$$$reportNull$$$0(0);
        }
        if (data == null) {
            AbstractExternalFilter.$$$reportNull$$$0(1);
        }
        CharSequence docText = this.correctRefs(ourAnchorSuffix.matcher(url).replaceAll(""), data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filtered JavaDoc: " + docText + "\n");
        }
        String string = PlatformDocumentationUtil.fixupText(docText);
        if (string == null) {
            AbstractExternalFilter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getExternalDocInfoForElement(String docURL, PsiElement element) throws Exception {
        return this.getExternalDocInfo(docURL);
    }

    protected void doBuildFromStream(String url, Reader input, StringBuilder data) throws IOException {
        this.doBuildFromStream(url, input, data, true, true);
    }

    protected void doBuildFromStream(String url, Reader input, StringBuilder data, boolean searchForEncoding, boolean matchStart) throws IOException {
        String read2;
        ParseSettings settings = this.getParseSettings(url);
        Pattern startSection = settings.startPattern;
        Pattern endSection = settings.endPattern;
        boolean useDt = settings.useDt;
        data.append(HTML);
        URL baseUrl = VfsUtilCore.convertToURL((String)url);
        if (baseUrl != null) {
            data.append("<base href=\"").append(baseUrl).append("\">");
        }
        data.append("<style type=\"text/css\">  ul.inheritance {\n      margin:0;\n      padding:0;\n  }\n  ul.inheritance li {\n       display:inline;\n       list-style-type:none;\n  }\n  ul.inheritance li ul.inheritance {\n    margin-left:15px;\n    padding-left:15px;\n    padding-top:1px;\n  }\n</style>");
        String contentEncoding = null;
        BufferedReader buf = new BufferedReader(input);
        do {
            String foundEncoding;
            if ((read2 = buf.readLine()) == null || !searchForEncoding || !read2.contains("charset") || (foundEncoding = AbstractExternalFilter.parseContentEncoding(read2)) == null) continue;
            contentEncoding = foundEncoding;
        } while (read2 != null && matchStart && !startSection.matcher(StringUtil.toUpperCase((String)read2)).find());
        if (input instanceof MyReader && contentEncoding != null && !contentEncoding.equalsIgnoreCase("UTF-8") && !contentEncoding.equals(((MyReader)input).getEncoding())) {
            try {
                data.setLength(0);
                this.doBuildFromStream(url, new MyReader(((MyReader)input).myInputStream, contentEncoding), data, false, true);
            }
            catch (ProcessCanceledException e) {
                return;
            }
            return;
        }
        if (read2 == null) {
            data.setLength(0);
            if (matchStart && !settings.forcePatternSearch && input instanceof MyReader) {
                try {
                    MyReader reader = contentEncoding != null ? new MyReader(((MyReader)input).myInputStream, contentEncoding) : new MyReader(((MyReader)input).myInputStream, ((MyReader)input).getEncoding());
                    this.doBuildFromStream(url, reader, data, false, false);
                }
                catch (ProcessCanceledException reader) {
                    // empty catch block
                }
            }
            return;
        }
        if (useDt) {
            boolean skip = false;
            do {
                if (StringUtil.toUpperCase((String)read2).contains(H2) && !read2.toUpperCase(Locale.ENGLISH).contains("H2")) {
                    data.append(H2);
                    skip = true;
                    continue;
                }
                if (endSection.matcher(read2).find() || StringUtil.indexOfIgnoreCase((String)read2, (String)GREATEST_END_SECTION, (int)0) != -1) {
                    data.append(HTML_CLOSE);
                    return;
                }
                if (skip) continue;
                AbstractExternalFilter.appendLine(data, read2);
            } while ((read2 = buf.readLine()) != null && !StringUtil.toUpperCase((String)read2).trim().equals(DL) && !StringUtil.containsIgnoreCase((String)read2, (String)"<div class=\"description\""));
            data.append(DL);
            StringBuilder classDetails = new StringBuilder();
            while ((read2 = buf.readLine()) != null && !StringUtil.toUpperCase((String)read2).equals(HR) && !StringUtil.toUpperCase((String)read2).equals(P)) {
                if (AbstractExternalFilter.reachTheEnd(data, read2, classDetails, endSection)) {
                    return;
                }
                if (AbstractExternalFilter.skipBlockList(read2)) continue;
                AbstractExternalFilter.appendLine(classDetails, read2);
            }
            while ((read2 = buf.readLine()) != null && !StringUtil.toUpperCase((String)read2).equals(HR) && !StringUtil.toUpperCase((String)read2).equals(P)) {
                if (AbstractExternalFilter.reachTheEnd(data, read2, classDetails, endSection)) {
                    return;
                }
                if (AbstractExternalFilter.skipBlockList(read2)) continue;
                AbstractExternalFilter.appendLine(data, read2.replaceAll(DT, "<DT><BR>"));
            }
            data.append((CharSequence)classDetails);
            data.append(P);
        } else {
            AbstractExternalFilter.appendLine(data, read2);
        }
        while ((read2 = buf.readLine()) != null && !endSection.matcher(read2).find() && StringUtil.indexOfIgnoreCase((String)read2, (String)GREATEST_END_SECTION, (int)0) == -1) {
            if (AbstractExternalFilter.skipBlockList(read2)) continue;
            AbstractExternalFilter.appendLine(data, read2);
        }
        data.append(HTML_CLOSE);
    }

    private static boolean skipBlockList(String read2) {
        return StringUtil.toUpperCase((String)read2).contains(HR) || StringUtil.containsIgnoreCase((String)read2, (String)"<ul class=\"blockList\">") || StringUtil.containsIgnoreCase((String)read2, (String)"<li class=\"blockList\">");
    }

    @NotNull
    protected ParseSettings getParseSettings(@NotNull String url) {
        if (url == null) {
            AbstractExternalFilter.$$$reportNull$$$0(3);
        }
        Pattern startSection = ourClassDataStartPattern;
        Pattern endSection = ourClassDataEndPattern;
        boolean anchorPresent = false;
        Matcher anchorMatcher = ourAnchorSuffix.matcher(url);
        if (anchorMatcher.find()) {
            anchorPresent = true;
            startSection = Pattern.compile("<a (name|id)=\"" + Pattern.quote(anchorMatcher.group(1)) + "\"", 2);
            endSection = ourNonClassDataEndPattern;
        }
        ParseSettings parseSettings = new ParseSettings(startSection, endSection, !anchorPresent, anchorPresent);
        if (parseSettings == null) {
            AbstractExternalFilter.$$$reportNull$$$0(4);
        }
        return parseSettings;
    }

    private static boolean reachTheEnd(StringBuilder data, String read2, StringBuilder classDetails, Pattern endSection) {
        if (StringUtil.indexOfIgnoreCase((String)read2, (String)FIELD_SUMMARY, (int)0) != -1 || StringUtil.indexOfIgnoreCase((String)read2, (String)CLASS_SUMMARY, (int)0) != -1 || StringUtil.indexOfIgnoreCase((String)read2, (String)GREATEST_END_SECTION, (int)0) != -1 || endSection.matcher(read2).find()) {
            data.append((CharSequence)classDetails);
            data.append(HTML_CLOSE);
            return true;
        }
        return false;
    }

    @Nullable
    static String parseContentEncoding(@NotNull String htmlLine) {
        if (htmlLine == null) {
            AbstractExternalFilter.$$$reportNull$$$0(5);
        }
        if (!htmlLine.contains("charset")) {
            return null;
        }
        Matcher matcher = CHARSET_META_PATTERN.matcher(htmlLine);
        return matcher.find() ? matcher.group(1) : null;
    }

    private static void appendLine(StringBuilder buffer, String read2) {
        buffer.append(read2);
        buffer.append("\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/AbstractExternalFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/AbstractExternalFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "correctDocText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParseSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "correctDocText";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParseSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseContentEncoding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class ParseSettings {
        @NotNull
        private final Pattern startPattern;
        @NotNull
        private final Pattern endPattern;
        private final boolean forcePatternSearch;
        private final boolean useDt;

        public ParseSettings(@NotNull Pattern startPattern, @NotNull Pattern endPattern, boolean useDt, boolean forcePatternSearch) {
            if (startPattern == null) {
                ParseSettings.$$$reportNull$$$0(0);
            }
            if (endPattern == null) {
                ParseSettings.$$$reportNull$$$0(1);
            }
            this.startPattern = startPattern;
            this.endPattern = endPattern;
            this.useDt = useDt;
            this.forcePatternSearch = forcePatternSearch;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startPattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "endPattern";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/documentation/AbstractExternalFilter$ParseSettings";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyReader
    extends InputStreamReader {
        private final ByteArrayInputStream myInputStream;

        MyReader(ByteArrayInputStream in) {
            super(in);
            in.reset();
            this.myInputStream = in;
        }

        MyReader(ByteArrayInputStream in, String charsetName) throws UnsupportedEncodingException {
            super((InputStream)in, charsetName);
            in.reset();
            this.myInputStream = in;
        }
    }

    private static class MyJavadocFetcher
    implements Runnable {
        private static boolean ourFree = true;
        private final StringBuilder data = new StringBuilder();
        private final String url;
        private final MyDocBuilder myBuilder;
        private Exception myException;

        MyJavadocFetcher(String url, MyDocBuilder builder2) {
            this.url = url;
            this.myBuilder = builder2;
            ourFree = false;
        }

        @Override
        public void run() {
            try {
                if (this.url == null) {
                    return;
                }
                if (this.url.startsWith(AbstractExternalFilter.JAR_PROTOCOL)) {
                    VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(BrowserUtil.getDocURL((String)this.url));
                    if (file2 != null) {
                        this.myBuilder.buildFromStream(this.url, new StringReader(VfsUtilCore.loadText((VirtualFile)file2)), this.data);
                    }
                } else {
                    URL parsedUrl = BrowserUtil.getURL((String)this.url);
                    if (parsedUrl != null) {
                        HttpRequests.request((String)parsedUrl.toString()).gzip(false).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Void>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public Void process(@NotNull HttpRequests.Request request) throws IOException {
                                if (request == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                byte[] bytes = request.readBytes(null);
                                String contentEncoding = null;
                                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                                try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                                    String htmlLine = reader.readLine();
                                    while (htmlLine != null) {
                                        contentEncoding = AbstractExternalFilter.parseContentEncoding(htmlLine);
                                        if (contentEncoding != null) {
                                            break;
                                        }
                                        htmlLine = reader.readLine();
                                    }
                                }
                                finally {
                                    stream.reset();
                                }
                                if (contentEncoding == null) {
                                    contentEncoding = request.getConnection().getContentEncoding();
                                }
                                myBuilder.buildFromStream(url, contentEncoding != null ? new MyReader(stream, contentEncoding) : new MyReader(stream), data);
                                return null;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/codeInsight/documentation/AbstractExternalFilter$MyJavadocFetcher$1", "process"));
                            }
                        });
                    }
                }
            }
            catch (ProcessCanceledException parsedUrl) {
            }
            catch (IOException e) {
                this.myException = e;
            }
            finally {
                ourFree = true;
            }
        }
    }

    private static interface MyDocBuilder {
        public void buildFromStream(String var1, Reader var2, StringBuilder var3) throws IOException;
    }

    protected static abstract class RefConvertor {
        @NotNull
        private final Pattern mySelector;

        public RefConvertor(@NotNull Pattern selector) {
            if (selector == null) {
                RefConvertor.$$$reportNull$$$0(0);
            }
            this.mySelector = selector;
        }

        protected abstract String convertReference(String var1, String var2);

        public CharSequence refFilter(String root, @NotNull CharSequence read2) {
            if (read2 == null) {
                RefConvertor.$$$reportNull$$$0(1);
            }
            CharSequence toMatch = StringUtilRt.toUpperCase((CharSequence)read2);
            StringBuilder ready = new StringBuilder();
            int prev2 = 0;
            Matcher matcher = this.mySelector.matcher(toMatch);
            while (matcher.find()) {
                CharSequence before = read2.subSequence(prev2, matcher.start(1) - 1);
                CharSequence href = read2.subSequence(matcher.start(1), matcher.end(1));
                prev2 = matcher.end(1) + 1;
                ready.append(before);
                ready.append("\"");
                ready.append((String)ReadAction.compute(() -> this.convertReference(root, href.toString())));
                ready.append("\"");
            }
            ready.append(read2, prev2, read2.length());
            return ready;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "read";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/documentation/AbstractExternalFilter$RefConvertor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refFilter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

