/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ui.CvsRootAsStringConfigurationPanel;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsMethod;
import com.intellij.cvsSupport2.connections.CvsRootData;
import com.intellij.cvsSupport2.connections.CvsRootDataBuilder;
import com.intellij.cvsSupport2.connections.CvsRootException;
import com.intellij.cvsSupport2.connections.ext.ui.ExtConnectionDualPanel;
import com.intellij.cvsSupport2.connections.local.ui.LocalConnectionSettingsPanel;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorker;
import com.intellij.cvsSupport2.connections.ssh.ui.SshConnectionSettingsPanel;
import com.intellij.cvsSupport2.connections.ui.ProxySettingsPanel;
import com.intellij.cvsSupport2.cvsoperations.common.LoginPerformer;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsProviderOnEnvironment;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.ui.DateOrRevisionOrTagSettings;
import com.intellij.cvsSupport2.ui.CvsRootChangeListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Cvs2SettingsEditPanel {
    private JPanel myPanel;
    private final Ref<Boolean> myIsUpdating;
    private final CvsRootAsStringConfigurationPanel myCvsRootConfigurationPanelView;
    private JPanel myCvsRootConfigurationPanel;
    private final DateOrRevisionOrTagSettings myDateOrRevisionOrTagSettings;
    private JPanel myConnectionSettingsPanel;
    private JPanel myDateOrRevisionOrTagSettingsPanel;
    private final ExtConnectionDualPanel myExtConnectionSettingsEditor;
    private final SshConnectionSettingsPanel mySshConnectionSettingsEditor;
    private final LocalConnectionSettingsPanel myLocalConnectionSettingsPanel;
    private JButton myTestButton;
    @NonNls
    public static final String EMPTY = "EMPTY";
    private JPanel myProxySettingsPanel;
    private final ProxySettingsPanel myProxySettingsNonEmptyPanel;
    @NonNls
    private static final String NON_EMPTY_PROXY_SETTINGS = "NON-EMPTY-PROXY-SETTINGS";
    private final Project myProject;

    public Cvs2SettingsEditPanel(Project project, boolean readOnly) {
        this.$$$setupUI$$$();
        this.myIsUpdating = new Ref();
        this.myProject = project;
        this.myDateOrRevisionOrTagSettings = new DateOrRevisionOrTagSettings(new TagsProviderOnEnvironment(){

            @Override
            @Nullable
            protected CvsEnvironment getCvsEnvironment() {
                return Cvs2SettingsEditPanel.this.createConfigurationWithCurrentSettings();
            }
        }, project);
        this.myPanel.setSize(this.myPanel.getPreferredSize());
        this.myCvsRootConfigurationPanel.setLayout(new BorderLayout());
        this.myCvsRootConfigurationPanelView = new CvsRootAsStringConfigurationPanel(readOnly, this.myIsUpdating);
        this.myCvsRootConfigurationPanel.add((Component)this.myCvsRootConfigurationPanelView.getPanel(), "Center");
        this.myConnectionSettingsPanel.setLayout(new CardLayout());
        this.myExtConnectionSettingsEditor = new ExtConnectionDualPanel(project);
        this.mySshConnectionSettingsEditor = new SshConnectionSettingsPanel(project);
        this.myLocalConnectionSettingsPanel = new LocalConnectionSettingsPanel(project);
        this.myConnectionSettingsPanel.add((Component)this.myExtConnectionSettingsEditor.getPanel(), CvsMethod.EXT_METHOD.getDisplayName());
        this.myConnectionSettingsPanel.add((Component)new JPanel(), CvsMethod.PSERVER_METHOD.getDisplayName());
        this.myConnectionSettingsPanel.add((Component)this.mySshConnectionSettingsEditor.getPanel(), CvsMethod.SSH_METHOD.getDisplayName());
        this.myConnectionSettingsPanel.add(this.myLocalConnectionSettingsPanel.getPanel(), CvsMethod.LOCAL_METHOD.getDisplayName());
        this.myConnectionSettingsPanel.add((Component)new JPanel(), EMPTY);
        this.myDateOrRevisionOrTagSettingsPanel.setLayout(new BorderLayout(4, 2));
        this.myDateOrRevisionOrTagSettingsPanel.add((Component)this.myDateOrRevisionOrTagSettings.getPanel(), "Center");
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Cvs2SettingsEditPanel.this.myPanel.isEnabled()) {
                    return;
                }
                Cvs2SettingsEditPanel.this.testConfiguration();
            }
        });
        this.addCvsRootChangeListener(new CvsRootChangeListener(){

            @Override
            public void onCvsRootChanged() {
                Cvs2SettingsEditPanel.this.conditionallyEnableComponents();
            }
        });
        this.myProxySettingsPanel.setLayout(new CardLayout());
        this.myProxySettingsNonEmptyPanel = new ProxySettingsPanel();
        this.myProxySettingsPanel.add(this.myProxySettingsNonEmptyPanel.getPanel(), NON_EMPTY_PROXY_SETTINGS);
        this.myProxySettingsPanel.add((Component)new JPanel(), EMPTY);
        if (readOnly) {
            Cvs2SettingsEditPanel.setEnabled(this.myDateOrRevisionOrTagSettingsPanel, false);
        }
    }

    public void addCvsRootChangeListener(CvsRootChangeListener cvsRootChangeListener) {
        this.myCvsRootConfigurationPanelView.addCvsRootChangeListener(cvsRootChangeListener);
        this.myExtConnectionSettingsEditor.addCvsRootChangeListener(cvsRootChangeListener);
    }

    public void updateFrom(CvsRootConfiguration configuration) {
        this.setEnabled(true);
        this.myIsUpdating.set((Object)Boolean.TRUE);
        try {
            this.myCvsRootConfigurationPanelView.updateFrom(configuration);
            this.myExtConnectionSettingsEditor.updateFrom(configuration.EXT_CONFIGURATION, configuration.SSH_FOR_EXT_CONFIGURATION);
            this.mySshConnectionSettingsEditor.updateFrom(configuration.SSH_CONFIGURATION);
            this.myDateOrRevisionOrTagSettings.updateFrom(configuration.DATE_OR_REVISION_SETTINGS);
            this.myLocalConnectionSettingsPanel.updateFrom(configuration.LOCAL_CONFIGURATION);
            this.myProxySettingsNonEmptyPanel.updateFrom(configuration.PROXY_SETTINGS);
        }
        finally {
            this.myIsUpdating.set(null);
        }
        this.conditionallyEnableComponents();
    }

    public void saveTo(CvsRootConfiguration configuration) {
        this.myCvsRootConfigurationPanelView.saveTo(configuration);
        CvsApplicationLevelConfiguration globalCvsSettings = CvsApplicationLevelConfiguration.getInstance();
        if (!this.myExtConnectionSettingsEditor.equalsTo(configuration.EXT_CONFIGURATION, configuration.SSH_FOR_EXT_CONFIGURATION)) {
            this.myExtConnectionSettingsEditor.saveTo(configuration.EXT_CONFIGURATION, configuration.SSH_FOR_EXT_CONFIGURATION);
            this.myExtConnectionSettingsEditor.saveTo(globalCvsSettings.EXT_CONFIGURATION, globalCvsSettings.SSH_FOR_EXT_CONFIGURATION);
        }
        if (!this.mySshConnectionSettingsEditor.equalsTo(configuration.SSH_CONFIGURATION)) {
            this.mySshConnectionSettingsEditor.saveTo(configuration.SSH_CONFIGURATION);
            this.mySshConnectionSettingsEditor.saveTo(globalCvsSettings.SSH_CONFIGURATION);
        }
        if (!this.myLocalConnectionSettingsPanel.equalsTo(configuration.LOCAL_CONFIGURATION)) {
            this.myLocalConnectionSettingsPanel.saveTo(configuration.LOCAL_CONFIGURATION);
            this.myLocalConnectionSettingsPanel.saveTo(globalCvsSettings.LOCAL_CONFIGURATION);
        }
        if (!this.myProxySettingsNonEmptyPanel.equalsTo(configuration.PROXY_SETTINGS)) {
            this.myProxySettingsNonEmptyPanel.saveTo(configuration.PROXY_SETTINGS);
            this.myProxySettingsNonEmptyPanel.saveTo(globalCvsSettings.PROXY_SETTINGS);
        }
        this.myDateOrRevisionOrTagSettings.saveTo(configuration.DATE_OR_REVISION_SETTINGS);
    }

    private void testConfiguration() {
        CvsRootConfiguration newConfiguration = this.createConfigurationWithCurrentSettings();
        if (newConfiguration == null) {
            return;
        }
        try {
            Cvs2SettingsEditPanel.testConnection(newConfiguration, this.myPanel, this.myProject);
        }
        catch (CvsRootException e) {
            e.show();
            return;
        }
        this.updateFrom(newConfiguration);
    }

    @Nullable
    private CvsRootConfiguration createConfigurationWithCurrentSettings() {
        CvsRootConfiguration newConfiguration = CvsApplicationLevelConfiguration.createNewConfiguration(CvsApplicationLevelConfiguration.getInstance());
        try {
            this.saveTo(newConfiguration);
        }
        catch (InputException e) {
            e.show();
            return null;
        }
        return newConfiguration;
    }

    private static void testConnection(CvsRootConfiguration configuration, final Component component, Project project) {
        final CvsLoginWorker loginWorker = configuration.getLoginWorker(project);
        final Ref success = new Ref();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, CvsBundle.message((String)"message.connecting.to.cvs.server", (Object[])new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                indicator.setText2(CvsBundle.message((String)"message.current.global.timeout.setting", (Object[])new Object[]{CvsApplicationLevelConfiguration.getInstance().TIMEOUT}));
                try {
                    ThreeState result = LoginPerformer.checkLoginWorker(loginWorker, true);
                    if (ThreeState.NO == result) {
                        Cvs2SettingsEditPanel.showConnectionFailedMessage(component, CvsBundle.message((String)"test.connection.login.failed.text", (Object[])new Object[0]));
                    } else if (ThreeState.UNSURE == result) {
                        Cvs2SettingsEditPanel.showConnectionFailedMessage(component, CvsBundle.message((String)"error.message.authentication.canceled", (Object[])new Object[0]));
                    } else {
                        success.set((Object)Boolean.TRUE);
                    }
                }
                catch (ProcessCanceledException result) {
                }
                catch (Exception e) {
                    Cvs2SettingsEditPanel.showConnectionFailedMessage(component, e.getLocalizedMessage());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/cvsSupport2/config/ui/Cvs2SettingsEditPanel$4", "run"));
            }
        });
        if (success.get() != Boolean.TRUE) {
            return;
        }
        try {
            configuration.testConnection(project);
            Cvs2SettingsEditPanel.showSuccessfulConnectionMessage(component);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (Exception e) {
            Cvs2SettingsEditPanel.showConnectionFailedMessage(component, e.getLocalizedMessage());
        }
    }

    private static void showConnectionFailedMessage(Component parent, String message) {
        UIUtil.invokeLaterIfNeeded(() -> Messages.showMessageDialog((Component)parent, (String)message, (String)CvsBundle.message((String)"operation.name.test.connection", (Object[])new Object[0]), (Icon)Messages.getErrorIcon()));
    }

    private static void showSuccessfulConnectionMessage(Component component) {
        UIUtil.invokeLaterIfNeeded(() -> Messages.showMessageDialog((Component)component, (String)CvsBundle.message((String)"operation.status.connection.successful", (Object[])new Object[0]), (String)CvsBundle.message((String)"operation.name.test.connection", (Object[])new Object[0]), (Icon)Messages.getInformationIcon()));
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    private void setEnabled(boolean enabled) {
        Cvs2SettingsEditPanel.setEnabled(this.myPanel, enabled);
        this.conditionallyEnableComponents();
    }

    private void conditionallyEnableComponents() {
        try {
            CvsRootData currentRootData = CvsRootDataBuilder.createSettingsOn(this.myCvsRootConfigurationPanelView.getCvsRoot(), true);
            String settingsPanelName = Cvs2SettingsEditPanel.getSettingsPanelName(currentRootData);
            ((CardLayout)this.myConnectionSettingsPanel.getLayout()).show(this.myConnectionSettingsPanel, settingsPanelName);
            ((CardLayout)this.myProxySettingsPanel.getLayout()).show(this.myProxySettingsPanel, this.getProxyPanelName(currentRootData));
            if (currentRootData.CONTAINS_PROXY_INFO) {
                this.myProxySettingsNonEmptyPanel.updateFrom(currentRootData);
                this.myProxySettingsNonEmptyPanel.disablePanel();
            } else {
                this.myProxySettingsNonEmptyPanel.enablePanel();
            }
        }
        catch (CvsRootException ignored) {
            ((CardLayout)this.myConnectionSettingsPanel.getLayout()).show(this.myConnectionSettingsPanel, EMPTY);
            ((CardLayout)this.myProxySettingsPanel.getLayout()).show(this.myProxySettingsPanel, EMPTY);
        }
    }

    private String getProxyPanelName(CvsRootData cvsRootData) {
        if (cvsRootData.METHOD == null) {
            return EMPTY;
        }
        if (cvsRootData.METHOD.supportsProxyConnection()) {
            return NON_EMPTY_PROXY_SETTINGS;
        }
        if (cvsRootData.METHOD == CvsMethod.EXT_METHOD && this.myExtConnectionSettingsEditor.isUseInternalSshImplementation()) {
            return NON_EMPTY_PROXY_SETTINGS;
        }
        return EMPTY;
    }

    private static String getSettingsPanelName(CvsRootData cvsRootData) {
        CvsMethod method = cvsRootData.METHOD;
        if (method == null) {
            return EMPTY;
        }
        return method.getDisplayName();
    }

    private static void setEnabled(Component component, boolean enabled) {
        component.setEnabled(enabled);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Cvs2SettingsEditPanel.setEnabled(container.getComponent(i), enabled);
            }
        }
    }

    public void disable() {
        Cvs2SettingsEditPanel.clearAllTextFieldsIn(this.myPanel);
        this.setEnabled(false);
    }

    private static void clearAllTextFieldsIn(Component component) {
        if (component instanceof JTextField) {
            ((JTextField)component).setText("");
            return;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Cvs2SettingsEditPanel.clearAllTextFieldsIn(container.getComponent(i));
            }
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCvsRootConfigurationPanelView.getPreferredFocusedComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCvsRootConfigurationPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDateOrRevisionOrTagSettingsPanel = jPanel3 = new JPanel();
        jPanel5.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myConnectionSettingsPanel = jPanel2 = new JPanel();
        jPanel5.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myProxySettingsPanel = jPanel = new JPanel();
        jPanel5.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 5, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTestButton = jButton = new JButton();
        jButton.setMargin(new Insets(2, 14, 2, 14));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("button.text.test.connection"));
        jPanel6.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

