/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.parosproxy.paros.network.GenericMethod;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;

public class HttpMethodHelper {
    private static final String OPTIONS = "OPTIONS";
    private static final String GET = "GET";
    private static final String HEAD = "HEAD";
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    private static final String TRACE = "TRACE";
    private static final String CONNECT = "CONNECT";
    private static final String HTTP11 = "HTTP/1.1";
    private static final String HTTP10 = "HTTP/1.0";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String CRLF = "\r\n";
    private static final String LF = "\n";
    private static final Pattern patternCRLF = Pattern.compile("\\r\\n", 8);
    private static final Pattern patternLF = Pattern.compile("\\n", 8);
    private static final String p_TEXT = "[^\\x00-\\x1f\\r\\n]*";
    private static final String p_METHOD = "(\\w+)";
    private static final String p_SP = " +";
    private static final String p_URI = "(\\S+)";
    private static final String p_VERSION = "(HTTP/\\d+\\.\\d+)";
    private static final Pattern patternRequestLine = Pattern.compile("(\\w+) +(\\S+) +(HTTP/\\d+\\.\\d+)", 2);
    private static final Pattern patternHostHeader = Pattern.compile("([^:]+)\\s*:?\\s*(\\d*)");
    private static final String HEADER_HOST = "Host";
    private String mUserAgent = "";

    public void setUserAgent(String string) {
        this.mUserAgent = string;
    }

    public HttpMethod createRequestMethodNew(HttpRequestHeader httpRequestHeader, HttpBody httpBody) throws URIException {
        GenericMethod genericMethod = null;
        String string = httpRequestHeader.getMethod();
        URI uRI = httpRequestHeader.getURI();
        String string2 = httpRequestHeader.getVersion();
        genericMethod = new GenericMethod(string);
        genericMethod.setURI(uRI);
        HttpMethodParams httpMethodParams = genericMethod.getParams();
        httpMethodParams.setVersion(HttpVersion.HTTP_1_0);
        if (string2.equalsIgnoreCase(HTTP11)) {
            httpMethodParams.setVersion(HttpVersion.HTTP_1_1);
        }
        int n = 0;
        Pattern pattern = null;
        String string3 = CRLF;
        String string4 = httpRequestHeader.getHeadersAsString();
        n = string4.indexOf(CRLF);
        if (n < 0) {
            n = string4.indexOf(LF);
            if (n < 0) {
                string3 = LF;
                pattern = patternLF;
            }
        } else {
            string3 = CRLF;
            pattern = patternCRLF;
        }
        String[] stringArray = pattern.split(string4);
        String string5 = null;
        String string6 = null;
        String string7 = null;
        Object var16_16 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string5 = stringArray[i];
            if (string5.equals("")) continue;
            n = string5.indexOf(":");
            if (n < 0) {
                return null;
            }
            string6 = string5.substring(0, n).trim();
            string7 = string5.substring(n + 1).trim();
            genericMethod.addRequestHeader(string6, string7);
        }
        if (httpBody != null && httpBody.length() > 0) {
            EntityEnclosingMethod entityEnclosingMethod = genericMethod;
            entityEnclosingMethod.setRequestEntity(new ByteArrayRequestEntity(httpBody.getBytes()));
        }
        genericMethod.setFollowRedirects(false);
        return genericMethod;
    }

    public HttpMethod createRequestMethod(HttpRequestHeader httpRequestHeader, HttpBody httpBody) throws URIException {
        HttpMethodBase httpMethodBase = null;
        String string = httpRequestHeader.getMethod();
        URI uRI = httpRequestHeader.getURI();
        String string2 = httpRequestHeader.getVersion();
        httpMethodBase = string.equalsIgnoreCase(GET) ? new GetMethod() : (string.equalsIgnoreCase(POST) ? new PostMethod() : (string.equalsIgnoreCase(DELETE) ? new DeleteMethod() : (string.equalsIgnoreCase(PUT) ? new PutMethod() : (string.equalsIgnoreCase(HEAD) ? new HeadMethod() : (string.equalsIgnoreCase(OPTIONS) ? new OptionsMethod() : (string.equalsIgnoreCase(TRACE) ? new TraceMethod(uRI.toString()) : new GenericMethod(string)))))));
        httpMethodBase.setURI(uRI);
        HttpMethodParams httpMethodParams = httpMethodBase.getParams();
        httpMethodParams.setVersion(HttpVersion.HTTP_1_0);
        if (string2.equalsIgnoreCase(HTTP11)) {
            httpMethodParams.setVersion(HttpVersion.HTTP_1_1);
        }
        int n = 0;
        Pattern pattern = null;
        String string3 = CRLF;
        String string4 = httpRequestHeader.getHeadersAsString();
        n = string4.indexOf(CRLF);
        if (n < 0) {
            n = string4.indexOf(LF);
            if (n < 0) {
                string3 = LF;
                pattern = patternLF;
            }
        } else {
            string3 = CRLF;
            pattern = patternCRLF;
        }
        String[] stringArray = pattern.split(string4);
        String string5 = null;
        String string6 = null;
        String string7 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string5 = stringArray[i];
            if (string5.equals("")) continue;
            n = string5.indexOf(":");
            if (n < 0) {
                return null;
            }
            string6 = string5.substring(0, n).trim();
            string7 = string5.substring(n + 1).trim();
            httpMethodBase.addRequestHeader(string6, string7);
        }
        if (httpBody != null && httpBody.length() > 0 && (httpMethodBase instanceof PostMethod || httpMethodBase instanceof PutMethod)) {
            EntityEnclosingMethod entityEnclosingMethod = (EntityEnclosingMethod)httpMethodBase;
            entityEnclosingMethod.setRequestEntity(new ByteArrayRequestEntity(httpBody.getBytes()));
        }
        httpMethodBase.setFollowRedirects(false);
        return httpMethodBase;
    }

    public static void updateHttpRequestHeaderSent(HttpRequestHeader httpRequestHeader, HttpMethod httpMethod) {
        StringBuffer stringBuffer = new StringBuffer(200);
        String string = null;
        String string2 = null;
        if (!httpMethod.hasBeenUsed()) {
            return;
        }
        stringBuffer.append(httpRequestHeader.getPrimeHeader() + CRLF);
        Header[] headerArray = httpMethod.getRequestHeaders();
        for (int i = 0; i < headerArray.length; ++i) {
            string = headerArray[i].getName();
            string2 = headerArray[i].getValue();
            stringBuffer.append(string + ": " + string2 + CRLF);
        }
        stringBuffer.append(CRLF);
        try {
            httpRequestHeader.setMessage(stringBuffer.toString());
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            httpMalformedHeaderException.printStackTrace();
        }
    }

    private static String getHttpResponseHeaderAsString(HttpMethod httpMethod) {
        StringBuffer stringBuffer = new StringBuffer(200);
        String string = null;
        String string2 = null;
        stringBuffer.append(httpMethod.getStatusLine().toString() + CRLF);
        Header[] headerArray = httpMethod.getResponseHeaders();
        for (int i = 0; i < headerArray.length; ++i) {
            string = headerArray[i].getName();
            string2 = headerArray[i].getValue();
            stringBuffer.append(string + ": " + string2 + CRLF);
        }
        stringBuffer.append(CRLF);
        return stringBuffer.toString();
    }

    public static HttpResponseHeader getHttpResponseHeader(HttpMethod httpMethod) throws HttpMalformedHeaderException {
        return new HttpResponseHeader(HttpMethodHelper.getHttpResponseHeaderAsString(httpMethod));
    }
}

