require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_AARCH64_CPU_H_)) {
    eval 'sub _AARCH64_CPU_H_ () {1;}' unless defined(&_AARCH64_CPU_H_);
    if(defined(&__aarch64__)) {
	if(defined(&_KERNEL_OPT)) {
	    require './aarch64/opt_multiprocessor.ph';
	}
	require 'sys/param.ph';
	if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	    require 'sys/evcnt.ph';
	    require 'aarch64/frame.ph';
	    require 'aarch64/armreg.ph';
	    eval 'sub CLKF_USERMODE {
	        my($cf) = @_;
    		eval q((((($cf)-> ($cf_tf->{tf_spsr})) & 0xf) == 0));
	    }' unless defined(&CLKF_USERMODE);
	    eval 'sub CLKF_PC {
	        my($cf) = @_;
    		eval q((($cf)-> ($cf_tf->{tf_pc})));
	    }' unless defined(&CLKF_PC);
	    eval 'sub CLKF_INTR {
	        my($cf) = @_;
    		eval q((( &void)($cf),  &curcpu()-> &ci_intr_depth > 1));
	    }' unless defined(&CLKF_INTR);
	    eval 'sub LWP_PC {
	        my($l) = @_;
    		eval q((($l)-> ($l_md->{md_utf}->{tf_pc})));
	    }' unless defined(&LWP_PC);
	    require 'sys/cpu_data.ph';
	    require 'sys/device_if.ph';
	    require 'sys/intr.ph';
	    eval 'sub curcpu {
	        my($void) = @_;
    		eval q({ \'struct cpu_info\' * &ci;  &__asm  &__volatile (\\"mrs %0, tpidr_el1\\" : \\"=r\\"( &ci));  &ci; });
	    }' unless defined(&curcpu);
	    eval 'sub curlwp () {( &curcpu()-> &ci_curlwp);}' unless defined(&curlwp);
	    eval 'sub setsoftast {
	        my($ci) = @_;
    		eval q( &atomic_or_uint(($ci)-> &ci_astpending,  &__BIT(0)));
	    }' unless defined(&setsoftast);
	    eval 'sub cpu_signotify {
	        my($l) = @_;
    		eval q( &setsoftast(($l)-> &l_cpu));
	    }' unless defined(&cpu_signotify);
	    eval 'sub CPU_INFO_ITERATOR () { &cpuid_t;}' unless defined(&CPU_INFO_ITERATOR);
	    if(defined(&MULTIPROCESSOR) || defined(&_MODULE)) {
		eval 'sub cpu_number () {
		    eval q(( &curcpu()-> &ci_index));
		}' unless defined(&cpu_number);
		eval 'sub CPU_IS_PRIMARY {
		    my($ci) = @_;
    		    eval q((($ci)-> &ci_index == 0));
		}' unless defined(&CPU_IS_PRIMARY);
		eval 'sub CPU_INFO_FOREACH {
		    my($cii, $ci) = @_;
    		    eval q($cii = 0, $ci =  $cpu_info[0]; $cii < ( &ncpu ?  &ncpu : 1)  && ($ci =  $cpu_info[$cii]) !=  &NULL; $cii++);
		}' unless defined(&CPU_INFO_FOREACH);
	    } else {
		eval 'sub cpu_number () {
		    eval q(0);
		}' unless defined(&cpu_number);
		eval 'sub CPU_IS_PRIMARY {
		    my($ci) = @_;
    		    eval q( &true);
		}' unless defined(&CPU_IS_PRIMARY);
		eval 'sub CPU_INFO_FOREACH {
		    my($cii, $ci) = @_;
    		    eval q($cii = 0,  &__USE($cii), $ci =  &curcpu(); $ci !=  &NULL; $ci =  &NULL);
		}' unless defined(&CPU_INFO_FOREACH);
	    }
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub cpu_dosoftints {
	        my($void) = @_;
    		eval q({ });
	    }' unless defined(&cpu_dosoftints);
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub cpu_intr_p {
	        my($void) = @_;
    		eval q({  &curcpu()-> &ci_intr_depth > 0; });
	    }' unless defined(&cpu_intr_p);
	}
    }
 elsif(defined(&__arm__)) {
	require 'arm/cpu.ph';
    }
}
1;
