/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import liquibase.configuration.ConfigurationContainer;
import liquibase.configuration.ConfigurationProperty;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.SystemPropertyProvider;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.util.StringUtils;

public class LiquibaseConfiguration {
    private Map<Class, ConfigurationContainer> configurations;
    private ConfigurationValueProvider[] configurationValueProviders;
    private static LiquibaseConfiguration instance;

    public static synchronized LiquibaseConfiguration getInstance() {
        if (instance == null) {
            instance = new LiquibaseConfiguration();
            instance.init(new SystemPropertyProvider());
        }
        return instance;
    }

    public static void setInstance(LiquibaseConfiguration instance) {
        LiquibaseConfiguration.instance = instance;
    }

    protected LiquibaseConfiguration() {
    }

    public void init(ConfigurationValueProvider ... configurationValueProviders) {
        if (configurationValueProviders == null) {
            configurationValueProviders = new ConfigurationValueProvider[]{};
        }
        this.configurationValueProviders = configurationValueProviders;
        this.reset();
    }

    public void reset() {
        this.configurations = new HashMap<Class, ConfigurationContainer>();
    }

    public <T extends ConfigurationContainer> T getConfiguration(Class<T> type) {
        if (!this.configurations.containsKey(type)) {
            this.configurations.put(type, (ConfigurationContainer)this.createConfiguration(type));
        }
        return (T)this.configurations.get(type);
    }

    public ConfigurationProperty getProperty(Class<? extends ConfigurationContainer> type, String property) {
        ConfigurationContainer configuration = this.getConfiguration(type);
        return configuration.getProperty(property);
    }

    protected <T extends ConfigurationContainer> T createConfiguration(Class<T> type) {
        try {
            ConfigurationContainer configuration = (ConfigurationContainer)type.newInstance();
            configuration.init(this.configurationValueProviders);
            return (T)configuration;
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException("Cannot create default configuration " + type.getName(), e);
        }
    }

    public String describeValueLookupLogic(Class<? extends ConfigurationContainer> config, String property) {
        return this.describeValueLookupLogic(this.getProperty(config, property));
    }

    public String describeValueLookupLogic(ConfigurationProperty property) {
        ArrayList<String> reasons = new ArrayList<String>();
        for (ConfigurationValueProvider container : this.configurationValueProviders) {
            reasons.add(container.describeValueLookupLogic(property));
        }
        return StringUtils.join(reasons, " AND ");
    }
}

