/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.ExtendedSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.internals.Change;

public class ChangedSerializer<T>
implements ExtendedSerializer<Change<T>> {
    private static final int NEWFLAG_SIZE = 1;
    private ExtendedSerializer<T> inner;

    public ChangedSerializer(Serializer<T> inner) {
        this.inner = ExtendedSerializer.Wrapper.ensureExtended(inner);
    }

    public Serializer<T> inner() {
        return this.inner;
    }

    public void setInner(Serializer<T> inner) {
        this.inner = ExtendedSerializer.Wrapper.ensureExtended(inner);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] serialize(String topic, Headers headers, Change<T> data) {
        byte[] serializedKey;
        if (data.newValue != null) {
            if (data.oldValue != null) {
                throw new StreamsException("Both old and new values are not null (" + data.oldValue + " : " + data.newValue + ") in ChangeSerializer, which is not allowed.");
            }
            serializedKey = this.inner.serialize(topic, headers, data.newValue);
        } else {
            if (data.oldValue == null) {
                throw new StreamsException("Both old and new values are null in ChangeSerializer, which is not allowed.");
            }
            serializedKey = this.inner.serialize(topic, headers, data.oldValue);
        }
        ByteBuffer buf = ByteBuffer.allocate(serializedKey.length + 1);
        buf.put(serializedKey);
        buf.put((byte)(data.newValue != null ? 1 : 0));
        return buf.array();
    }

    public byte[] serialize(String topic, Change<T> data) {
        return this.serialize(topic, null, data);
    }

    public void close() {
        this.inner.close();
    }
}

