/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchDupLoadInstructionVisitor {
    public static DupLoad visit(Instruction instruction, DupStore dupStore) {
        switch (instruction.opcode) {
            case 190: {
                return SearchDupLoadInstructionVisitor.visit(((ArrayLength)instruction).arrayref, dupStore);
            }
            case 271: {
                ArrayLoadInstruction ali = (ArrayLoadInstruction)instruction;
                DupLoad dupLoad = SearchDupLoadInstructionVisitor.visit(ali.arrayref, dupStore);
                if (dupLoad != null) {
                    return dupLoad;
                }
                return SearchDupLoadInstructionVisitor.visit(ali.indexref, dupStore);
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                DupLoad dupLoad = SearchDupLoadInstructionVisitor.visit(asi.arrayref, dupStore);
                if (dupLoad != null) {
                    return dupLoad;
                }
                dupLoad = SearchDupLoadInstructionVisitor.visit(asi.indexref, dupStore);
                if (dupLoad != null) {
                    return dupLoad;
                }
                return SearchDupLoadInstructionVisitor.visit(asi.valueref, dupStore);
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                DupLoad dupLoad = SearchDupLoadInstructionVisitor.visit(ai.test, dupStore);
                if (dupLoad != null) {
                    return dupLoad;
                }
                if (ai.msg == null) {
                    return null;
                }
                return SearchDupLoadInstructionVisitor.visit(ai.msg, dupStore);
            }
            case 191: {
                return SearchDupLoadInstructionVisitor.visit(((AThrow)instruction).value, dupStore);
            }
            case 266: {
                return SearchDupLoadInstructionVisitor.visit(((UnaryOperatorInstruction)instruction).value, dupStore);
            }
            case 265: 
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                DupLoad dupLoad = SearchDupLoadInstructionVisitor.visit(boi.value1, dupStore);
                if (dupLoad != null) {
                    return dupLoad;
                }
                return SearchDupLoadInstructionVisitor.visit(boi.value2, dupStore);
            }
            case 192: {
                return SearchDupLoadInstructionVisitor.visit(((CheckCast)instruction).objectref, dupStore);
            }
            case 54: 
            case 58: 
            case 269: {
                return SearchDupLoadInstructionVisitor.visit(((StoreInstruction)instruction).valueref, dupStore);
            }
            case 263: {
                if (((DupLoad)instruction).dupStore != dupStore) break;
                return (DupLoad)instruction;
            }
            case 264: {
                return SearchDupLoadInstructionVisitor.visit(((DupStore)instruction).objectref, dupStore);
            }
            case 275: 
            case 276: {
                return SearchDupLoadInstructionVisitor.visit(((ConvertInstruction)instruction).value, dupStore);
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                DupLoad dupLoad = SearchDupLoadInstructionVisitor.visit(ifCmp.value1, dupStore);
                if (dupLoad != null) {
                    return dupLoad;
                }
                return SearchDupLoadInstructionVisitor.visit(ifCmp.value2, dupStore);
            }
            case 260: 
            case 262: {
                return SearchDupLoadInstructionVisitor.visit(((IfInstruction)instruction).value, dupStore);
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int i = branchList.size() - 1;
                while (i >= 0) {
                    DupLoad dupLoad = SearchDupLoadInstructionVisitor.visit(branchList.get(i), dupStore);
                    if (dupLoad != null) {
                        return dupLoad;
                    }
                    --i;
                }
                break;
            }
            case 193: {
                return SearchDupLoadInstructionVisitor.visit(((InstanceOf)instruction).objectref, dupStore);
            }
            case 182: 
            case 183: 
            case 185: {
                DupLoad dupLoad = SearchDupLoadInstructionVisitor.visit(((InvokeNoStaticInstruction)instruction).objectref, dupStore);
                if (dupLoad != null) {
                    return dupLoad;
                }
            }
            case 184: 
            case 274: {
                List<Instruction> list = ((InvokeInstruction)instruction).args;
                int i = list.size() - 1;
                while (i >= 0) {
                    DupLoad dupLoad = SearchDupLoadInstructionVisitor.visit(list.get(i), dupStore);
                    if (dupLoad != null) {
                        return dupLoad;
                    }
                    --i;
                }
                break;
            }
            case 171: {
                return SearchDupLoadInstructionVisitor.visit(((LookupSwitch)instruction).key, dupStore);
            }
            case 194: {
                return SearchDupLoadInstructionVisitor.visit(((MonitorEnter)instruction).objectref, dupStore);
            }
            case 195: {
                return SearchDupLoadInstructionVisitor.visit(((MonitorExit)instruction).objectref, dupStore);
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int i = dimensions.length - 1;
                while (i >= 0) {
                    DupLoad dupLoad = SearchDupLoadInstructionVisitor.visit(dimensions[i], dupStore);
                    if (dupLoad != null) {
                        return dupLoad;
                    }
                    --i;
                }
                break;
            }
            case 188: {
                return SearchDupLoadInstructionVisitor.visit(((NewArray)instruction).dimension, dupStore);
            }
            case 189: {
                return SearchDupLoadInstructionVisitor.visit(((ANewArray)instruction).dimension, dupStore);
            }
            case 87: {
                return SearchDupLoadInstructionVisitor.visit(((Pop)instruction).objectref, dupStore);
            }
            case 181: {
                PutField putField = (PutField)instruction;
                DupLoad dupLoad = SearchDupLoadInstructionVisitor.visit(putField.objectref, dupStore);
                if (dupLoad != null) {
                    return dupLoad;
                }
                return SearchDupLoadInstructionVisitor.visit(putField.valueref, dupStore);
            }
            case 179: {
                return SearchDupLoadInstructionVisitor.visit(((PutStatic)instruction).valueref, dupStore);
            }
            case 273: {
                return SearchDupLoadInstructionVisitor.visit(((ReturnInstruction)instruction).valueref, dupStore);
            }
            case 170: {
                return SearchDupLoadInstructionVisitor.visit(((TableSwitch)instruction).key, dupStore);
            }
            case 280: {
                return SearchDupLoadInstructionVisitor.visit(((TernaryOpStore)instruction).objectref, dupStore);
            }
            case 277: 
            case 278: {
                return SearchDupLoadInstructionVisitor.visit(((IncInstruction)instruction).value, dupStore);
            }
            case 180: {
                return SearchDupLoadInstructionVisitor.visit(((GetField)instruction).objectref, dupStore);
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                DupLoad dupLoad = SearchDupLoadInstructionVisitor.visit(iai.newArray, dupStore);
                if (dupLoad != null) {
                    return dupLoad;
                }
                if (iai.values == null) break;
                return SearchDupLoadInstructionVisitor.visit(iai.values, dupStore);
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 268: 
            case 270: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not search DupLoad instruction in " + instruction.getClass().getName() + ", opcode=" + instruction.opcode);
            }
        }
        return null;
    }

    private static DupLoad visit(List<Instruction> instructions, DupStore dupStore) {
        int i = instructions.size() - 1;
        while (i >= 0) {
            DupLoad dupLoad = SearchDupLoadInstructionVisitor.visit(instructions.get(i), dupStore);
            if (dupLoad != null) {
                return dupLoad;
            }
            --i;
        }
        return null;
    }
}

