/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.client;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class RemoteLogHandlerBase
extends Handler {
    protected static final String WIRE_LOGGER_NAME = "WireActivityLogger";
    protected static Logger wireLogger = Logger.getLogger("WireActivityLogger");
    private boolean closed = false;
    private List<String> excludedLoggerNames;

    protected RemoteLogHandlerBase() {
        this.excludedLoggerNames = new ArrayList<String>();
        this.excludedLoggerNames.add(WIRE_LOGGER_NAME);
    }

    protected RemoteLogHandlerBase(List<String> excludedLoggerNames) {
        this.excludedLoggerNames = excludedLoggerNames;
        this.excludedLoggerNames.add(WIRE_LOGGER_NAME);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void flush() {
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return !this.closed && super.isLoggable(record) && !this.excludedLoggerNames.contains(record.getLoggerName());
    }
}

