/*
 * GNET-SNMP -- glib-based SNMP implementation
 *
 * Copyright (C) 2003 Juergen Schoenwaelder
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: utils.h 1992 2006-08-22 12:48:31Z schoenw $
 */

#ifndef __GNET_SNMP_UTILS_H__
#define __GNET_SNMP_UTILS_H__

/*
 * Return the gsnmp specific command line option group to be used with
 * the glib command line option parser.
 */

GOptionGroup *gnet_snmp_get_option_group ();

/*
 * Lexicographically compare two object identifiers oid1 and oid2 with
 * length len1 and len2 and return -1, 0 or 1 if oid1 is found to be
 * less than, to match or be greater than oid2.
 */

gint	gnet_snmp_compare_oids	(const guint32 *oid1, const gsize len1,
				 const guint32 *oid2, const gsize len2);

/*
 * Parse a string into an SNMP URI. This function also handles
 * abbreviated URIs.
 */

GURI*	gnet_snmp_parse_uri	(const gchar *string);

/*
 * Parse the query contained in 2nd element of a path of the snmp: URI
 * scheme. The path passed to this function is the full path of the
 * URI.
 */

typedef enum
{
    GNET_SNMP_URI_ERROR_NOOIDS,
    GNET_SNMP_URI_ERROR_TRAIL,
    GNET_SNMP_URI_ERROR_LPAREN,
    GNET_SNMP_URI_ERROR_RPAREN,
    GNET_SNMP_URI_ERROR_COMMA,
    GNET_SNMP_URI_ERROR_INT,
    GNET_SNMP_URI_ERROR_DOT,
    GNET_SNMP_URI_ERROR_STAR,
    GNET_SNMP_URI_ERROR_PLUS,
    GNET_SNMP_URI_ERROR_TOKEN,
    GNET_SNMP_URI_ERROR_EOF
} GNetSnmpUriError;

#define GNET_SNMP_URI_ERROR gnet_snmp_uri_error_quark()

GQuark	 gnet_snmp_uri_error_quark();

typedef enum
{
    GNET_SNMP_URI_GET,
    GNET_SNMP_URI_NEXT,
    GNET_SNMP_URI_WALK
} GNetSnmpUriType;

gboolean gnet_snmp_parse_path	(const gchar *path, GList **vbl,
				 GNetSnmpUriType *type,
				 GError **error);

/*
 * The following types and the associated functions are used to
 * map enumerated numbers to labels and vice versa.
 */

typedef struct _GNetSnmpEnum	 GNetSnmpEnum;
typedef struct _GNetSnmpIdentity GNetSnmpIdentity;

struct _GNetSnmpEnum {
    gint32 const number;
    gchar  const *label;
};

gchar const *
gnet_snmp_enum_get_label(GNetSnmpEnum const *table, gint32 const id);

gboolean
gnet_snmp_enum_get_number(GNetSnmpEnum const *table, gchar const *str,
			  gint32 *number);

struct _GNetSnmpIdentity {
    guint32 const *oid;
    gsize const oidlen;
    gchar const *label;
};

gchar const *
gnet_snmp_identity_get_label(GNetSnmpIdentity const *table,
			     guint32 const *oid, gsize oidlen);
guint32 *
gnet_snmp_identity_get_identity(GNetSnmpIdentity const *table,
				gchar const *str, gsize *oidlen);

/*
 * SNMP specific enumerations
 */

extern GNetSnmpEnum const gnet_snmp_enum_version_table[];
extern GNetSnmpEnum const gnet_snmp_enum_error_table[];
extern GNetSnmpEnum const gnet_snmp_enum_debug_table[];
extern GNetSnmpEnum const gnet_snmp_enum_tdomain_table[];
extern GNetSnmpEnum const gnet_snmp_enum_type_table[];
extern GNetSnmpEnum const gnet_snmp_enum_pdu_table[];

/*
 * The following utilities are used by the scli stubs generated by the
 * smidump MIB compiler.
 */

typedef enum
{
    GSNMP_ATTR_FLAG_WRITABLE	= 1 << 0,
    GSNMP_ATTR_FLAG_MASK	= 0x01
} GNetSnmpAttrFlags;

typedef struct {
    const guint32	    subid;	/* column/scalar subid */
    const GNetSnmpVarBindType  type;	/* SNMP type of the value */
    const gint              tag;	/* internal identification tag */
    const gchar            *label;	/* label (used for error reports) */
    const gpointer	    constraints;/* range or size constraints */
    const gint              val_offset;	/* offset for the value pointer */
    const gint		    len_offset;	/* offset for the length pointer */
    const GNetSnmpAttrFlags flags;	/* various flags, see above */
} GNetSnmpAttribute;

extern int gnet_snmp_attr_assign(GList *vbl,
				 guint32 const *base, size_t const len,
				 const GNetSnmpAttribute *attributes,
				 const gpointer p);

extern void gnet_snmp_attr_get(const GNetSnmp *s, GList **vbl,
			       guint32 *base, size_t const len,
			       guint const idx,
			       const GNetSnmpAttribute *attributes,
			       const gint64 mask);

extern void gnet_snmp_attr_set(const GNetSnmp *s, GList **vbl,
			       guint32 *base, size_t len,
			       guint const idx,
			       const GNetSnmpAttribute *attributes,
			       const gint64 mask,
			       const gpointer p);

#endif /* __GNET_SNMP_UTILS_H__ */
