/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack.migration;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndexUpgradeInfoRequest
extends MasterNodeReadRequest<IndexUpgradeInfoRequest>
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true);

    public IndexUpgradeInfoRequest(String ... indices) {
        this.indices(indices);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
    }

    public String[] indices() {
        return this.indices;
    }

    public IndexUpgradeInfoRequest indices(String ... indices) {
        this.indices = Objects.requireNonNull(indices, "indices cannot be null");
        return this;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public void indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IndexUpgradeInfoRequest request = (IndexUpgradeInfoRequest)((Object)o);
        return Arrays.equals(this.indices, request.indices) && Objects.equals(this.indicesOptions.toString(), request.indicesOptions.toString());
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.indicesOptions.toString());
    }
}

