/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ws.security.policy.WSS4JConfig;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.AsymmetricBinding;
import org.apache.ws.security.policy.model.Binding;
import org.apache.ws.security.policy.model.PolicyEngineData;
import org.apache.ws.security.policy.model.SymmetricBinding;
import org.apache.ws.security.policy.model.Wss10;
import org.apache.ws.security.policy.model.Wss11;

public class WSS4JConfigBuilder {
    public static void build(ArrayList topLevelPeds) throws WSSPolicyException {
        Iterator topLevelPEDIterator = topLevelPeds.iterator();
        WSS4JConfig config = new WSS4JConfig();
        while (topLevelPEDIterator.hasNext()) {
            PolicyEngineData ped = (PolicyEngineData)topLevelPEDIterator.next();
            if (ped instanceof Binding) {
                if (ped instanceof SymmetricBinding) {
                    WSS4JConfigBuilder.processSymmetricPolicyBinding((SymmetricBinding)ped, config);
                    continue;
                }
                WSS4JConfigBuilder.processAsymmetricPolicyBinding((AsymmetricBinding)ped, config);
                continue;
            }
            if (ped instanceof Wss10) {
                WSS4JConfigBuilder.processWSS10((Wss10)ped, config);
                continue;
            }
            if (!(ped instanceof Wss11)) continue;
            WSS4JConfigBuilder.processWSS11((Wss11)ped, config);
        }
    }

    private static void processSymmetricPolicyBinding(SymmetricBinding symmbinding, WSS4JConfig config) {
        throw new UnsupportedOperationException("TODO");
    }

    private static void processWSS10(Wss10 wss10, WSS4JConfig config) {
        throw new UnsupportedOperationException("TODO");
    }

    private static void processAsymmetricPolicyBinding(AsymmetricBinding binding, WSS4JConfig config) {
        throw new UnsupportedOperationException("TODO");
    }

    private static void processWSS11(Wss11 wss11, WSS4JConfig config) {
        if (wss11.isRequireSignatureConfirmation()) {
            // empty if block
        }
    }
}

