/*****
 NAME
 	plang.h - protocols for language
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(PLANG_H_INCLUDED)
#define PLANG_H_INCLUDED

#include <coconut/pset.h>
#include <coconut/pmath.h>
#include <coconut/perror.h>
#include <coconut/tlang.h>

@protocol PToken <PIdHashElm, PDebug>
  - (token_t) type ;

  - (error_code_t) errorCode ;
  - (id <PNumber>) number ;
  - (id <PConstStr>) string ;
  - (id <PConstStr>) ident ;
  - (id <PConstStr>) rwordStr ;
  - (int) rwordId ;

  - setErrorCode: (error_code_t) code ;
  - setNumber: (id <PNumber>) numobj ;
  - setString: (id <PConstStr>) strobj ;
  - setIdent: (id <PConstStr>) strobj ;
  - setRWord: (int) rid str: (id <PConstStr>) str ;
@end

@protocol PLangScopeBase <PDebug>
  - (id <PExpVar>) addVariable: (id <PExpVar>) var ;
  - (id <PExpVar>) searchVariable: (id <PConstStr>) name ;
@end

@protocol PLangScope <PLangScopeBase, PNode>
@end

@protocol PLangSystem <PDebug>
  /* do not release (and deallocate) the objects generated by these
     methods */
  - (id <PToken>) errorToken ;
  - (id <PToken>) doubleToken: (double) dvalue ;
  - (id <PToken>) intToken: (int) ivalue ;
  - (id <PToken>) strToken: (const utf8_char *) str ;
  - (id <PToken>) identToken: (const utf8_char *) str ;

  - (id <PToken>) addReservedWord: (int) rid name: (const utf8_char *) name ;
  - (id <PToken>) searchReservedWord: (const char *) text ;

  - (id <PLangScope>) currentScope ;
  - append ;
  - push ;
  - pop ;
@end

@protocol PLangFactory
+ (id <PLangSystem>) langSystem ;
@end

#endif /* !defined(PLANG_H_INCLUDED) */

