/*
 * Decompiled with CFR 0.152.
 */
package jaligner;

import java.io.Serializable;

public class Sequence
implements Serializable {
    private static final long serialVersionUID = 3256721801357898297L;
    public static final int NUCLEIC = 0;
    public static final int PROTEIN = 1;
    private String sequence;
    private String id = null;
    private String description = null;
    private int type = 1;

    public Sequence() {
    }

    public Sequence(String sequence) {
        this.sequence = sequence;
    }

    public Sequence(String name, char[] sequence) {
        this.id = name;
        this.sequence = new String(sequence);
    }

    public Sequence(String name, String sequence) {
        this.id = name;
        this.sequence = sequence;
    }

    public Sequence(String sequence, String id, String description, int type) {
        this.sequence = sequence;
        this.id = id;
        this.description = description;
        this.type = type;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int length() {
        return this.sequence.length();
    }

    public String subsequence(int index, int length) {
        return this.sequence.substring(index, index + length);
    }

    public char acidAt(int index) {
        return this.sequence.charAt(index);
    }

    public char[] toArray() {
        return this.sequence.toCharArray();
    }

    public String toString() {
        return this.id + "\t" + this.sequence;
    }
}

