/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CollectPreconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CollectSpliterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multiset;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multiset$Entry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multisets$5;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multisets$ImmutableEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multisets$MultisetIteratorImpl;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Spliterator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Multisets {
    public static Multiset$Entry immutableEntry(@NullableDecl Object object, int n) {
        return new Multisets$ImmutableEntry(object, n);
    }

    static boolean equalsImpl(Multiset multiset, @NullableDecl Object object) {
        if (object == multiset) {
            return true;
        }
        if (object instanceof Multiset) {
            Multiset multiset2 = (Multiset)object;
            if (multiset.size() != multiset2.size() || multiset.entrySet().size() != multiset2.entrySet().size()) {
                return false;
            }
            for (Multiset$Entry multiset$Entry : multiset2.entrySet()) {
                if (multiset.count(multiset$Entry.getElement()) == multiset$Entry.getCount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static boolean addAllImpl(Multiset multiset, Collection collection) {
        Preconditions.checkNotNull(multiset);
        Preconditions.checkNotNull(collection);
        if (collection instanceof Multiset) {
            return Multisets.addAllImpl(multiset, Multisets.cast(collection));
        }
        if (collection.isEmpty()) {
            return false;
        }
        return Iterators.addAll(multiset, collection.iterator());
    }

    private static boolean addAllImpl(Multiset multiset, Multiset multiset2) {
        if (multiset2.isEmpty()) {
            return false;
        }
        multiset2.forEachEntry(multiset::add);
        return true;
    }

    static boolean removeAllImpl(Multiset multiset, Collection collection) {
        Collection collection2 = collection instanceof Multiset ? ((Multiset)collection).elementSet() : collection;
        return multiset.elementSet().removeAll(collection2);
    }

    static boolean retainAllImpl(Multiset multiset, Collection collection) {
        Preconditions.checkNotNull(collection);
        Collection collection2 = collection instanceof Multiset ? ((Multiset)collection).elementSet() : collection;
        return multiset.elementSet().retainAll(collection2);
    }

    static int setCountImpl(Multiset multiset, Object object, int n) {
        CollectPreconditions.checkNonnegative(n, "count");
        int n2 = multiset.count(object);
        int n3 = n - n2;
        if (n3 > 0) {
            multiset.add(object, n3);
        } else if (n3 < 0) {
            multiset.remove(object, -n3);
        }
        return n2;
    }

    static boolean setCountImpl(Multiset multiset, Object object, int n, int n2) {
        CollectPreconditions.checkNonnegative(n, "oldCount");
        CollectPreconditions.checkNonnegative(n2, "newCount");
        if (multiset.count(object) == n) {
            multiset.setCount(object, n2);
            return true;
        }
        return false;
    }

    static Iterator elementIterator(Iterator iterator) {
        return new Multisets$5(iterator);
    }

    static Iterator iteratorImpl(Multiset multiset) {
        return new Multisets$MultisetIteratorImpl(multiset, multiset.entrySet().iterator());
    }

    static Spliterator spliteratorImpl(Multiset multiset) {
        Spliterator spliterator = multiset.entrySet().spliterator();
        return CollectSpliterators.flatMap(spliterator, multiset$Entry -> Collections.nCopies(multiset$Entry.getCount(), multiset$Entry.getElement()).spliterator(), 0x40 | spliterator.characteristics() & 0x510, multiset.size());
    }

    static int linearTimeSizeImpl(Multiset multiset) {
        long l = 0L;
        for (Multiset$Entry multiset$Entry : multiset.entrySet()) {
            l += (long)multiset$Entry.getCount();
        }
        return Ints.saturatedCast(l);
    }

    static Multiset cast(Iterable iterable) {
        return (Multiset)iterable;
    }
}

