/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public final class CString
extends RecordAtom {
    private static final int MAX_RECORD_LENGTH = 1000000;
    private byte[] _header;
    private byte[] _text;

    public String getText() {
        return StringUtil.getFromUnicodeLE((byte[])this._text);
    }

    public void setText(String text) {
        this._text = new byte[text.length() * 2];
        StringUtil.putUnicodeLE((String)text, (byte[])this._text, (int)0);
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._text.length);
    }

    public int getOptions() {
        return LittleEndian.getShort((byte[])this._header);
    }

    public void setOptions(int count) {
        LittleEndian.putShort((byte[])this._header, (int)0, (short)((short)count));
    }

    protected CString(byte[] source, int start, int len) {
        if (len < 8) {
            len = 8;
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._text = IOUtils.safelyAllocate((long)(len - 8), (int)1000000);
        System.arraycopy(source, start + 8, this._text, 0, len - 8);
    }

    public CString() {
        this._header = new byte[]{0, 0, -70, 15, 0, 0, 0, 0};
        this._text = new byte[0];
    }

    @Override
    public long getRecordType() {
        return RecordTypes.CString.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._text);
    }

    public String toString() {
        return this.getText();
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties((String)"text", this::getText);
    }
}

