/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class BooleanTypeCompiler
extends BaseTypeCompiler {
    public boolean convertible(TypeId typeId, boolean bl) {
        return typeId.isStringTypeId() || typeId.isBooleanTypeId();
    }

    public boolean compatible(TypeId typeId) {
        return this.convertible(typeId, false);
    }

    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        if (typeId.isBooleanTypeId() || typeId.isStringTypeId()) {
            return true;
        }
        return this.userTypeStorable(this.getTypeId(), typeId, classFactory);
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.BooleanDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        return "boolean";
    }

    public String getPrimitiveMethodName() {
        return "getBoolean";
    }

    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return 5;
    }

    String nullMethodName() {
        return "getNullBoolean";
    }
}

