/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import kafka.common.InvalidConfigException;
import kafka.consumer.ConsumerConfig$;
import kafka.producer.ProducerConfig$;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000152A!\u0001\u0002\u0001\u000f\tQ1i\u001c8gS\u001e$Vm\u001d;\u000b\u0005\r!\u0011AB2p[6|gNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0003\u0015\u0001\u0011\u0005Q#\u0001\u000buKN$\u0018J\u001c<bY&$7\t\\5f]RLEm\u001d\u000b\u0002-A\u0011\u0011bF\u0005\u00031)\u0011A!\u00168ji\"\"1CG\u000f !\tI1$\u0003\u0002\u001d\u0015\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0003y\t1\t\u00165jg\u0002\"Xm\u001d;!SN\u0004C-\u001a9sK\u000e\fG/\u001a3!C:$\u0007%\u001b;!o&dG\u000e\t2fAI,Wn\u001c<fI\u0002Jg\u000eI1!MV$XO]3!e\u0016dW-Y:f]\u0005\n\u0001%\u0001\u00051]E\u0002d\u0006\r\u00181Q\t\u0019\"\u0005\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005)!.\u001e8ji*\tq%A\u0002pe\u001eL!!\u000b\u0013\u0003\tQ+7\u000f\u001e\u0005\u0006W\u0001!\t!F\u0001\u0014i\u0016\u001cH/\u00138wC2LGm\u0012:pkBLEm\u001d\u0015\u0003U\t\u0002")
public class ConfigTest {
    @Test
    public void testInvalidClientIds() {
        ArrayBuffer invalidClientIds = new ArrayBuffer();
        Object[] badChars = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)'/'), BoxesRunTime.boxToCharacter((char)'\\'), BoxesRunTime.boxToCharacter((char)','), BoxesRunTime.boxToCharacter((char)'\u0000'), BoxesRunTime.boxToCharacter((char)':'), "\"", BoxesRunTime.boxToCharacter((char)'\''), BoxesRunTime.boxToCharacter((char)';'), BoxesRunTime.boxToCharacter((char)'*'), BoxesRunTime.boxToCharacter((char)'?'), BoxesRunTime.boxToCharacter((char)' '), BoxesRunTime.boxToCharacter((char)'\t'), BoxesRunTime.boxToCharacter((char)'\r'), BoxesRunTime.boxToCharacter((char)'\n'), BoxesRunTime.boxToCharacter((char)'=')}), ClassTag$.MODULE$.Any());
        Predef$.MODULE$.genericArrayOps((Object)badChars).foreach((Function1 & java.io.Serializable & Serializable)weirdChar -> invalidClientIds.$plus$eq((Object)("Is" + weirdChar + "illegal")));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), invalidClientIds.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            try {
                ProducerConfig$.MODULE$.validateClientId((String)invalidClientIds.apply(i));
                Assert.fail((String)"Should throw InvalidClientIdException.");
            }
            catch (InvalidConfigException invalidConfigException) {}
        });
        ArrayBuffer validClientIds = new ArrayBuffer();
        validClientIds.$plus$eq((Object)"valid", (Object)"CLIENT", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"iDs", "ar6", "VaL1d", "_0-9_.", ""}));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), validClientIds.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            try {
                ProducerConfig$.MODULE$.validateClientId((String)validClientIds.apply(i));
            }
            catch (Exception exception) {
                Assert.fail((String)"Should not throw exception.");
            }
        });
    }

    @Test
    public void testInvalidGroupIds() {
        ArrayBuffer invalidGroupIds = new ArrayBuffer();
        Object[] badChars = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)'/'), BoxesRunTime.boxToCharacter((char)'\\'), BoxesRunTime.boxToCharacter((char)','), BoxesRunTime.boxToCharacter((char)'\u0000'), BoxesRunTime.boxToCharacter((char)':'), "\"", BoxesRunTime.boxToCharacter((char)'\''), BoxesRunTime.boxToCharacter((char)';'), BoxesRunTime.boxToCharacter((char)'*'), BoxesRunTime.boxToCharacter((char)'?'), BoxesRunTime.boxToCharacter((char)' '), BoxesRunTime.boxToCharacter((char)'\t'), BoxesRunTime.boxToCharacter((char)'\r'), BoxesRunTime.boxToCharacter((char)'\n'), BoxesRunTime.boxToCharacter((char)'=')}), ClassTag$.MODULE$.Any());
        Predef$.MODULE$.genericArrayOps((Object)badChars).foreach((Function1 & java.io.Serializable & Serializable)weirdChar -> invalidGroupIds.$plus$eq((Object)("Is" + weirdChar + "illegal")));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), invalidGroupIds.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            try {
                ConsumerConfig$.MODULE$.validateGroupId((String)invalidGroupIds.apply(i));
                Assert.fail((String)"Should throw InvalidGroupIdException.");
            }
            catch (InvalidConfigException invalidConfigException) {}
        });
        ArrayBuffer validGroupIds = new ArrayBuffer();
        validGroupIds.$plus$eq((Object)"valid", (Object)"GROUP", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"iDs", "ar6", "VaL1d", "_0-9_.", ""}));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), validGroupIds.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            try {
                ConsumerConfig$.MODULE$.validateGroupId((String)validGroupIds.apply(i));
            }
            catch (Exception exception) {
                Assert.fail((String)"Should not throw exception.");
            }
        });
    }
}

