/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class GtkTableHeaderRenderer
extends DefaultTableCellRenderer
implements UIResource {
    boolean isSelected;
    boolean hasFocus;
    transient DefaultButton itemSelected;
    transient DefaultButton itemUnselected;

    public GtkTableHeaderRenderer(DefaultButton itemSelected, DefaultButton itemUnselected) {
        this.setOpaque(false);
        this.itemSelected = itemSelected;
        this.itemUnselected = itemUnselected;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }
        this.isSelected = isSelected;
        this.hasFocus = hasFocus;
        this.setText(value == null ? "" : value.toString());
        Insets insets = isSelected || hasFocus ? this.itemSelected.getInsets() : this.itemUnselected.getInsets();
        this.setBorder(new EmptyBorder(insets));
        return this;
    }

    protected void paintComponent(Graphics g) {
        if (this.isSelected || this.hasFocus) {
            this.itemSelected.paint(g, this);
        } else {
            this.itemUnselected.paint(g, this);
        }
        super.paintComponent(g);
    }
}

