/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.action.GetAutoFollowPatternAction;

public class TransportGetAutoFollowPatternAction
extends TransportMasterNodeReadAction<GetAutoFollowPatternAction.Request, GetAutoFollowPatternAction.Response> {
    @Inject
    public TransportGetAutoFollowPatternAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/xpack/ccr/auto_follow_pattern/get", transportService, clusterService, threadPool, actionFilters, GetAutoFollowPatternAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected GetAutoFollowPatternAction.Response newResponse() {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    protected GetAutoFollowPatternAction.Response read(StreamInput in) throws IOException {
        return new GetAutoFollowPatternAction.Response(in);
    }

    protected void masterOperation(GetAutoFollowPatternAction.Request request, ClusterState state, ActionListener<GetAutoFollowPatternAction.Response> listener) throws Exception {
        Map<String, AutoFollowMetadata.AutoFollowPattern> autoFollowPatterns = TransportGetAutoFollowPatternAction.getAutoFollowPattern(state.metaData(), request.getName());
        listener.onResponse((Object)new GetAutoFollowPatternAction.Response(autoFollowPatterns));
    }

    protected ClusterBlockException checkBlock(GetAutoFollowPatternAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    static Map<String, AutoFollowMetadata.AutoFollowPattern> getAutoFollowPattern(MetaData metaData, String name) {
        AutoFollowMetadata autoFollowMetadata = (AutoFollowMetadata)metaData.custom("ccr_auto_follow");
        if (autoFollowMetadata == null) {
            if (name == null) {
                return Collections.emptyMap();
            }
            throw new ResourceNotFoundException("auto-follow pattern [{}] is missing", new Object[]{name});
        }
        if (name == null) {
            return autoFollowMetadata.getPatterns();
        }
        AutoFollowMetadata.AutoFollowPattern autoFollowPattern = (AutoFollowMetadata.AutoFollowPattern)autoFollowMetadata.getPatterns().get(name);
        if (autoFollowPattern == null) {
            throw new ResourceNotFoundException("auto-follow pattern [{}] is missing", new Object[]{name});
        }
        return Collections.singletonMap(name, autoFollowPattern);
    }
}

