/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ChangelogEntryIntermediateResponse;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetChangelogBatchExtendedResult
extends ExtendedResult {
    private static final byte TYPE_RESUME_TOKEN = -128;
    private static final byte TYPE_MORE_CHANGES_AVAILABLE = -127;
    private static final byte TYPE_CHANGES_ALREADY_PURGED = -126;
    private static final byte TYPE_ADDITIONAL_INFO = -125;
    private static final byte TYPE_ESTIMATED_CHANGES_REMAINING = -124;
    private static final long serialVersionUID = -1997815252100989148L;
    private final ASN1OctetString resumeToken;
    private final boolean changesAlreadyPurged;
    private final boolean moreChangesAvailable;
    private final int estimatedChangesRemaining;
    private final int entryCount;
    private final List<ChangelogEntryIntermediateResponse> entryList;
    private final String additionalInfo;

    public GetChangelogBatchExtendedResult(LDAPResult r) {
        super(r.getMessageID(), r.getResultCode(), r.getDiagnosticMessage(), r.getMatchedDN(), r.getReferralURLs(), null, null, r.getResponseControls());
        this.resumeToken = null;
        this.changesAlreadyPurged = false;
        this.moreChangesAvailable = false;
        this.estimatedChangesRemaining = -1;
        this.entryCount = -1;
        this.entryList = null;
        this.additionalInfo = null;
    }

    public GetChangelogBatchExtendedResult(LDAPResult r, int entryCount, ASN1OctetString resumeToken, boolean moreChangesAvailable, boolean changesAlreadyPurged, String additionalInfo) {
        this(r, entryCount, resumeToken, moreChangesAvailable, -1, changesAlreadyPurged, additionalInfo);
    }

    public GetChangelogBatchExtendedResult(LDAPResult r, int entryCount, ASN1OctetString resumeToken, boolean moreChangesAvailable, int estimatedChangesRemaining, boolean changesAlreadyPurged, String additionalInfo) {
        super(r.getMessageID(), r.getResultCode(), r.getDiagnosticMessage(), r.getMatchedDN(), r.getReferralURLs(), null, GetChangelogBatchExtendedResult.encodeValue(resumeToken, moreChangesAvailable, estimatedChangesRemaining, changesAlreadyPurged, additionalInfo), r.getResponseControls());
        this.resumeToken = resumeToken;
        this.moreChangesAvailable = moreChangesAvailable;
        this.changesAlreadyPurged = changesAlreadyPurged;
        this.additionalInfo = additionalInfo;
        this.estimatedChangesRemaining = estimatedChangesRemaining >= 0 ? estimatedChangesRemaining : -1;
        this.entryList = null;
        this.entryCount = entryCount < 0 ? -1 : entryCount;
    }

    public GetChangelogBatchExtendedResult(ExtendedResult extendedResult, int entryCount) throws LDAPException {
        this(extendedResult, entryCount, null);
    }

    public GetChangelogBatchExtendedResult(ExtendedResult extendedResult, List<ChangelogEntryIntermediateResponse> entryList) throws LDAPException {
        this(extendedResult, entryList.size(), entryList);
    }

    private GetChangelogBatchExtendedResult(ExtendedResult r, int entryCount, List<ChangelogEntryIntermediateResponse> entryList) throws LDAPException {
        super(r);
        ASN1Element[] valueElements;
        this.entryList = entryList == null ? null : Collections.unmodifiableList(entryList);
        this.entryCount = entryCount < 0 ? -1 : entryCount;
        ASN1OctetString value = r.getValue();
        if (value == null) {
            this.resumeToken = entryList != null && !entryList.isEmpty() ? entryList.get(entryList.size() - 1).getResumeToken() : null;
            this.moreChangesAvailable = false;
            this.estimatedChangesRemaining = -1;
            this.changesAlreadyPurged = false;
            this.additionalInfo = null;
            return;
        }
        try {
            valueElements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_CHANGELOG_BATCH_RES_VALUE_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        ASN1OctetString token = null;
        Boolean moreChanges = null;
        boolean missingChanges = false;
        int changesRemaining = -1;
        String message = null;
        try {
            block12: for (ASN1Element e : valueElements) {
                byte type = e.getType();
                switch (type) {
                    case -128: {
                        token = ASN1OctetString.decodeAsOctetString(e);
                        continue block12;
                    }
                    case -127: {
                        moreChanges = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block12;
                    }
                    case -126: {
                        missingChanges = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block12;
                    }
                    case -125: {
                        message = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block12;
                    }
                    case -124: {
                        changesRemaining = ASN1Integer.decodeAsInteger(e).intValue();
                        if (changesRemaining >= 0) continue block12;
                        changesRemaining = -1;
                        continue block12;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_CHANGELOG_BATCH_RES_UNEXPECTED_VALUE_ELEMENT.get(StaticUtils.toHex(type)));
                    }
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_CHANGELOG_BATCH_RES_ERROR_PARSING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (moreChanges == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_CHANGELOG_BATCH_RES_MISSING_MORE.get());
        }
        this.resumeToken = token;
        this.moreChangesAvailable = moreChanges;
        this.changesAlreadyPurged = missingChanges;
        this.estimatedChangesRemaining = changesRemaining;
        this.additionalInfo = message;
    }

    private static ASN1OctetString encodeValue(ASN1OctetString resumeToken, boolean moreChangesAvailable, int estimatedChangesRemaining, boolean changesAlreadyPurged, String additionalInfo) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(5);
        if (resumeToken != null) {
            elements.add(new ASN1OctetString(-128, resumeToken.getValue()));
        }
        elements.add(new ASN1Boolean(-127, moreChangesAvailable));
        if (estimatedChangesRemaining >= 0) {
            elements.add(new ASN1Integer(-124, estimatedChangesRemaining));
        }
        if (changesAlreadyPurged) {
            elements.add(new ASN1Boolean(-126, changesAlreadyPurged));
        }
        if (additionalInfo != null) {
            elements.add(new ASN1OctetString(-125, additionalInfo));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public ASN1OctetString getResumeToken() {
        return this.resumeToken;
    }

    public boolean moreChangesAvailable() {
        return this.moreChangesAvailable;
    }

    public int getEstimatedChangesRemaining() {
        return this.estimatedChangesRemaining;
    }

    public boolean changesAlreadyPurged() {
        return this.changesAlreadyPurged;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public List<ChangelogEntryIntermediateResponse> getChangelogEntries() {
        return this.entryList;
    }

    @Override
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_GET_CHANGELOG_BATCH_RES_NAME.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("ExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(referralURLs[i]);
            }
            buffer.append('}');
        }
        if (this.resumeToken != null) {
            buffer.append(", resumeToken='");
            Base64.encode(this.resumeToken.getValue(), buffer);
            buffer.append('\'');
        }
        buffer.append(", moreChangesAvailable=");
        buffer.append(this.moreChangesAvailable);
        buffer.append(", estimatedChangesRemaining=");
        buffer.append(this.estimatedChangesRemaining);
        buffer.append(", changesAlreadyPurged=");
        buffer.append(this.changesAlreadyPurged);
        if (this.additionalInfo != null) {
            buffer.append(", additionalInfo='");
            buffer.append(this.additionalInfo);
            buffer.append('\'');
        }
        buffer.append(", entryCount=");
        buffer.append(this.entryCount);
        Control[] responseControls = this.getResponseControls();
        if (responseControls.length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

