/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsRequest;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;

public class RestWatcherStatsAction
extends WatcherRestHandler {
    private static final Logger logger = LogManager.getLogger(RestWatcherStatsAction.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
    private static final Set<String> RESPONSE_PARAMS = Collections.singleton("emit_stacktraces");

    public RestWatcherStatsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, URI_BASE + "/stats", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_watcher/stats", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, URI_BASE + "/stats/{metric}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_watcher/stats/{metric}", (RestHandler)this);
    }

    public String getName() {
        return "xpack_watcher_stats_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest restRequest, WatcherClient client) throws IOException {
        Set metrics = Strings.tokenizeByCommaToSet((String)restRequest.param("metric", ""));
        WatcherStatsRequest request = new WatcherStatsRequest();
        if (metrics.contains("_all")) {
            request.includeCurrentWatches(true);
            request.includeQueuedWatches(true);
        } else {
            request.includeCurrentWatches(metrics.contains("current_watches"));
            request.includeQueuedWatches(metrics.contains("queued_watches") || metrics.contains("pending_watches"));
        }
        if (metrics.contains("pending_watches")) {
            deprecationLogger.deprecated("The pending_watches parameter is deprecated, use queued_watches instead", new Object[0]);
        }
        return channel -> client.watcherStats(request, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

