/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.vmconversion;

import com.amazon.aes.webservices.client.vmconversion.InternalException;
import com.amazon.aes.webservices.client.vmconversion.Location;
import com.amazon.aes.webservices.client.vmconversion.Md5SumMismatchException;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import com.amazon.aes.webservices.client.vmconversionschema.ByteRange;
import com.amazon.aes.webservices.client.vmconversionschema.Import;
import com.amazon.aes.webservices.client.vmconversionschema.Importer;
import com.amazon.aes.webservices.client.vmconversionschema.Manifest;
import com.amazon.aes.webservices.client.vmconversionschema.Part;
import com.amazon.aes.webservices.client.vmconversionschema.Parts;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.utils.ServiceUtils;
import org.xml.sax.SAXException;

public class ManifestFactory {
    protected S3Service s3Service;
    public static final String MANIFEST_SUFFIX = "manifest.xml";

    public ManifestFactory(S3Service s3Service) {
        this.s3Service = s3Service;
    }

    private String getKeyPrefix(String userPrefix, File file) {
        StringBuilder keyPrefix = new StringBuilder();
        if (userPrefix != null) {
            keyPrefix.append(userPrefix);
            if (!userPrefix.endsWith("/")) {
                keyPrefix.append('/');
            }
        }
        keyPrefix.append(UUID.randomUUID().toString() + "/");
        keyPrefix.append(file.getName());
        return keyPrefix.toString();
    }

    public boolean verifyRegionAffinity(Location desiredLocation, String bucketName, boolean verifyLocation) throws VerificationException, S3ServiceException {
        String bucketLocation;
        Location actualLocation;
        if (verifyLocation && !(actualLocation = Location.fromS3Value(bucketLocation = this.s3Service.getBucketLocation(bucketName))).equals(desiredLocation)) {
            throw new VerificationException("Bucket " + bucketName + " is not in the " + bucketLocation + " region");
        }
        return true;
    }

    public String createSignedManifestUrl(File file, String bucketName, Location location, String userPrefix, int expirationDays, boolean verifyLocation) throws S3ServiceException, VerificationException {
        String keyPrefix = this.getKeyPrefix(userPrefix, file);
        S3Bucket bucket = this.s3Service.getOrCreateBucket(bucketName, location.getS3Value());
        this.verifyRegionAffinity(location, bucketName, verifyLocation);
        String signedUrl = this.getManifestS3Object(bucket, keyPrefix + MANIFEST_SUFFIX, expirationDays);
        return signedUrl;
    }

    public String createSignedManifestUrl(File file, URL manifestUrl, Location location, int expirationDays, boolean verifyLocation) throws S3ServiceException, VerificationException {
        S3Object manifestS3Object = ManifestFactory.getManifestS3Object(manifestUrl);
        String bucketName = manifestS3Object.getBucketName();
        String keyPrefix = ManifestFactory.getKeyPrefixFromManifest(manifestS3Object.getKey());
        if (keyPrefix.length() < 1) {
            throw new VerificationException("Cannot determine manifest object from URL " + manifestUrl.toExternalForm());
        }
        S3Bucket bucket = this.s3Service.getOrCreateBucket(bucketName, location.getS3Value());
        this.verifyRegionAffinity(location, bucketName, verifyLocation);
        String signedUrl = this.getManifestS3Object(bucket, keyPrefix + MANIFEST_SUFFIX, expirationDays);
        return signedUrl;
    }

    private String getManifestS3Object(S3Bucket bucket, String manifestPrefix, int expirationDays) throws S3ServiceException {
        S3Object manifestS3Object = new S3Object(bucket, manifestPrefix);
        Calendar cal = Calendar.getInstance();
        cal.add(5, expirationDays);
        Date signedUrlExpiration = cal.getTime();
        String signedUrl = this.s3Service.createSignedGetUrl(bucket.getName(), manifestS3Object.getKey(), signedUrlExpiration);
        return signedUrl;
    }

    public static S3Object getManifestS3Object(URL manifestUrl) {
        S3Object manifestS3Object = null;
        try {
            manifestS3Object = ServiceUtils.buildObjectFromUrl((String)manifestUrl.getHost(), (String)manifestUrl.getPath(), (String)Constants.S3_DEFAULT_HOSTNAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return manifestS3Object;
    }

    public static String getBucketName(S3Object manifestS3Object) {
        if (manifestS3Object == null) {
            System.out.println("Bug Bug null manifest object");
            System.exit(-1);
        }
        return manifestS3Object.getBucketName();
    }

    public Manifest createManifestUnlessExists(URL manifestUrl, File file, String fileFormat, long volumeSize, long partSize, int expirationDays, boolean dryRun) throws VerificationException, InternalException {
        S3Object manifestS3Object = ManifestFactory.getManifestS3Object(manifestUrl);
        String bucketName = manifestS3Object.getBucketName();
        Manifest manifest = null;
        boolean manifestExists = false;
        try {
            manifestExists = this.s3Service.isObjectInBucket(bucketName, manifestS3Object.getKey());
        }
        catch (ServiceException e) {
            String msg = e.getErrorMessage();
            throw new InternalException("Cannot determine if manifest file exists. " + msg);
        }
        if (dryRun && !manifestExists) {
            return null;
        }
        if (!manifestExists) {
            System.out.println("Creating new manifest at " + bucketName + "/" + manifestS3Object.getKey());
            String keyPrefix = ManifestFactory.getKeyPrefixFromManifest(manifestS3Object.getKey());
            try {
                manifest = this.createAndUploadManifest(file, fileFormat, manifestS3Object, keyPrefix, volumeSize, partSize, expirationDays);
            }
            catch (Exception e) {
                String msg = e.getMessage() == null ? "" : e.getMessage();
                throw new InternalException("Error uploading manifest file. " + msg);
            }
        }
        try {
            S3Object oldManifest = this.s3Service.getObject(manifestS3Object.getBucketName(), manifestS3Object.getKey());
            manifest = this.loadExistingManifest(oldManifest);
            this.verifyManifest(manifest, file, fileFormat, volumeSize);
        }
        catch (Exception e) {
            if (e instanceof VerificationException) {
                throw (VerificationException)e;
            }
            String msg = e.getMessage() == null ? "" : e.getMessage();
            throw new InternalException("Error downloading manifest file. " + msg);
        }
        return manifest;
    }

    private void verifyManifest(Manifest manifest, File file, String fileFormat, long volumeSize) throws VerificationException {
        if (!manifest.getFileFormat().equalsIgnoreCase(fileFormat)) {
            throw new VerificationException("The file format in the manifest is " + manifest.getFileFormat() + ". The expected format is " + fileFormat);
        }
        if (manifest.getImport().getSize() != file.length()) {
            throw new VerificationException("The file size in the manifest is " + manifest.getImport().getSize() + ". The expected file size is " + file.length());
        }
        if (manifest.getImport().getVolumeSize() != volumeSize) {
            throw new VerificationException("The volume size in the manifest is " + manifest.getImport().getVolumeSize() + ". The expected volume size is " + volumeSize);
        }
    }

    public static String getKeyPrefixFromManifest(String key) {
        String keyPrefix = key;
        if (key.endsWith(MANIFEST_SUFFIX)) {
            keyPrefix = key.substring(0, key.length() - MANIFEST_SUFFIX.length());
        }
        return keyPrefix;
    }

    protected Manifest createAndUploadManifest(File file, String fileFormat, S3Object manifestS3Object, String keyPrefix, long volumeSize, long partSize, int expirationDays) throws IOException, JAXBException, NoSuchAlgorithmException, ServiceException {
        Calendar cal = Calendar.getInstance();
        cal.add(5, expirationDays);
        Date signedUrlExpiration = cal.getTime();
        Manifest manifest = this.createNewManifest(file, fileFormat, manifestS3Object, keyPrefix, volumeSize, partSize, signedUrlExpiration);
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.amazon.aes.webservices.client.vmconversionschema");
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter manifestContents = new StringWriter();
        marshaller.marshal((Object)manifest, (Writer)manifestContents);
        System.out.println("Uploading the manifest file");
        this.s3Service.putObject(manifestS3Object.getBucketName(), new S3Object(manifestS3Object.getKey(), manifestContents.toString()));
        return manifest;
    }

    public Manifest createNewManifest(File file, String fileFormat, S3Object manifestS3Object, String keyPrefix, long volumeSize, long partSize, Date signedUrlExpiration) throws IOException, S3ServiceException {
        Importer importer = new Importer();
        importer.setName("ec2-upload-disk-image");
        importer.setVersion("1.0.0");
        importer.setRelease("2010-11-15");
        Manifest manifest = new Manifest();
        manifest.setVersion("2010-11-15");
        manifest.setFileFormat(fileFormat);
        manifest.setImporter(importer);
        manifest.setSelfDestructUrl(this.s3Service.createSignedDeleteUrl(manifestS3Object.getBucketName(), manifestS3Object.getKey(), signedUrlExpiration));
        manifest.setImport(this.createImport(file, manifestS3Object.getBucketName(), keyPrefix, partSize, volumeSize, signedUrlExpiration));
        return manifest;
    }

    private Import createImport(File file, String bucketName, String keyPrefix, long partSize, long volumeSize, Date signedUrlExpiration) throws S3ServiceException {
        int partCount = (int)Math.ceil((double)file.length() / (double)partSize);
        Parts parts = new Parts();
        parts.setCount(partCount);
        for (int i = 0; i < partCount; ++i) {
            Part part = new Part();
            parts.getPart().add(part);
            part.setIndex(i);
            long start = (long)i * partSize;
            long end = (long)(i + 1) * partSize - 1L;
            if (end >= file.length()) {
                end = file.length() - 1L;
            }
            ByteRange byteRange = new ByteRange();
            byteRange.setStart(start);
            byteRange.setEnd(end);
            part.setByteRange(byteRange);
            String key = keyPrefix + ".part" + i;
            part.setKey(key);
            part.setHeadUrl(this.s3Service.createSignedHeadUrl(bucketName, key, signedUrlExpiration));
            part.setGetUrl(this.s3Service.createSignedGetUrl(bucketName, key, signedUrlExpiration));
            part.setDeleteUrl(this.s3Service.createSignedDeleteUrl(bucketName, key, signedUrlExpiration));
        }
        Import importt = new Import();
        importt.setSize(file.length());
        importt.setVolumeSize(volumeSize);
        importt.setParts(parts);
        return importt;
    }

    public Manifest loadExistingManifest(S3Object manifestS3Object) throws IOException, JAXBException, ServiceException, NoSuchAlgorithmException, Md5SumMismatchException {
        StringBuilder manifestContents = new StringBuilder();
        char[] buff = new char[65536];
        int bytesRead = -1;
        BufferedReader reader = new BufferedReader(new InputStreamReader(manifestS3Object.getDataInputStream(), Constants.DEFAULT_ENCODING));
        while ((bytesRead = reader.read(buff, 0, buff.length)) != -1) {
            manifestContents.append(buff, 0, bytesRead);
        }
        manifestS3Object.closeDataInputStream();
        MessageDigest digg2 = MessageDigest.getInstance("MD5");
        digg2.update(manifestContents.toString().getBytes(Constants.DEFAULT_ENCODING));
        byte[] myDigest = digg2.digest();
        String myMd5Sum = ServiceUtils.toBase64((byte[])myDigest);
        String objectMd5 = manifestS3Object.getMd5HashAsBase64();
        if (!myMd5Sum.equals(objectMd5)) {
            throw new Md5SumMismatchException("MD5 hash verfication failed for the downloaded manifest");
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.amazon.aes.webservices.client.vmconversionschema");
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = schemaFactory.newSchema(this.getClass().getClassLoader().getResource("ImportManifest.xsd"));
            unmarshaller.setSchema(schema);
        }
        catch (SAXException e) {
            throw new JAXBException((Throwable)e);
        }
        return (Manifest)unmarshaller.unmarshal((Reader)new StringReader(manifestContents.toString()));
    }
}

