/* Default linker script, for normal executables */
OUTPUT_FORMAT("mmo")
OUTPUT_ARCH(mmix)
ENTRY(Main)
SECTIONS
{
  .text  DEFINED (__.MMIX.start..text) ? __.MMIX.start..text : 0:
  {
    *(.text)
    *(.text.*)
    *(.gnu.linkonce.t*)
    *(.rodata)
    *(.rodata.*)
    *(.gnu.linkonce.r*)
    /* FIXME: Move .init, .fini, .ctors and .dtors to their own sections.  */
     PROVIDE (_init_start = .);
     PROVIDE (_init = .);
     KEEP (*(.init))
     PROVIDE (_init_end = .);
     PROVIDE (_fini_start = .);
     PROVIDE (_fini = .);
     KEEP (*(.fini))
     PROVIDE (_fini_end = .);
    /* FIXME: Align ctors, dtors, ehframe.  */
     PROVIDE (_ctors_start = .);
     PROVIDE (__ctors_start = .);
     PROVIDE (_ctors = .);
     PROVIDE (__ctors = .);
     KEEP (*crtbegin*.o(.ctors))
     KEEP (*(EXCLUDE_FILE (*crtend*.o) .ctors))
     KEEP (*(SORT(.ctors.*)))
     KEEP (*(.ctors))
     PROVIDE (_ctors_end = .);
     PROVIDE (__ctors_end = .);
     PROVIDE (_dtors_start = .);
     PROVIDE (__dtors_start = .);
     PROVIDE (_dtors = .);
     PROVIDE (__dtors = .);
     KEEP (*crtbegin*.o(.dtors))
     KEEP (*(EXCLUDE_FILE (*crtend*.o) .dtors))
     KEEP (*(SORT(.dtors.*)))
     KEEP (*(.dtors))
     PROVIDE (_dtors_end = .);
     PROVIDE (__dtors_end = .);
    KEEP (*(.jcr))
    KEEP (*(.eh_frame))
    *(.gcc_except_table)
     PROVIDE(etext = .);
     PROVIDE(_etext = .);
     PROVIDE(__etext = .);
  }
  Main = DEFINED (Main) ? Main : (DEFINED (_start) ? _start : ADDR (.text));
  .stab 0 : { *(.stab) }
  .stabstr 0 : { *(.stabstr) }
  .stab.excl 0 : { *(.stab.excl) }
  .stab.exclstr 0 : { *(.stab.exclstr) }
  .stab.index 0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  .debug_info     0 : { *(.debug_info) *(.gnu.linkonce.wi.*) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  .debug_ranges   0 : { *(.debug_ranges) }
  .data  DEFINED (__.MMIX.start..data) ? __.MMIX.start..data : 0x2000000000000000:
  {
     PROVIDE(__Sdata = .);
    *(.data);
    *(.data.*)
    *(.gnu.linkonce.d*)
     PROVIDE(__Edata = .);
    /* Deprecated, use __Edata.  */
     PROVIDE(edata = .);
     PROVIDE(_edata = .);
     PROVIDE(__edata = .);
  }
  /* At the moment, although perhaps we should, we can't map sections
     without contents to sections *with* contents due to FIXME: a BFD bug.
     Anyway, the mmo back-end ignores sections without contents when
     writing out sections, so this works fine.   */
  .bss :
  {
     PROVIDE(__Sbss = .);
     PROVIDE(__bss_start = .);
     *(.sbss);
     *(.bss);
    *(.bss.*)
     *(COMMON);
     PROVIDE(__Ebss = .);
  }
  /* Deprecated, use __Ebss or __Eall as appropriate.  */
   PROVIDE(end = .);
   PROVIDE(_end = .);
   PROVIDE(__end = .);
   PROVIDE(__Eall = .);
  .MMIX.reg_contents :
  {
    /* Note that this section always has a fixed VMA - that of its
       first register * 8.  */
    *(.MMIX.reg_contents.linker_allocated);
    *(.MMIX.reg_contents);
  }
  /* By default, put the high end of the stack where the register stack
     begins.  They grow in opposite directions.  */
  PROVIDE (__Stack_start = 0x6000000000000000);
  /* Unfortunately, stabs are not mappable from ELF to MMO.
     It can probably be fixed with some amount of work.  */
  /DISCARD/ :
  { *(.gnu.warning.*); }
}
